/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.security;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.security.CipherParamsEncoder;
import org.apache.kafka.security.GcmParamsEncoder;
import org.apache.kafka.security.IvParamsEncoder;
import org.apache.kafka.security.PasswordEncoder;
import org.apache.kafka.server.util.Csv;

public class EncryptingPasswordEncoder
implements PasswordEncoder {
    private final SecureRandom secureRandom = new SecureRandom();
    private final Password secret;
    private final String keyFactoryAlgorithm;
    private final String cipherAlgorithm;
    private final int keyLength;
    private final int iterations;
    private final CipherParamsEncoder cipherParamsEncoder;

    public EncryptingPasswordEncoder(Password secret, String keyFactoryAlgorithm, String cipherAlgorithm, int keyLength, int iterations) {
        this.secret = secret;
        this.keyFactoryAlgorithm = keyFactoryAlgorithm;
        this.cipherAlgorithm = cipherAlgorithm;
        this.keyLength = keyLength;
        this.iterations = iterations;
        this.cipherParamsEncoder = this.cipherParamsInstance(cipherAlgorithm);
    }

    @Override
    public String encode(Password password) throws GeneralSecurityException {
        byte[] salt = new byte[256];
        this.secureRandom.nextBytes(salt);
        Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
        SecretKeyFactory keyFactory = this.secretKeyFactory(this.keyFactoryAlgorithm);
        SecretKeySpec keySpec = this.secretKeySpec(keyFactory, this.cipherAlgorithm, this.keyLength, salt, this.iterations);
        cipher.init(1, keySpec);
        byte[] encryptedPassword = cipher.doFinal(password.value().getBytes(StandardCharsets.UTF_8));
        HashMap<String, String> encryptedMap = new HashMap<String, String>();
        encryptedMap.put("keyFactoryAlgorithm", keyFactory.getAlgorithm());
        encryptedMap.put("cipherAlgorithm", this.cipherAlgorithm);
        encryptedMap.put("keyLength", String.valueOf(this.keyLength));
        encryptedMap.put("salt", PasswordEncoder.base64Encode(salt));
        encryptedMap.put("iterations", String.valueOf(this.iterations));
        encryptedMap.put("encryptedPassword", PasswordEncoder.base64Encode(encryptedPassword));
        encryptedMap.put("passwordLength", String.valueOf(password.value().length()));
        encryptedMap.putAll(this.cipherParamsEncoder.toMap(cipher.getParameters()));
        return encryptedMap.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).collect(Collectors.joining(","));
    }

    @Override
    public Password decode(String encodedPassword) throws GeneralSecurityException {
        Map<String, String> params = Csv.parseCsvMap(encodedPassword);
        String keyFactoryAlg = params.get("keyFactoryAlgorithm");
        String cipherAlg = params.get("cipherAlgorithm");
        int keyLength = Integer.parseInt(params.get("keyLength"));
        byte[] salt = PasswordEncoder.base64Decode(params.get("salt"));
        int iterations = Integer.parseInt(params.get("iterations"));
        byte[] encryptedPassword = PasswordEncoder.base64Decode(params.get("encryptedPassword"));
        int passwordLengthProp = Integer.parseInt(params.get("passwordLength"));
        Cipher cipher = Cipher.getInstance(cipherAlg);
        SecretKeyFactory keyFactory = this.secretKeyFactory(keyFactoryAlg);
        SecretKeySpec keySpec = this.secretKeySpec(keyFactory, cipherAlg, keyLength, salt, iterations);
        cipher.init(2, (Key)keySpec, this.cipherParamsEncoder.toParameterSpec(params));
        try {
            byte[] decrypted = cipher.doFinal(encryptedPassword);
            String password = new String(decrypted, StandardCharsets.UTF_8);
            if (password.length() != passwordLengthProp) {
                throw new ConfigException("Password could not be decoded, sanity check of length failed");
            }
            return new Password(password);
        }
        catch (Exception e) {
            throw new ConfigException("Password could not be decoded", (Object)e);
        }
    }

    private SecretKeyFactory secretKeyFactory(String keyFactoryAlg) throws NoSuchAlgorithmException {
        if (keyFactoryAlg != null) {
            return SecretKeyFactory.getInstance(keyFactoryAlg);
        }
        try {
            return SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        }
        catch (NoSuchAlgorithmException nsae) {
            return SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        }
    }

    private SecretKeySpec secretKeySpec(SecretKeyFactory keyFactory, String cipherAlg, int keyLength, byte[] salt, int iterations) throws InvalidKeySpecException {
        PBEKeySpec keySpec = new PBEKeySpec(this.secret.value().toCharArray(), salt, iterations, keyLength);
        String algorithm = cipherAlg.indexOf(47) > 0 ? cipherAlg.substring(0, cipherAlg.indexOf(47)) : cipherAlg;
        return new SecretKeySpec(keyFactory.generateSecret(keySpec).getEncoded(), algorithm);
    }

    private CipherParamsEncoder cipherParamsInstance(String cipherAlgorithm) {
        if (cipherAlgorithm.startsWith("AES/GCM/")) {
            return new GcmParamsEncoder();
        }
        return new IvParamsEncoder();
    }
}

