/*
 * Decompiled with CFR 0.152.
 */
package spark.staticfiles;

import java.nio.file.Paths;
import spark.utils.StringUtils;

public class DirectoryTraversal {
    public static void protectAgainstInClassPath(String path, String localFolder) {
        if (!DirectoryTraversal.isPathWithinFolder(path, localFolder)) {
            throw new DirectoryTraversalDetection("classpath");
        }
    }

    public static void protectAgainstForExternal(String path, String externalFolder) {
        String unixLikeFolder = DirectoryTraversal.unixifyPath(externalFolder);
        String nixLikePath = DirectoryTraversal.unixifyPath(path);
        if (!DirectoryTraversal.isPathWithinFolder(nixLikePath, unixLikeFolder)) {
            throw new DirectoryTraversalDetection("external");
        }
    }

    private static String unixifyPath(String path) {
        return Paths.get(path, new String[0]).toAbsolutePath().toString().replace("\\", "/");
    }

    private static boolean isPathWithinFolder(String path, String folder) {
        String rlatsPath = StringUtils.removeLeadingAndTrailingSlashesFrom(path);
        String rlatsFolder = StringUtils.removeLeadingAndTrailingSlashesFrom(folder);
        return rlatsPath.startsWith(rlatsFolder);
    }

    public static final class DirectoryTraversalDetection
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DirectoryTraversalDetection(String msg) {
            super(msg);
        }
    }
}

