/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.error;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Error;

public class Unprepared
extends Error {
    public final byte[] id;

    public Unprepared(String message, byte[] id) {
        super(9472, message);
        this.id = id;
    }

    public static class SubCodec
    extends Error.SubCodec {
        public SubCodec(int protocolVersion) {
            super(9472, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
            Unprepared unprepared = (Unprepared)message;
            encoder.writeString(unprepared.message, dest);
            encoder.writeShortBytes(unprepared.id, dest);
        }

        @Override
        public int encodedSize(Message message) {
            Unprepared unprepared = (Unprepared)message;
            return PrimitiveSizes.sizeOfString(unprepared.message) + PrimitiveSizes.sizeOfShortBytes(unprepared.id);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
            String message = decoder.readString(source);
            byte[] id = decoder.readShortBytes(source);
            return new Unprepared(message, id);
        }
    }
}

