/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.transfer.s3.internal.TransferConfigurationOption;
import software.amazon.awssdk.transfer.s3.model.UploadDirectoryRequest;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.ExecutorUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
public class TransferManagerConfiguration
implements SdkAutoCloseable {
    private final AttributeMap options;

    private TransferManagerConfiguration(Builder builder) {
        AttributeMap.Builder standardOptions = AttributeMap.builder();
        standardOptions.put(TransferConfigurationOption.UPLOAD_DIRECTORY_FOLLOW_SYMBOLIC_LINKS, (Object)builder.uploadDirectoryFollowSymbolicLinks);
        standardOptions.put(TransferConfigurationOption.UPLOAD_DIRECTORY_MAX_DEPTH, (Object)builder.uploadDirectoryMaxDepth);
        this.finalizeExecutor(builder, standardOptions);
        this.options = standardOptions.build().merge(TransferConfigurationOption.TRANSFER_MANAGER_DEFAULTS);
    }

    private void finalizeExecutor(Builder builder, AttributeMap.Builder standardOptions) {
        if (builder.executor != null) {
            standardOptions.put(TransferConfigurationOption.EXECUTOR, (Object)ExecutorUtils.unmanagedExecutor((Executor)builder.executor));
        } else {
            standardOptions.put(TransferConfigurationOption.EXECUTOR, (Object)this.defaultExecutor());
        }
    }

    public <T> T option(TransferConfigurationOption<T> option) {
        return (T)this.options.get(option);
    }

    public boolean resolveUploadDirectoryFollowSymbolicLinks(UploadDirectoryRequest request) {
        return request.followSymbolicLinks().orElseGet(() -> (Boolean)this.options.get(TransferConfigurationOption.UPLOAD_DIRECTORY_FOLLOW_SYMBOLIC_LINKS));
    }

    public int resolveUploadDirectoryMaxDepth(UploadDirectoryRequest request) {
        return request.maxDepth().orElseGet(() -> (Integer)this.options.get(TransferConfigurationOption.UPLOAD_DIRECTORY_MAX_DEPTH));
    }

    public void close() {
        this.options.close();
    }

    private Executor defaultExecutor() {
        int maxPoolSize = 100;
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, maxPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().threadNamePrefix("s3-transfer-manager").build());
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean uploadDirectoryFollowSymbolicLinks;
        private Integer uploadDirectoryMaxDepth;
        private Executor executor;

        public Builder uploadDirectoryFollowSymbolicLinks(Boolean uploadDirectoryFollowSymbolicLinks) {
            this.uploadDirectoryFollowSymbolicLinks = uploadDirectoryFollowSymbolicLinks;
            return this;
        }

        public Builder uploadDirectoryMaxDepth(Integer uploadDirectoryMaxDepth) {
            this.uploadDirectoryMaxDepth = uploadDirectoryMaxDepth;
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public TransferManagerConfiguration build() {
            return new TransferManagerConfiguration(this);
        }
    }
}

