/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.collection;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.baremaps.data.collection.DataCollectionException;
import org.apache.baremaps.data.collection.DataList;
import org.apache.baremaps.data.memory.Memory;
import org.apache.baremaps.data.memory.OffHeapMemory;
import org.apache.baremaps.data.type.FixedSizeDataType;

public class FixedSizeDataList<E>
implements DataList<E> {
    private final FixedSizeDataType<E> dataType;
    private final Memory<?> memory;
    private AtomicLong size;

    public FixedSizeDataList(FixedSizeDataType<E> dataType) {
        this(dataType, new OffHeapMemory());
    }

    public FixedSizeDataList(FixedSizeDataType<E> dataType, Memory<?> memory) {
        if (dataType.size() > memory.segmentSize()) {
            throw new DataCollectionException("The segment size is too small for the data type");
        }
        this.dataType = dataType;
        this.memory = memory;
        this.size = new AtomicLong(0L);
    }

    private void write(long index, E value) {
        long position = index * (long)this.dataType.size();
        int segmentIndex = (int)(position / (long)this.memory.segmentSize());
        int segmentOffset = (int)(position % (long)this.memory.segmentSize());
        ByteBuffer segment = this.memory.segment(segmentIndex);
        this.dataType.write(segment, segmentOffset, value);
    }

    @Override
    public long addIndexed(E value) {
        long index = this.size.getAndIncrement();
        this.write(index, value);
        return index;
    }

    @Override
    public void set(long index, E value) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.write(index, value);
    }

    @Override
    public E get(long index) {
        long position = index * (long)this.dataType.size();
        int segmentIndex = (int)(position / (long)this.memory.segmentSize());
        int segmentOffset = (int)(position % (long)this.memory.segmentSize());
        ByteBuffer segment = this.memory.segment(segmentIndex);
        return (E)this.dataType.read(segment, segmentOffset);
    }

    @Override
    public long size() {
        return this.size.get();
    }

    @Override
    public void clear() {
        this.size.set(0L);
    }
}

