/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.armeria.common.sse.ServerSentEvent;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.ProducesEventStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.stream.Stream;
import org.apache.baremaps.config.ConfigReader;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Sinks;

public final class ChangeResource {
    private static final Logger logger = LoggerFactory.getLogger(ChangeResource.class);
    private final ConfigReader configReader = new ConfigReader();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Path tileset;
    private final Path style;
    private final Thread thread;
    private final Sinks.Many<ServerSentEvent> changes = Sinks.many().multicast().directBestEffort();

    public ChangeResource(Path tileset, Path style) {
        this.tileset = tileset;
        this.style = style;
        this.thread = new Thread(new ChangeListener());
        this.thread.start();
    }

    @Get(value="/changes")
    @ProducesEventStream
    public Publisher<ServerSentEvent> changes(ServiceRequestContext ctx) {
        ctx.clearRequestTimeout();
        return this.changes.asFlux();
    }

    class ChangeListener
    implements Runnable {
        ChangeListener() {
        }

        @Override
        public void run() {
            try (WatchService watchService = FileSystems.getDefault().newWatchService();){
                WatchKey key;
                if (ChangeResource.this.tileset != null && Files.exists(ChangeResource.this.tileset, new LinkOption[0])) {
                    this.registerRecursively(ChangeResource.this.tileset.toAbsolutePath().getParent(), watchService);
                }
                if (ChangeResource.this.style != null && Files.exists(ChangeResource.this.style, new LinkOption[0])) {
                    this.registerRecursively(ChangeResource.this.style.toAbsolutePath().getParent(), watchService);
                }
                while ((key = watchService.take()) != null) {
                    Path dir = (Path)key.watchable();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path path = dir.resolve((Path)event.context()).toAbsolutePath();
                        logger.info("Change detected in {}", (Object)path);
                        if (ChangeResource.this.style == null) continue;
                        String value = ChangeResource.this.configReader.read(ChangeResource.this.style);
                        ObjectNode styleObjectNode = (ObjectNode)ChangeResource.this.objectMapper.readValue(value, ObjectNode.class);
                        if (ChangeResource.this.tileset != null && path.endsWith(ChangeResource.this.tileset.getFileName())) {
                            styleObjectNode.put("reload", true);
                        }
                        ChangeResource.this.changes.tryEmitNext((Object)ServerSentEvent.ofData((String)styleObjectNode.toString()));
                    }
                    key.reset();
                }
            }
            catch (IOException | InterruptedException e) {
                logger.error(e.getMessage());
                Thread.currentThread().interrupt();
            }
        }

        private void registerRecursively(Path directory, WatchService watchService) throws IOException {
            try (Stream<Path> directories = Files.walk(directory, new FileVisitOption[0]);){
                directories.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(path -> {
                    try {
                        path.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage());
                    }
                });
            }
        }
    }
}

