/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.sis.metadata.sql.util.ScriptRunner;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.StringBuilders;

final class Installer
extends ScriptRunner {
    private final String[] enumTypes;

    Installer(Connection connection) throws SQLException {
        super(connection, 100);
        if (this.isEnumTypeSupported) {
            this.enumTypes = null;
        } else {
            this.enumTypes = new String[]{"RoleCode", "DateTypeCode", "PresentationFormCode", "OnLineFunctionCode", "TransferFunctionTypeCode", "AxisDirection"};
            for (int i = 0; i < this.enumTypes.length; ++i) {
                this.enumTypes[i] = "metadata.\"" + this.enumTypes[i] + "\"";
            }
        }
    }

    public void run() throws IOException, SQLException {
        String[] scripts;
        for (String filename : scripts = new String[]{"Citations.sql", "Contents.sql", "Metadata.sql", "Referencing.sql"}) {
            this.run(filename, Installer.class.getResourceAsStream(filename));
        }
    }

    @Override
    protected int execute(StringBuilder sql) throws SQLException, IOException {
        if (!this.isEnumTypeSupported && CharSequences.startsWith((CharSequence)sql, (CharSequence)"CREATE TABLE", (boolean)true)) {
            for (String type : this.enumTypes) {
                StringBuilders.replace((StringBuilder)sql, (String)type, (String)"VARCHAR(25)");
            }
        }
        return super.execute(sql);
    }
}

