/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tasks;

import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteSql
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteSql.class);
    private Object database;
    private Path file;
    private boolean parallel = false;

    public ExecuteSql() {
    }

    public ExecuteSql(Object database, Path file, boolean parallel) {
        this.database = database;
        this.file = file;
        this.parallel = parallel;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        String script = ExecuteSql.clean(Files.readString(this.file));
        Stream queries = ExecuteSql.split(script);
        if (this.parallel) {
            queries = (Stream)queries.parallel();
        }
        queries.forEach(query -> {
            DataSource dataSource = context.getDataSource(this.database);
            try (Connection connection = dataSource.getConnection();){
                logger.info("Execute SQL query: {}", (Object)query.replaceAll("\\s+", " "));
                connection.createStatement().execute((String)query);
            }
            catch (SQLException e) {
                logger.error("Failed to execute query: {}", (Object)query.replaceAll("\\s+", " "));
                throw new WorkflowException(e);
            }
        });
    }

    public static Stream<String> split(String sql) {
        return Arrays.stream(sql.split("\\s*;\\s*(?=(?:[^']*'[^']*')*[^']*$)"));
    }

    public static String clean(String sql) {
        String result = sql;
        Pattern singleLineCommentPattern = Pattern.compile("--.*", 8);
        Matcher singleLineCommentMatcher = singleLineCommentPattern.matcher(result);
        result = singleLineCommentMatcher.replaceAll("");
        Pattern multiLineCommentPattern = Pattern.compile("/\\*.*?\\*/", 32);
        Matcher multiLineMatcher = multiLineCommentPattern.matcher(result);
        result = multiLineMatcher.replaceAll("");
        return result;
    }

    public String toString() {
        return new StringJoiner(", ", ExecuteSql.class.getSimpleName() + "[", "]").add("database=" + this.database).add("file=" + this.file).add("parallel=" + this.parallel).toString();
    }
}

