/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.algorithm;

import java.util.Comparator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class Hilbert {
    private static final int HILBERT_MAX = 65535;

    private Hilbert() {
    }

    public static long hibert(Envelope envelope, int hilbertMax, double minX, double minY, double width, double height) {
        long x = 0L;
        long y = 0L;
        if (width != 0.0) {
            x = (long)Math.floor((double)hilbertMax * ((envelope.getMinX() + envelope.getMaxX()) / 2.0 - minX) / width);
        }
        if (height != 0.0) {
            y = (long)Math.floor((double)hilbertMax * ((envelope.getMinY() + envelope.getMaxY()) / 2.0 - minY) / height);
        }
        return Hilbert.hibert(x, y);
    }

    private static long hibert(long x, long y) {
        long a = x ^ y;
        long b = 0xFFFFL ^ a;
        long c = 0xFFFFL ^ (x | y);
        long d = x & (y ^ 0xFFFFL);
        long A = a | b >> 1;
        long B = a >> 1 ^ a;
        long C = c >> 1 ^ b & d >> 1 ^ c;
        long D = a & c >> 1 ^ d >> 1 ^ d;
        a = A;
        b = B;
        c = C;
        d = D;
        A = a & a >> 2 ^ b & b >> 2;
        B = a & b >> 2 ^ b & (a ^ b) >> 2;
        C ^= a & c >> 2 ^ b & d >> 2;
        D ^= b & c >> 2 ^ (a ^ b) & d >> 2;
        a = A;
        b = B;
        c = C;
        d = D;
        A = a & a >> 4 ^ b & b >> 4;
        B = a & b >> 4 ^ b & (a ^ b) >> 4;
        C ^= a & c >> 4 ^ b & d >> 4;
        D ^= b & c >> 4 ^ (a ^ b) & d >> 4;
        a = A;
        b = B;
        c = C;
        d = D;
        C ^= a & c >> 8 ^ b & d >> 8;
        D ^= b & c >> 8 ^ (a ^ b) & d >> 8;
        a = C ^ C >> 1;
        b = D ^ D >> 1;
        long i0 = x ^ y;
        long i1 = b | 0xFFFFL ^ (i0 | a);
        i0 = (i0 | i0 << 8) & 0xFF00FFL;
        i0 = (i0 | i0 << 4) & 0xF0F0F0FL;
        i0 = (i0 | i0 << 2) & 0x33333333L;
        i0 = (i0 | i0 << 1) & 0x55555555L;
        i1 = (i1 | i1 << 8) & 0xFF00FFL;
        i1 = (i1 | i1 << 4) & 0xF0F0F0FL;
        i1 = (i1 | i1 << 2) & 0x33333333L;
        i1 = (i1 | i1 << 1) & 0x55555555L;
        long value = i1 << 1 | i0;
        return value;
    }

    public static class HilberComparator
    implements Comparator<Geometry> {
        private final double minX;
        private final double minY;
        private final double width;
        private final double height;

        public HilberComparator(double minX, double minY, double width, double height) {
            this.minX = minX;
            this.minY = minY;
            this.width = width;
            this.height = height;
        }

        @Override
        public int compare(Geometry a, Geometry b) {
            long hb;
            long ha = Hilbert.hibert(a.getEnvelopeInternal(), 65535, this.minX, this.minY, this.width, this.height);
            return ha - (hb = Hilbert.hibert(b.getEnvelopeInternal(), 65535, this.minX, this.minY, this.width, this.height)) > 0L ? 1 : (ha - hb == 0L ? 0 : -1);
        }
    }
}

