/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.ProducesJson;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResource {
    private static final Logger logger = LoggerFactory.getLogger(SearchResource.class);
    private static final String SEARCH_QUERY = "SELECT id, tags, st_asewkt(st_transform(geom, 'EPSG:4326')), ts_rank_cd(to_tsvector('english', tags), query) as rank\nFROM osm_entities, phraseto_tsquery('english', ?) as query\nWHERE to_tsvector('english', tags) @@ query\nORDER BY rank DESC\nLIMIT ?;\n";
    private final DataSource dataSource;

    public SearchResource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Get(value="/api/search")
    @ProducesJson
    public HttpResponse search(@Param(value="query") String queryText, @Param(value="limit") @Default(value="10") int limit) {
        try (Connection connection = this.dataSource.getConnection();){
            HttpResponse httpResponse;
            block22: {
                PreparedStatement statement = connection.prepareStatement(SEARCH_QUERY);
                try {
                    statement.setString(1, queryText);
                    statement.setInt(2, limit);
                    ArrayList<SearchResult> list = new ArrayList<SearchResult>();
                    try (ResultSet result = statement.executeQuery();){
                        while (result.next()) {
                            long id = result.getLong(1);
                            String json = result.getString(2);
                            JsonNode tags = new ObjectMapper().readTree(json);
                            String wkt = result.getString(3);
                            double rank = result.getDouble(4);
                            list.add(new SearchResult(id, tags, wkt, rank));
                        }
                    }
                    SearchResponse response = new SearchResponse(list);
                    httpResponse = HttpResponse.ofJson((Object)response);
                    if (statement == null) break block22;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return httpResponse;
        }
        catch (JsonProcessingException | SQLException e) {
            logger.error("Error while searching", e);
            return HttpResponse.of((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    record SearchResult(long id, JsonNode tags, String wkt, double score) {
    }

    record SearchResponse(List<SearchResult> results) {
    }
}

