/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.healthcheck;

import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.AbstractHealthCheckedEndpointGroupBuilder;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckerContext;
import com.linecorp.armeria.common.util.AsyncCloseable;
import com.linecorp.armeria.internal.client.endpoint.healthcheck.HttpHealthChecker;
import java.util.Objects;
import java.util.function.Function;

public final class HealthCheckedEndpointGroupBuilder
extends AbstractHealthCheckedEndpointGroupBuilder<HealthCheckedEndpointGroupBuilder> {
    private final String path;
    private boolean useGet;

    HealthCheckedEndpointGroupBuilder(EndpointGroup delegate, String path) {
        super(delegate);
        this.path = Objects.requireNonNull(path, "path");
    }

    public HealthCheckedEndpointGroupBuilder useGet(boolean useGet) {
        this.useGet = useGet;
        return this;
    }

    @Override
    protected Function<? super HealthCheckerContext, ? extends AsyncCloseable> newCheckerFactory() {
        return new HttpHealthCheckerFactory(this.path, this.useGet);
    }

    private static class HttpHealthCheckerFactory
    implements Function<HealthCheckerContext, AsyncCloseable> {
        private final String path;
        private final boolean useGet;

        HttpHealthCheckerFactory(String path, boolean useGet) {
            this.path = path;
            this.useGet = useGet;
        }

        @Override
        public AsyncCloseable apply(HealthCheckerContext ctx) {
            HttpHealthChecker checker = new HttpHealthChecker(ctx, ctx.endpoint(), this.path, this.useGet, ctx.protocol(), null);
            checker.start();
            return checker;
        }
    }
}

