/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.BlockingHttpClient;
import io.servicetalk.http.api.BlockingStreamingHttpClient;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpClient;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpContextKeys;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.ReservedBlockingHttpConnection;
import io.servicetalk.http.api.ReservedBlockingStreamingHttpConnection;
import io.servicetalk.http.api.ReservedHttpConnection;
import io.servicetalk.http.api.ReservedStreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;

final class FilterableClientToClient
implements StreamingHttpClient {
    private final FilterableStreamingHttpClient client;
    private final HttpExecutionContext executionContext;

    FilterableClientToClient(FilterableStreamingHttpClient filteredClient, HttpExecutionContext executionContext) {
        this.client = filteredClient;
        this.executionContext = executionContext;
    }

    public HttpClient asClient() {
        return HttpApiConversions.toClient((StreamingHttpClient)this, (HttpExecutionStrategy)this.executionContext.executionStrategy());
    }

    public BlockingStreamingHttpClient asBlockingStreamingClient() {
        return HttpApiConversions.toBlockingStreamingClient((StreamingHttpClient)this, (HttpExecutionStrategy)this.executionContext.executionStrategy());
    }

    public BlockingHttpClient asBlockingClient() {
        return HttpApiConversions.toBlockingClient((StreamingHttpClient)this, (HttpExecutionStrategy)this.executionContext.executionStrategy());
    }

    public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
        return Single.defer(() -> {
            request.context().putIfAbsent(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY, (Object)this.executionContext().executionStrategy());
            return this.client.request(request).shareContextOnSubscribe();
        });
    }

    public Single<ReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
        return Single.defer(() -> {
            final HttpExecutionStrategy clientstrategy = this.executionContext().executionStrategy();
            metaData.context().putIfAbsent(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY, (Object)clientstrategy);
            return this.client.reserveConnection(metaData).map(rc -> new ReservedStreamingHttpConnection((FilterableReservedStreamingHttpConnection)rc){
                final /* synthetic */ FilterableReservedStreamingHttpConnection val$rc;
                {
                    this.val$rc = filterableReservedStreamingHttpConnection;
                }

                public ReservedHttpConnection asConnection() {
                    return HttpApiConversions.toReservedConnection((ReservedStreamingHttpConnection)this, (HttpExecutionStrategy)clientstrategy);
                }

                public ReservedBlockingStreamingHttpConnection asBlockingStreamingConnection() {
                    return HttpApiConversions.toReservedBlockingStreamingConnection((ReservedStreamingHttpConnection)this, (HttpExecutionStrategy)clientstrategy);
                }

                public ReservedBlockingHttpConnection asBlockingConnection() {
                    return HttpApiConversions.toReservedBlockingConnection((ReservedStreamingHttpConnection)this, (HttpExecutionStrategy)clientstrategy);
                }

                public Completable releaseAsync() {
                    return this.val$rc.releaseAsync();
                }

                public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                    return Single.defer(() -> {
                        request.context().putIfAbsent(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY, (Object)clientstrategy);
                        return this.val$rc.request(request).shareContextOnSubscribe();
                    });
                }

                public HttpConnectionContext connectionContext() {
                    return this.val$rc.connectionContext();
                }

                public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> eventKey) {
                    return this.val$rc.transportEventStream(eventKey);
                }

                public HttpExecutionContext executionContext() {
                    return this.val$rc.executionContext();
                }

                public StreamingHttpResponseFactory httpResponseFactory() {
                    return this.val$rc.httpResponseFactory();
                }

                public Completable onClose() {
                    return this.val$rc.onClose();
                }

                public Completable closeAsync() {
                    return this.val$rc.closeAsync();
                }

                public Completable closeAsyncGracefully() {
                    return this.val$rc.closeAsyncGracefully();
                }

                public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
                    return this.val$rc.newRequest(method, requestTarget);
                }
            }).shareContextOnSubscribe();
        });
    }

    public HttpExecutionContext executionContext() {
        return this.executionContext;
    }

    public StreamingHttpResponseFactory httpResponseFactory() {
        return this.client.httpResponseFactory();
    }

    public Completable onClose() {
        return this.client.onClose();
    }

    public Completable closeAsync() {
        return this.client.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.client.closeAsyncGracefully();
    }

    public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
        return this.client.newRequest(method, requestTarget);
    }
}

