/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import java.util.function.Predicate;

final class ConditionalHttpConnectionFilter
extends StreamingHttpConnectionFilter {
    private final Predicate<StreamingHttpRequest> predicate;
    private final FilterableStreamingHttpConnection predicatedConnection;
    private final ListenableAsyncCloseable closeable;

    ConditionalHttpConnectionFilter(Predicate<StreamingHttpRequest> predicate, FilterableStreamingHttpConnection predicatedConnection, FilterableStreamingHttpConnection connection) {
        super(connection);
        this.predicate = predicate;
        this.predicatedConnection = predicatedConnection;
        CompositeCloseable compositeCloseable = AsyncCloseables.newCompositeCloseable();
        compositeCloseable.append((AsyncCloseable)predicatedConnection);
        compositeCloseable.append((AsyncCloseable)connection);
        this.closeable = AsyncCloseables.toListenableAsyncCloseable((AsyncCloseable)compositeCloseable);
    }

    public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
        boolean b;
        try {
            b = this.predicate.test(request);
        }
        catch (Throwable t) {
            return Single.failed((Throwable)t);
        }
        if (b) {
            return this.predicatedConnection.request(request);
        }
        return this.delegate().request(request);
    }

    public Completable closeAsync() {
        return this.closeable.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.closeable.closeAsyncGracefully();
    }

    public Completable onClose() {
        return this.closeable.onClose();
    }
}

