/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import java.util.function.Predicate;

final class ConditionalHttpClientFilter
extends StreamingHttpClientFilter {
    private final Predicate<StreamingHttpRequest> predicate;
    private final FilterableStreamingHttpClient predicatedClient;
    private final ListenableAsyncCloseable closeable;

    ConditionalHttpClientFilter(Predicate<StreamingHttpRequest> predicate, FilterableStreamingHttpClient predicatedClient, FilterableStreamingHttpClient client) {
        super(client);
        this.predicate = predicate;
        this.predicatedClient = predicatedClient;
        CompositeCloseable compositeCloseable = AsyncCloseables.newCompositeCloseable();
        compositeCloseable.append((AsyncCloseable)predicatedClient);
        compositeCloseable.append((AsyncCloseable)client);
        this.closeable = AsyncCloseables.toListenableAsyncCloseable((AsyncCloseable)compositeCloseable);
    }

    protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
        boolean b;
        try {
            b = this.predicate.test(request);
        }
        catch (Throwable t) {
            return Single.failed((Throwable)t);
        }
        if (b) {
            return this.predicatedClient.request(request);
        }
        return delegate.request(request);
    }

    public Completable closeAsync() {
        return this.closeable.closeAsync();
    }

    public Completable closeAsyncGracefully() {
        return this.closeable.closeAsyncGracefully();
    }

    public Completable onClose() {
        return this.closeable.onClose();
    }
}

