/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.nga.style;

import java.awt.image.BufferedImage;
import java.io.IOException;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.nga.style.IconTable;
import mil.nga.geopackage.extension.related.media.MediaRow;
import mil.nga.geopackage.extension.related.media.MediaTable;
import mil.nga.geopackage.user.custom.UserCustomColumn;
import mil.nga.geopackage.user.custom.UserCustomRow;

public class IconRow
extends MediaRow {
    private boolean tableIcon;

    public IconRow() {
        this(new IconTable());
    }

    public IconRow(IconTable table) {
        super((MediaTable)table);
    }

    public IconRow(UserCustomRow userCustomRow) {
        super(userCustomRow);
    }

    public IconRow(IconRow iconRow) {
        super(iconRow);
    }

    public IconTable getTable() {
        return (IconTable)super.getTable();
    }

    public boolean isTableIcon() {
        return this.tableIcon;
    }

    public void setTableIcon(boolean tableIcon) {
        this.tableIcon = tableIcon;
    }

    public int getNameColumnIndex() {
        return this.getColumns().getColumnIndex("name");
    }

    public UserCustomColumn getNameColumn() {
        return (UserCustomColumn)this.getColumns().getColumn("name");
    }

    public String getName() {
        return this.getValueString(this.getNameColumnIndex());
    }

    public void setName(String name) {
        this.setValue(this.getNameColumnIndex(), name);
    }

    public int getDescriptionColumnIndex() {
        return this.getColumns().getColumnIndex("description");
    }

    public UserCustomColumn getDescriptionColumn() {
        return (UserCustomColumn)this.getColumns().getColumn("description");
    }

    public String getDescription() {
        return this.getValueString(this.getDescriptionColumnIndex());
    }

    public void setDescription(String description) {
        this.setValue(this.getDescriptionColumnIndex(), description);
    }

    public int getWidthColumnIndex() {
        return this.getColumns().getColumnIndex("width");
    }

    public UserCustomColumn getWidthColumn() {
        return (UserCustomColumn)this.getColumns().getColumn("width");
    }

    public Double getWidth() {
        return (Double)this.getValue(this.getWidthColumnIndex());
    }

    public void setWidth(Double width) {
        if (width != null && width < 0.0) {
            throw new GeoPackageException("Width must be greater than or equal to 0.0, invalid value: " + width);
        }
        this.setValue(this.getWidthColumnIndex(), width);
    }

    public double getDerivedWidth() {
        Double width = this.getWidth();
        if (width == null) {
            width = this.getDerivedDimensions()[0];
        }
        return width;
    }

    public int getHeightColumnIndex() {
        return this.getColumns().getColumnIndex("height");
    }

    public UserCustomColumn getHeightColumn() {
        return (UserCustomColumn)this.getColumns().getColumn("height");
    }

    public Double getHeight() {
        return (Double)this.getValue(this.getHeightColumnIndex());
    }

    public void setHeight(Double height) {
        if (height != null && height < 0.0) {
            throw new GeoPackageException("Height must be greater than or equal to 0.0, invalid value: " + height);
        }
        this.setValue(this.getHeightColumnIndex(), height);
    }

    public double getDerivedHeight() {
        Double height = this.getHeight();
        if (height == null) {
            height = this.getDerivedDimensions()[1];
        }
        return height;
    }

    public double[] getDerivedDimensions() {
        Double width = this.getWidth();
        Double height = this.getHeight();
        if (width == null || height == null) {
            int dataHeight;
            int dataWidth;
            try {
                BufferedImage image = this.getDataImage();
                dataWidth = image.getWidth();
                dataHeight = image.getHeight();
            }
            catch (IOException e) {
                throw new GeoPackageException("Failed to read the data image", (Throwable)e);
            }
            if (width == null) {
                width = dataWidth;
                if (height != null) {
                    width = width * (height / (double)dataHeight);
                }
            }
            if (height == null) {
                height = dataHeight;
                if (width != null) {
                    height = height * (width / (double)dataWidth);
                }
            }
        }
        return new double[]{width, height};
    }

    public int getAnchorUColumnIndex() {
        return this.getColumns().getColumnIndex("anchor_u");
    }

    public UserCustomColumn getAnchorUColumn() {
        return (UserCustomColumn)this.getColumns().getColumn("anchor_u");
    }

    public Double getAnchorU() {
        return (Double)this.getValue(this.getAnchorUColumnIndex());
    }

    public void setAnchorU(Double anchor) {
        this.validateAnchor(anchor);
        this.setValue(this.getAnchorUColumnIndex(), anchor);
    }

    public double getAnchorUOrDefault() {
        Double anchorU = this.getAnchorU();
        if (anchorU == null) {
            anchorU = 0.5;
        }
        return anchorU;
    }

    public int getAnchorVColumnIndex() {
        return this.getColumns().getColumnIndex("anchor_v");
    }

    public UserCustomColumn getAnchorVColumn() {
        return (UserCustomColumn)this.getColumns().getColumn("anchor_v");
    }

    public Double getAnchorV() {
        return (Double)this.getValue(this.getAnchorVColumnIndex());
    }

    public void setAnchorV(Double anchor) {
        this.validateAnchor(anchor);
        this.setValue(this.getAnchorVColumnIndex(), anchor);
    }

    public double getAnchorVOrDefault() {
        Double anchorV = this.getAnchorV();
        if (anchorV == null) {
            anchorV = 1.0;
        }
        return anchorV;
    }

    private void validateAnchor(Double anchor) {
        if (anchor != null && (anchor < 0.0 || anchor > 1.0)) {
            throw new GeoPackageException("Anchor must be set inclusively between 0.0 and 1.0, invalid value: " + anchor);
        }
    }

    @Override
    public IconRow copy() {
        return new IconRow(this);
    }
}

