/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.sql.DataSource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseBroadcaster;
import javax.ws.rs.sse.SseEventSink;
import org.apache.baremaps.database.tile.PostgresTileStore;
import org.apache.baremaps.database.tile.Tile;
import org.apache.baremaps.mvt.style.Style;
import org.apache.baremaps.mvt.tileset.Tileset;
import org.apache.baremaps.server.ConfigReader;
import org.apache.baremaps.server.DirectoryWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/")
public class DevResources {
    private static final Logger logger = LoggerFactory.getLogger(DevResources.class);
    private final ConfigReader configReader = new ConfigReader();
    private final java.nio.file.Path style;
    private final java.nio.file.Path tileset;
    private final DataSource dataSource;
    private final ObjectMapper objectMapper;
    private final Sse sse;
    private final SseBroadcaster sseBroadcaster;
    private final OutboundSseEvent.Builder sseEventBuilder;
    public static final String TILE_ENCODING = "gzip";
    public static final String TILE_TYPE = "application/vnd.mapbox-vector-tile";

    @Inject
    public DevResources(@Named(value="tileset") java.nio.file.Path tileset, @Named(value="style") java.nio.file.Path style, DataSource dataSource, ObjectMapper objectMapper, Sse sse) {
        this.tileset = tileset.toAbsolutePath();
        this.style = style.toAbsolutePath();
        this.dataSource = dataSource;
        this.objectMapper = objectMapper;
        this.sse = sse;
        this.sseBroadcaster = sse.newBroadcaster();
        this.sseEventBuilder = sse.newEventBuilder();
        HashSet<java.nio.file.Path> directories = new HashSet<java.nio.file.Path>(Arrays.asList(tileset.getParent(), style.getParent()));
        new Thread(new DirectoryWatcher(directories, this::broadcastChanges)).start();
    }

    public void broadcastChanges(java.nio.file.Path path) {
        try {
            String value = this.configReader.read(this.style);
            ObjectNode styleObjectNode = (ObjectNode)this.objectMapper.readValue(value, ObjectNode.class);
            styleObjectNode.put("reload", path.endsWith(this.tileset.getFileName()));
            this.sseBroadcaster.broadcast(this.sseEventBuilder.data((Object)styleObjectNode.toString()).build());
        }
        catch (IOException e) {
            logger.error("Unable to broadcast change", (Throwable)e);
        }
    }

    @GET
    @Path(value="changes")
    @Produces(value={"text/event-stream"})
    public void changes(@Context SseEventSink sseEventSink) {
        this.sseBroadcaster.register(sseEventSink);
    }

    @GET
    @Path(value="style.json")
    @Produces(value={"application/json"})
    public Style getStyle() throws IOException {
        String config = this.configReader.read(this.style);
        Style object = (Style)this.objectMapper.readValue(config, Style.class);
        return object;
    }

    @GET
    @Path(value="tiles.json")
    @Produces(value={"application/json"})
    public Tileset getTileset() throws IOException {
        String config = this.configReader.read(this.tileset);
        Tileset object = (Tileset)this.objectMapper.readValue(config, Tileset.class);
        return object;
    }

    @GET
    @Path(value="/tiles/{z}/{x}/{y}.mvt")
    public Response getTile(@PathParam(value="z") int z, @PathParam(value="x") int x, @PathParam(value="y") int y) {
        try {
            PostgresTileStore tileStore = new PostgresTileStore(this.dataSource, this.getTileset());
            Tile tile = new Tile(x, y, z);
            ByteBuffer blob = tileStore.read(tile);
            if (blob != null) {
                return Response.status((int)200).header("Content-Type", (Object)TILE_TYPE).header("Content-Encoding", (Object)TILE_ENCODING).entity((Object)blob.array()).build();
            }
            return Response.status((int)204).build();
        }
        catch (Exception ex) {
            logger.error("Tile error", (Throwable)ex);
            return Response.status((int)404).build();
        }
    }

    @GET
    @Path(value="{path:.*}")
    public Response get(@PathParam(value="path") String path) throws IOException {
        Response response;
        block9: {
            if (((String)path).equals("") || ((String)path).endsWith("/")) {
                path = (String)path + "viewer.html";
            }
            path = String.format("assets/%s", path);
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream((String)path);
            try {
                byte[] bytes = inputStream.readAllBytes();
                response = Response.ok().entity((Object)bytes).build();
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Response.status((int)404).build();
                }
            }
            inputStream.close();
        }
        return response;
    }
}

