/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.ParseToDate$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(date_str[, fmt]) - Parses the `date_str` expression with the `fmt` expression to\n      a date. Returns null with invalid input. By default, it follows casting rules to a date if\n      the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * date_str - A string to be parsed to date.\n      * fmt - Date format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 04:17:52');\n       2009-07-30\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t-b\u0001\u0002\u0013&\u0001JB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005g!AA\n\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005R\u0001\tE\t\u0015!\u0003O\u0011!\u0011\u0006A!f\u0001\n\u0003\u0019\u0006\u0002\u00031\u0001\u0005#\u0005\u000b\u0011\u0002+\t\u000b\u0005\u0004A\u0011\u00012\t\u0011\u001d\u0004\u0001R1A\u0005B)CQ!\u0019\u0001\u0005\u0002!DQ!\u0019\u0001\u0005\u0002-DQ!\u001c\u0001\u0005B9DQa\u001c\u0001\u0005BADQA\u001d\u0001\u0005BMDq!!\n\u0001\t\u0003\n9\u0003C\u0004\u0002,\u0001!\t%!\f\t\u000f\u0005u\u0002\u0001\"\u0015\u0002@!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003+\u0002\u0011\u0013!C\u0001\u0003/B\u0011\"!\u001c\u0001#\u0003%\t!a\u001c\t\u0013\u0005M\u0004!%A\u0005\u0002\u0005U\u0004\"CA=\u0001\u0005\u0005I\u0011IA>\u0011%\tY\tAA\u0001\n\u0003\ti\tC\u0005\u0002\u0016\u0002\t\t\u0011\"\u0001\u0002\u0018\"I\u00111\u0015\u0001\u0002\u0002\u0013\u0005\u0013Q\u0015\u0005\n\u0003g\u0003\u0011\u0011!C\u0001\u0003kC\u0011\"a0\u0001\u0003\u0003%\t%!1\b\u0013\u0005-X%!A\t\u0002\u00055h\u0001\u0003\u0013&\u0003\u0003E\t!a<\t\r\u0005dB\u0011AA\u007f\u0011%\ty\u0010HA\u0001\n\u000b\u0012\t\u0001C\u0005\u0003\u0004q\t\t\u0011\"!\u0003\u0006!I!Q\u0002\u000f\u0012\u0002\u0013\u0005\u0011Q\u000f\u0005\n\u0005\u001fa\u0012\u0011!CA\u0005#A\u0011Ba\b\u001d#\u0003%\t!!\u001e\t\u0013\t\u0005B$!A\u0005\n\t\r\"a\u0003)beN,Gk\u001c#bi\u0016T!AJ\u0014\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003Q%\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003U-\n1a]9m\u0015\taS&A\u0003ta\u0006\u00148N\u0003\u0002/_\u00051\u0011\r]1dQ\u0016T\u0011\u0001M\u0001\u0004_J<7\u0001A\n\b\u0001M:$(\u0010!G!\t!T'D\u0001&\u0013\t1TE\u0001\u0006FqB\u0014Xm]:j_:\u0004\"\u0001\u000e\u001d\n\u0005e*#A\u0005*v]RLW.\u001a*fa2\f7-Z1cY\u0016\u0004\"\u0001N\u001e\n\u0005q*#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005Qr\u0014BA &\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g\u000e\u0005\u0002B\t6\t!IC\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)%IA\u0004Qe>$Wo\u0019;\u0011\u0005\u0005;\u0015B\u0001%C\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003M\nQ\u0001\\3gi\u0002\naAZ8s[\u0006$X#\u0001(\u0011\u0007\u0005{5'\u0003\u0002Q\u0005\n1q\n\u001d;j_:\fqAZ8s[\u0006$\b%\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012\u0001\u0016\t\u0004\u0003>+\u0006C\u0001,^\u001d\t96\f\u0005\u0002Y\u00056\t\u0011L\u0003\u0002[c\u00051AH]8pizJ!\u0001\u0018\"\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039\n\u000b1\u0002^5nKj{g.Z%eA\u00051A(\u001b8jiz\"Ba\u00193fMB\u0011A\u0007\u0001\u0005\u0006\u0013\u001e\u0001\ra\r\u0005\u0006\u0019\u001e\u0001\rA\u0014\u0005\b%\u001e\u0001\n\u00111\u0001U\u0003-\u0011X\r\u001d7bG\u0016lWM\u001c;\u0015\u0007\rL'\u000eC\u0003J\u0013\u0001\u00071\u0007C\u0003M\u0013\u0001\u00071\u0007\u0006\u0002dY\")\u0011J\u0003a\u0001g\u0005Q\u0001O]3uift\u0015-\\3\u0016\u0003U\u000bAb^5uQRKW.\u001a.p]\u0016$\"!P9\t\u000bIc\u0001\u0019A+\u0002)9|G-\u001a)biR,'O\\:J]R,'O\\1m)\u0005!\bcA;{{:\u0011a\u000f\u001f\b\u00031^L\u0011aQ\u0005\u0003s\n\u000bq\u0001]1dW\u0006<W-\u0003\u0002|y\n\u00191+Z9\u000b\u0005e\u0014\u0005c\u0001@\u0002 9\u0019q0!\u0007\u000f\t\u0005\u0005\u0011Q\u0003\b\u0005\u0003\u0007\t\u0019B\u0004\u0003\u0002\u0006\u0005Ea\u0002BA\u0004\u0003\u001fqA!!\u0003\u0002\u000e9\u0019\u0001,a\u0003\n\u0003AJ!AL\u0018\n\u00051j\u0013B\u0001\u0016,\u0013\tA\u0013&C\u0002\u0002\u0018\u001d\nQ\u0001\u001e:fKNLA!a\u0007\u0002\u001e\u0005YAK]3f!\u0006$H/\u001a:o\u0015\r\t9bJ\u0005\u0005\u0003C\t\u0019CA\u0006Ue\u0016,\u0007+\u0019;uKJt'\u0002BA\u000e\u0003;\t\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0003\u0003S\u00012!\u001e>4\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003_\u0001B!\u001e>\u00022A!\u00111GA\u001d\u001b\t\t)DC\u0002\u00028%\nQ\u0001^=qKNLA!a\u000f\u00026\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2aMA!\u0011\u001d\t\u0019\u0005\u0005a\u0001\u0003\u000b\n1B\\3x\u0007\"LG\u000e\u001a:f]B!Q/a\u00124\u0013\r\tI\u0005 \u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018\u0001B2paf$raYA(\u0003#\n\u0019\u0006C\u0004J#A\u0005\t\u0019A\u001a\t\u000f1\u000b\u0002\u0013!a\u0001\u001d\"9!+\u0005I\u0001\u0002\u0004!\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u00033R3aMA.W\t\ti\u0006\u0005\u0003\u0002`\u0005%TBAA1\u0015\u0011\t\u0019'!\u001a\u0002\u0013Ut7\r[3dW\u0016$'bAA4\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0014\u0011\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003cR3ATA.\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a\u001e+\u0007Q\u000bY&A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003{\u0002B!a \u0002\n6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))\u0001\u0003mC:<'BAAD\u0003\u0011Q\u0017M^1\n\u0007y\u000b\t)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0010B\u0019\u0011)!%\n\u0007\u0005M%IA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u001a\u0006}\u0005cA!\u0002\u001c&\u0019\u0011Q\u0014\"\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\"^\t\t\u00111\u0001\u0002\u0010\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a*\u0011\r\u0005%\u0016qVAM\u001b\t\tYKC\u0002\u0002.\n\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t,a+\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003o\u000bi\fE\u0002B\u0003sK1!a/C\u0005\u001d\u0011un\u001c7fC:D\u0011\"!)\u001a\u0003\u0003\u0005\r!!'\u0002\r\u0015\fX/\u00197t)\u0011\t9,a1\t\u0013\u0005\u0005&$!AA\u0002\u0005e\u0005f\u0006\u0001\u0002H\u00065\u0017qZAj\u0003+\fI.a7\u0002`\u0006\u0005\u0018Q]At!\r!\u0014\u0011Z\u0005\u0004\u0003\u0017,#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003#\f\u0011\u0011\u0018\u0006!A\u0001\u0002sLR+O\u0007~CC-\u0019;f?N$(o\u0017\u0017!M6$X,\u000b\u0011.AA\u000b'o]3tAQDW\r\t1eCR,wl\u001d;sA\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011xSRD\u0007\u0005\u001e5fA\u00014W\u000e\u001e1!Kb\u0004(/Z:tS>t\u0007\u0005^8\u000bA\u0001\u0002\u0003\u0005\t\u0011bA\u0011\fG/\u001a\u0018!%\u0016$XO\u001d8tA9,H\u000e\u001c\u0011xSRD\u0007%\u001b8wC2LG\rI5oaV$h\u0006\t\"zA\u0011,g-Y;mi2\u0002\u0013\u000e\u001e\u0011g_2dwn^:!G\u0006\u001cH/\u001b8hAI,H.Z:!i>\u0004\u0013\r\t3bi\u0016\u0004\u0013N\u001a\u0006!A\u0001\u0002\u0003\u0005\t;iK\u0002\u0002g-\u001c;aA%\u001c\be\\7jiR,GM\f\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003/\f!q\u0004\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0011\fG/Z0tiJ\u0004S\u0006I!!gR\u0014\u0018N\\4!i>\u0004#-\u001a\u0011qCJ\u001cX\r\u001a\u0011u_\u0002\"\u0017\r^3/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u00012W\u000e\u001e\u0011.A\u0011\u000bG/\u001a\u0011g_Jl\u0017\r\u001e\u0011qCR$XM\u001d8!i>\u0004cm\u001c7m_^t\u0003eU3fAq\n\u0007\u0005\u001b:fMv\u0012\u0003\u000e\u001e;qgjzsf\u001d9be.t\u0013\r]1dQ\u0016tsN]40I>\u001c7o\f7bi\u0016\u001cHoL:rY6\u0012XMZ\u0017eCR,G/[7f[A\fG\u000f^3s]:BG/\u001c7#}\u0011\u000bG/\u001a;j[\u0016\u0004\u0003+\u0019;uKJt7\u000fP\u0018b}\u00012wN\u001d\u0011wC2LGM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t3bi\u0016\u0004\u0013M\u001c3!i&lW\r\t4pe6\fG\u000f\t9biR,'O\\:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0017!!\f\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0012\u0004\u0007M\u001d.a]j3\u0007\r\u00111ii\ntGO\u001b3O%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00191s5\u0002t'L\u001a1\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#\u0007M\u00197[E\u0012TfM\u0019(Y\u0001:\u00130_=z[5kU\u0006\u001a3(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00197[E\u0012TfM\u0019\u000bA\u0001\nQa\u001a:pkB\f#!a9\u0002\u001d\u0011\fG/\u001a;j[\u0016|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011\u0011^\u0001\u0006c9*d\u0006M\u0001\f!\u0006\u00148/\u001a+p\t\u0006$X\r\u0005\u000259M!A$!=G!!\t\u00190!?4\u001dR\u001bWBAA{\u0015\r\t9PQ\u0001\beVtG/[7f\u0013\u0011\tY0!>\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0002n\u0006AAo\\*ue&tw\r\u0006\u0002\u0002~\u0005)\u0011\r\u001d9msR91Ma\u0002\u0003\n\t-\u0001\"B% \u0001\u0004\u0019\u0004\"\u0002' \u0001\u0004q\u0005b\u0002* !\u0003\u0005\r\u0001V\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u00059QO\\1qa2LH\u0003\u0002B\n\u00057\u0001B!Q(\u0003\u0016A1\u0011Ia\u00064\u001dRK1A!\u0007C\u0005\u0019!V\u000f\u001d7fg!A!QD\u0011\u0002\u0002\u0003\u00071-A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\n\u0011\t\u0005}$qE\u0005\u0005\u0005S\t\tI\u0001\u0004PE*,7\r\u001e")
public class ParseToDate
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
TimeZoneAwareExpression,
scala.Serializable {
    private Expression replacement;
    private final Expression left;
    private final Option<Expression> format;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$3() {
        return ParseToDate$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Option<Expression>, Option<String>>> unapply(ParseToDate parseToDate) {
        return ParseToDate$.MODULE$.unapply(parseToDate);
    }

    public static Option<String> apply$default$3() {
        return ParseToDate$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Option<String>>, ParseToDate> tupled() {
        return ParseToDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Option<String>, ParseToDate>>> curried() {
        return ParseToDate$.MODULE$.curried();
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private Expression canonicalized$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    private Expression replacement$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = (Expression)this.format().map((Function1 & Serializable & scala.Serializable)f -> new Cast(new GetTimestamp(this.left(), (Expression)f, TimestampType$.MODULE$, this.timeZoneId(), GetTimestamp$.MODULE$.apply$default$5()), DateType$.MODULE$, this.timeZoneId(), Cast$.MODULE$.apply$default$4())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Cast(this.left(), DateType$.MODULE$, this.timeZoneId(), Cast$.MODULE$.apply$default$4()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.replacement$lzycompute() : this.replacement;
    }

    @Override
    public String prettyName() {
        return "to_date";
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Some x$1 = new Some((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return (Seq)new .colon.colon((Object)TreePattern$.MODULE$.RUNTIME_REPLACEABLE(), (List)Nil$.MODULE$);
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.left();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$}));
        return (Seq)Option$.MODULE$.option2Iterable(this.format().map((Function1 & Serializable & scala.Serializable)x$7 -> StringType$.MODULE$)).toSeq().$plus$colon((Object)typeCollection, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.format().isDefined() ? this.copy((Expression)newChildren.head(), (Option<Expression>)new Some(newChildren.last()), this.copy$default$3()) : this.copy((Expression)newChildren.head(), this.copy$default$2(), this.copy$default$3());
    }

    public ParseToDate copy(Expression left, Option<Expression> format, Option<String> timeZoneId) {
        return new ParseToDate(left, format, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "ParseToDate";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToDate parseToDate = (ParseToDate)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToDate.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToDate.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = parseToDate.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!parseToDate.canEqual(this)) return false;
        return true;
    }

    public ParseToDate(Expression left, Option<Expression> format, Option<String> timeZoneId) {
        this.left = left;
        this.format = format;
        this.timeZoneId = timeZoneId;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
    }

    public ParseToDate(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), ParseToDate$.MODULE$.$lessinit$greater$default$3());
    }

    public ParseToDate(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, ParseToDate$.MODULE$.$lessinit$greater$default$3());
    }
}

