/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.catalog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.amoro.AmsClient;
import org.apache.amoro.NoSuchDatabaseException;
import org.apache.amoro.PooledAmsClient;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.PrimaryKeySpec;
import org.apache.amoro.api.TableMeta;
import org.apache.amoro.hive.CachedHiveClientPool;
import org.apache.amoro.hive.HMSClient;
import org.apache.amoro.hive.HMSClientPool;
import org.apache.amoro.hive.catalog.MixedHiveTables;
import org.apache.amoro.hive.utils.CompatibleHivePropertyUtil;
import org.apache.amoro.hive.utils.HiveSchemaUtil;
import org.apache.amoro.hive.utils.HiveTableUtil;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.AuthenticatedFileIOs;
import org.apache.amoro.io.AuthenticatedHadoopFileIO;
import org.apache.amoro.mixed.MixedFormatCatalog;
import org.apache.amoro.op.CreateTableTransaction;
import org.apache.amoro.op.MixedHadoopTableOperations;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.amoro.shade.thrift.org.apache.thrift.TException;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.TableBuilder;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.table.blocker.BasicTableBlockerManager;
import org.apache.amoro.table.blocker.TableBlockerManager;
import org.apache.amoro.utils.CompatiblePropertyUtil;
import org.apache.amoro.utils.ConvertStructUtil;
import org.apache.amoro.utils.MixedFormatCatalogUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.iceberg.IcebergSchemaUtil;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedHiveCatalog
implements MixedFormatCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(MixedHiveCatalog.class);
    protected AmsClient client;
    private CachedHiveClientPool hiveClientPool;
    protected String name;
    protected Map<String, String> catalogProperties;
    protected MixedHiveTables tables;
    protected transient TableMetaStore tableMetaStore;

    public String name() {
        return this.name;
    }

    public void initialize(String name, Map<String, String> properties, TableMetaStore metaStore) {
        if (properties.get("ams.uri") != null) {
            this.client = new PooledAmsClient(properties.get("ams.uri"));
        }
        this.name = name;
        this.catalogProperties = properties;
        this.tableMetaStore = metaStore;
        this.tables = this.newMixedHiveTables(properties, metaStore);
        this.hiveClientPool = this.tables.getHiveClientPool();
    }

    protected MixedHiveTables getTables() {
        return this.tables;
    }

    protected MixedHiveTables newMixedHiveTables(Map<String, String> catalogProperties, TableMetaStore metaStore) {
        return new MixedHiveTables(catalogProperties, metaStore);
    }

    public List<String> listDatabases() {
        try {
            return (List)this.hiveClientPool.run(HMSClient::getAllDatabases);
        }
        catch (InterruptedException | org.apache.thrift.TException e) {
            throw new RuntimeException("Failed to list databases", e);
        }
    }

    public void createDatabase(String databaseName) {
        try {
            this.hiveClientPool.run(client -> {
                Database database = new Database();
                database.setName(databaseName);
                client.createDatabase(database);
                return null;
            });
        }
        catch (AlreadyExistsException e) {
            throw new org.apache.iceberg.exceptions.AlreadyExistsException((Throwable)e, "Database '%s' already exists!", new Object[]{databaseName});
        }
        catch (InterruptedException | org.apache.thrift.TException e) {
            throw new RuntimeException("Failed to create database:" + databaseName, e);
        }
    }

    public TableBlockerManager getTableBlockerManager(TableIdentifier tableIdentifier) {
        this.validate(tableIdentifier);
        return BasicTableBlockerManager.build((TableIdentifier)tableIdentifier, (AmsClient)this.client);
    }

    public Map<String, String> properties() {
        return this.catalogProperties;
    }

    public static void putNotNullProperties(Map<String, String> properties, String key, String value) {
        if (value != null) {
            properties.put(key, value);
        }
    }

    protected TableMeta getMixedTableMeta(TableIdentifier identifier) {
        String primaryKey;
        org.apache.hadoop.hive.metastore.api.Table hiveTable = null;
        identifier = identifier.toLowCaseIdentifier();
        try {
            hiveTable = HiveTableUtil.loadHmsTable((HMSClientPool)this.hiveClientPool, identifier);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException(String.format("failed load hive table %s.", identifier), e);
        }
        if (hiveTable == null) {
            throw new NoSuchTableException("load table failed %s.", new Object[]{identifier});
        }
        Map hiveParameters = hiveTable.getParameters();
        String mixedTableRootLocation = (String)hiveParameters.get("arctic.table.root-location");
        if (mixedTableRootLocation == null) {
            String hiveRootLocation = hiveTable.getSd().getLocation();
            mixedTableRootLocation = hiveRootLocation.endsWith("/hive") ? hiveRootLocation.substring(0, hiveRootLocation.length() - 5) : hiveRootLocation;
        }
        String baseLocation = mixedTableRootLocation + "/base";
        String changeLocation = mixedTableRootLocation + "/change";
        Table baseIcebergTable = this.getTables().loadHadoopTableByLocation(baseLocation);
        if (baseIcebergTable == null) {
            throw new NoSuchTableException("load table failed %s, base table not found.", new Object[]{identifier});
        }
        Map properties = baseIcebergTable.properties();
        TableMeta tableMeta = new TableMeta();
        tableMeta.setTableIdentifier(identifier.buildTableIdentifier());
        HashMap<String, String> locations = new HashMap<String, String>();
        MixedHiveCatalog.putNotNullProperties(locations, "table", mixedTableRootLocation);
        MixedHiveCatalog.putNotNullProperties(locations, "change", changeLocation);
        MixedHiveCatalog.putNotNullProperties(locations, "base", baseLocation);
        tableMeta.setLocations(locations);
        HashMap newProperties = new HashMap(properties);
        tableMeta.setProperties(newProperties);
        if (hiveParameters != null && StringUtils.isNotBlank((CharSequence)(primaryKey = (String)hiveParameters.get("arctic.table.primary-keys")))) {
            PrimaryKeySpec keySpec = new PrimaryKeySpec();
            List fields = Arrays.stream(primaryKey.split(",")).collect(Collectors.toList());
            keySpec.setFields(fields);
            tableMeta.setKeySpec(keySpec);
        }
        tableMeta.setFormat(TableFormat.MIXED_HIVE.name());
        return tableMeta;
    }

    public void dropDatabase(String databaseName) {
        try {
            this.hiveClientPool.run(client -> {
                client.dropDatabase(databaseName, false, false, false);
                return null;
            });
        }
        catch (NoSuchObjectException noSuchObjectException) {
        }
        catch (InterruptedException | org.apache.thrift.TException e) {
            throw new RuntimeException("Failed to drop database:" + databaseName, e);
        }
    }

    public TableBuilder newTableBuilder(TableIdentifier identifier, Schema schema) {
        return new MixedHiveTableBuilder(identifier, schema);
    }

    public void renameTable(TableIdentifier from, String newTableName) {
        throw new UnsupportedOperationException("unsupported rename mixed-hive table for now.");
    }

    public HMSClientPool getHMSClient() {
        return this.hiveClientPool;
    }

    public List<TableIdentifier> listTables(String database) {
        ArrayList<TableIdentifier> result = new ArrayList<TableIdentifier>();
        try {
            this.hiveClientPool.run(client -> {
                List tableNames = client.getAllTables(database);
                long start = System.currentTimeMillis();
                List hiveTables = client.getTableObjectsByName(database, tableNames);
                LOG.info("call getTableObjectsByName cost {} ms", (Object)(System.currentTimeMillis() - start));
                if (hiveTables != null && !hiveTables.isEmpty()) {
                    List loadResult = hiveTables.stream().filter(table -> table.getParameters() != null && CompatibleHivePropertyUtil.propertyAsBoolean(table.getParameters(), "arctic.enabled", false)).map(table -> TableIdentifier.of((String)this.name(), (String)database, (String)table.getTableName())).collect(Collectors.toList());
                    if (loadResult != null && !loadResult.isEmpty()) {
                        result.addAll(loadResult);
                    }
                    LOG.debug("load {} tables from database {} of catalog {}", new Object[]{loadResult == null ? 0 : loadResult.size(), database, this.name()});
                } else {
                    LOG.debug("load no tables from database {} of catalog {}", (Object)database, (Object)this.name());
                }
                return result;
            });
        }
        catch (NoSuchObjectException noSuchObjectException) {
        }
        catch (InterruptedException | org.apache.thrift.TException e) {
            throw new RuntimeException("Failed to listTables of database :" + database, e);
        }
        return result;
    }

    private void validate(TableIdentifier identifier) {
        if (StringUtils.isNotBlank((CharSequence)identifier.getCatalog())) {
            identifier.setCatalog(this.name());
        } else if (!this.name().equals(identifier.getCatalog())) {
            throw new IllegalArgumentException("catalog name miss match");
        }
    }

    public MixedTable loadTable(TableIdentifier identifier) {
        this.validate(identifier);
        TableMeta meta = this.getMixedTableMeta(identifier);
        if (meta.getLocations() == null) {
            throw new IllegalStateException("load table failed, lack locations info");
        }
        return this.tables.loadTableByMeta(meta);
    }

    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        TableMeta meta;
        this.validate(identifier);
        try {
            meta = this.getMixedTableMeta(identifier);
        }
        catch (NoSuchTableException e) {
            return false;
        }
        this.doDropTable(meta, purge);
        return true;
    }

    protected void doDropTable(TableMeta meta, boolean purge) {
        this.tables.dropTableByMeta(meta, purge);
    }

    class MixedHiveTableBuilder
    implements TableBuilder {
        protected TableIdentifier identifier;
        protected Schema schema;
        protected PartitionSpec partitionSpec;
        protected SortOrder sortOrder;
        protected Map<String, String> properties = new HashMap<String, String>();
        protected org.apache.amoro.table.PrimaryKeySpec primaryKeySpec = org.apache.amoro.table.PrimaryKeySpec.noPrimaryKey();
        protected String location;
        boolean allowExistedHiveTable = false;

        public MixedTable create() {
            ConvertStructUtil.TableMetaBuilder builder = this.createTableMataBuilder();
            this.doCreateCheck();
            TableMeta meta = builder.build();
            MixedTable table = this.createTableByMeta(meta, this.schema, this.primaryKeySpec, this.partitionSpec);
            return table;
        }

        public Transaction createTransaction() {
            AuthenticatedHadoopFileIO authenticatedFileIO = AuthenticatedFileIOs.buildHadoopFileIO((TableMetaStore)MixedHiveCatalog.this.tableMetaStore);
            ConvertStructUtil.TableMetaBuilder builder = this.createTableMataBuilder();
            TableMeta meta = builder.build();
            String location = this.getTableLocationForCreate();
            MixedHadoopTableOperations tableOperations = new MixedHadoopTableOperations(new Path(location), (AuthenticatedFileIO)authenticatedFileIO, MixedHiveCatalog.this.tableMetaStore.getConfiguration());
            TableMetadata tableMetadata = this.tableMetadata(this.schema, this.partitionSpec, this.sortOrder, this.properties, location);
            Transaction transaction = Transactions.createTableTransaction((String)this.identifier.getTableName(), (TableOperations)tableOperations, (TableMetadata)tableMetadata);
            return new CreateTableTransaction(transaction, this::create, () -> {
                this.doRollbackCreateTable(meta);
                try {
                    MixedHiveCatalog.this.client.removeTable(this.identifier.buildTableIdentifier(), true);
                }
                catch (TException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        protected MixedTable createTableByMeta(TableMeta tableMeta, Schema schema, org.apache.amoro.table.PrimaryKeySpec primaryKeySpec, PartitionSpec partitionSpec) {
            return MixedHiveCatalog.this.tables.createTableByMeta(tableMeta, schema, primaryKeySpec, partitionSpec);
        }

        protected void checkProperties() {
            Map mergedProperties = MixedFormatCatalogUtil.mergeCatalogPropertiesToTable(this.properties, MixedHiveCatalog.this.catalogProperties);
            boolean enableStream = CompatiblePropertyUtil.propertyAsBoolean((Map)mergedProperties, (String)"log-store.enabled", (boolean)false);
            if (enableStream) {
                Preconditions.checkArgument((boolean)mergedProperties.containsKey("log-store.topic"), (Object)"log-store.topic must not be null when log-store.enabled is true.");
                Preconditions.checkArgument((boolean)mergedProperties.containsKey("log-store.address"), (Object)"log-store.address must not be null when log-store.enabled is true.");
                String logStoreType = (String)mergedProperties.get("log-store.type");
                Preconditions.checkArgument((logStoreType == null || logStoreType.equals("kafka") || logStoreType.equals("pulsar") ? 1 : 0) != 0, (Object)String.format("%s can not be set %s, valid values are: [%s, %s].", "log-store.type", logStoreType, "kafka", "pulsar"));
                this.properties.putIfAbsent("log-store.data-format", "json");
            }
        }

        private String getTableLocationForCreate() {
            String databaseLocation;
            if (StringUtils.isNotBlank((CharSequence)this.location)) {
                return this.location;
            }
            if (this.properties.containsKey("location")) {
                String tableLocation = this.properties.get("location");
                if (!Objects.equals("/", tableLocation) && tableLocation.endsWith("/")) {
                    tableLocation = tableLocation.substring(0, tableLocation.length() - 1);
                }
                if (StringUtils.isNotBlank((CharSequence)tableLocation)) {
                    return tableLocation;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(databaseLocation = this.getDatabaseLocation()))) {
                return databaseLocation + '/' + this.identifier.getTableName();
            }
            throw new IllegalStateException("either `location` in table properties or `warehouse` in catalog properties is specified");
        }

        protected TableMetadata tableMetadata(Schema schema, PartitionSpec spec, SortOrder order, Map<String, String> properties, String location) {
            Preconditions.checkNotNull((Object)schema, (Object)"A table schema is required");
            Object tableProps = properties == null ? ImmutableMap.of() : properties;
            PartitionSpec partitionSpec = spec == null ? PartitionSpec.unpartitioned() : spec;
            SortOrder sortOrder = order == null ? SortOrder.unsorted() : order;
            return TableMetadata.newTableMetadata((Schema)schema, (PartitionSpec)partitionSpec, (SortOrder)sortOrder, (String)location, (Map)tableProps);
        }

        public MixedHiveTableBuilder(TableIdentifier identifier, Schema schema) {
            Preconditions.checkArgument((boolean)identifier.getCatalog().equals(MixedHiveCatalog.this.name()), (String)"Illegal table id:%s for catalog:%s", (Object)identifier.toString(), (Object)MixedHiveCatalog.this.name());
            this.identifier = identifier.toLowCaseIdentifier();
            this.schema = HiveSchemaUtil.changeFieldNameToLowercase(schema);
            this.partitionSpec = PartitionSpec.unpartitioned();
            this.sortOrder = SortOrder.unsorted();
        }

        public TableBuilder withPartitionSpec(PartitionSpec partitionSpec) {
            this.partitionSpec = IcebergSchemaUtil.copyPartitionSpec(partitionSpec, this.schema);
            return this;
        }

        public TableBuilder withSortOrder(SortOrder sortOrder) {
            this.sortOrder = IcebergSchemaUtil.copySortOrderSpec(sortOrder, this.schema);
            return this;
        }

        public TableBuilder withPrimaryKeySpec(org.apache.amoro.table.PrimaryKeySpec primaryKeySpec) {
            PrimaryKeySpec.Builder builder = org.apache.amoro.table.PrimaryKeySpec.builderFor((Schema)this.schema);
            primaryKeySpec.fields().forEach(primaryKeyField -> builder.addColumn(primaryKeyField.fieldName().toLowerCase(Locale.ROOT)));
            this.primaryKeySpec = builder.build();
            return this;
        }

        public TableBuilder withProperty(String key, String value) {
            if (key.equals("allow-hive-table-existed") && value.equals("true")) {
                this.allowExistedHiveTable = true;
                this.properties.put(key, value);
            } else if (key.equals("table.event-time-field")) {
                this.properties.put(key, value.toLowerCase(Locale.ROOT));
            } else {
                this.properties.put(key, value);
            }
            return this;
        }

        public TableBuilder withProperties(Map<String, String> properties) {
            properties.forEach(this::withProperty);
            return this;
        }

        protected void doCreateCheck() {
            if (this.primaryKeySpec.primaryKeyExisted()) {
                this.primaryKeySpec.fieldNames().forEach(primaryKey -> {
                    if (this.schema.findField(primaryKey).isOptional()) {
                        throw new IllegalArgumentException("please check your schema, the primary key nested field must be required and field name is " + primaryKey);
                    }
                });
            }
            MixedHiveCatalog.this.listDatabases().stream().filter(d -> d.equals(this.identifier.getDatabase())).findFirst().orElseThrow(() -> new NoSuchDatabaseException(this.identifier.getDatabase()));
            try {
                org.apache.hadoop.hive.metastore.api.Table hiveTable = (org.apache.hadoop.hive.metastore.api.Table)MixedHiveCatalog.this.hiveClientPool.run(client -> client.getTable(this.identifier.getDatabase(), this.identifier.getTableName()));
                if (hiveTable != null && CompatibleHivePropertyUtil.propertyAsBoolean(hiveTable.getParameters(), "arctic.enabled", false)) {
                    throw new org.apache.iceberg.exceptions.AlreadyExistsException(String.format("Table %s has already been upgraded !", this.identifier), new Object[0]);
                }
                if (this.allowExistedHiveTable) {
                    LOG.info("No need to check hive table exist");
                } else if (hiveTable != null) {
                    throw new IllegalArgumentException("Table is already existed in hive meta store:" + this.identifier);
                }
            }
            catch (NoSuchObjectException hiveTable) {
            }
            catch (InterruptedException | org.apache.thrift.TException e) {
                throw new RuntimeException("Failed to check table exist:" + this.identifier, e);
            }
            if (!this.partitionSpec.isUnpartitioned()) {
                for (PartitionField partitionField : this.partitionSpec.fields()) {
                    if (!partitionField.transform().isIdentity()) {
                        throw new IllegalArgumentException("Unsupported partition transform:" + partitionField.transform().toString());
                    }
                    Preconditions.checkArgument((this.schema.columns().indexOf(this.schema.findField(partitionField.sourceId())) >= this.schema.columns().size() - this.partitionSpec.fields().size() ? 1 : 0) != 0, (Object)"Partition field should be at last of schema");
                }
            }
            this.checkProperties();
        }

        protected String getDatabaseLocation() {
            try {
                return (String)MixedHiveCatalog.this.hiveClientPool.run(client -> client.getDatabase(this.identifier.getDatabase()).getLocationUri());
            }
            catch (InterruptedException | org.apache.thrift.TException e) {
                throw new RuntimeException("Failed to get database location:" + this.identifier.getDatabase(), e);
            }
        }

        protected void doRollbackCreateTable(TableMeta meta) {
            if (this.allowExistedHiveTable) {
                LOG.info("No need to drop hive table {}.{}", (Object)meta.getTableIdentifier().getDatabase(), (Object)meta.getTableIdentifier().getTableName());
                MixedHiveCatalog.this.tables.dropTableByMeta(meta, false);
            } else {
                MixedHiveCatalog.this.tables.dropTableByMeta(meta, true);
            }
        }

        protected ConvertStructUtil.TableMetaBuilder createTableMataBuilder() {
            ConvertStructUtil.TableMetaBuilder builder = ConvertStructUtil.newTableMetaBuilder((TableIdentifier)this.identifier, (Schema)this.schema);
            String tableLocation = this.getTableLocationForCreate();
            builder.withTableLocation(tableLocation).withProperties(this.properties).withPrimaryKeySpec(this.primaryKeySpec);
            builder = this.primaryKeySpec.primaryKeyExisted() ? builder.withBaseLocation(tableLocation + "/base").withChangeLocation(tableLocation + "/change") : builder.withBaseLocation(tableLocation + "/base");
            return builder.withFormat(TableFormat.MIXED_HIVE);
        }
    }
}

