/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.utils;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.amoro.server.dashboard.model.SnapshotInfo;
import org.apache.amoro.server.dashboard.model.TableStatistics;
import org.apache.amoro.server.dashboard.utils.PropertiesUtil;
import org.apache.amoro.table.BaseTable;
import org.apache.amoro.table.ChangeTable;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.amoro.table.descriptor.FilesStatistics;
import org.apache.amoro.table.descriptor.FilesStatisticsBuilder;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStatCollector {
    private static final Logger LOG = LoggerFactory.getLogger(TableStatCollector.class);

    @Nonnull
    public static TableStatistics collectChangeTableInfo(KeyedTable table) {
        try {
            ChangeTable internalTable = null;
            try {
                internalTable = table.changeTable();
            }
            catch (NoSuchTableException e) {
                LOG.warn("No related hive table found. {}", (Object)table.id(), (Object)e);
            }
            TableStatistics tableInfo = new TableStatistics();
            TableStatCollector.fillTableStatistics(tableInfo, (UnkeyedTable)internalTable, (MixedTable)table);
            return tableInfo;
        }
        catch (Exception e) {
            LOG.error("failed to collect change table info of {}", (Object)table.id(), (Object)e);
            return TableStatCollector.initEmptyTableStatistics(new TableStatistics(), table.id());
        }
    }

    @Nonnull
    public static TableStatistics collectBaseTableInfo(KeyedTable table) {
        try {
            LOG.info("start collect {} table info of {}", (Object)"base", (Object)table.id());
            BaseTable internalTable = null;
            try {
                internalTable = table.baseTable();
            }
            catch (NoSuchTableException e) {
                LOG.warn("No related hive table found. {}", (Object)table.id(), (Object)e);
            }
            TableStatistics tableInfo = new TableStatistics();
            TableStatCollector.fillTableStatistics(tableInfo, (UnkeyedTable)internalTable, (MixedTable)table);
            return tableInfo;
        }
        catch (Exception e) {
            LOG.error("failed to collect base table info of {}", (Object)table.id(), (Object)e);
            return TableStatCollector.initEmptyTableStatistics(new TableStatistics(), table.id());
        }
    }

    public static TableStatistics union(TableStatistics changeTableInfo, TableStatistics baseTableInfo) {
        if (baseTableInfo == null && changeTableInfo == null) {
            return null;
        }
        if (baseTableInfo == null) {
            return new TableStatistics(changeTableInfo);
        }
        if (changeTableInfo == null) {
            return new TableStatistics(baseTableInfo);
        }
        TableStatistics overview = new TableStatistics();
        Map<String, String> baseSummary = baseTableInfo.getSummary();
        Map<String, String> changeSummary = changeTableInfo.getSummary();
        HashMap<String, String> summary = new HashMap<String, String>();
        PropertiesUtil.putNotNullProperties(summary, "visibleTime", changeSummary.get("visibleTime"));
        overview.setTableIdentifier(baseTableInfo.getTableIdentifier());
        PropertiesUtil.putNotNullProperties(summary, "snapshotCnt", baseSummary.get("snapshotCnt"));
        PropertiesUtil.putNotNullProperties(summary, "firstSnapshotCommitTime", baseSummary.get("firstSnapshotCommitTime"));
        overview.setSummary(summary);
        FilesStatistics changeFs = changeTableInfo.getTotalFilesStat();
        FilesStatistics baseFs = baseTableInfo.getTotalFilesStat();
        overview.setTotalFilesStat(new FilesStatistics.Builder().addFilesStatistics(changeFs).addFilesStatistics(baseFs).build());
        return overview;
    }

    public static SnapshotInfo buildBaseTableSnapshotInfo(Table baseTable) {
        Snapshot currentSnapshot = baseTable.currentSnapshot();
        SnapshotInfo snapshotInfo = new SnapshotInfo();
        if (currentSnapshot != null) {
            TableStatCollector.fillSnapshotInfo(snapshotInfo, currentSnapshot);
        }
        return snapshotInfo;
    }

    private static void fillSnapshotInfo(SnapshotInfo info, @Nonnull Snapshot snapshot) {
        info.setOperation(snapshot.operation());
        info.setAddedFiles(PropertyUtil.propertyAsInt((Map)snapshot.summary(), (String)"added-data-files", (int)0));
        info.setAddedFilesSize(PropertyUtil.propertyAsLong((Map)snapshot.summary(), (String)"added-files-size", (long)0L));
        info.setAddedRecords(PropertyUtil.propertyAsLong((Map)snapshot.summary(), (String)"added-records", (long)0L));
        info.setRemovedFilesSize(PropertyUtil.propertyAsLong((Map)snapshot.summary(), (String)"removed-files-size", (long)0L));
        int removedFiles = PropertyUtil.propertyAsInt((Map)snapshot.summary(), (String)"deleted-data-files", (int)0) + PropertyUtil.propertyAsInt((Map)snapshot.summary(), (String)"removed-delete-files", (int)0);
        info.setRemovedFiles(removedFiles);
        info.setRemovedRecords(PropertyUtil.propertyAsLong((Map)snapshot.summary(), (String)"deleted-records", (long)0L));
        info.setTotalSize(PropertyUtil.propertyAsLong((Map)snapshot.summary(), (String)"total-files-size", (long)0L));
        info.setSnapshotId(snapshot.snapshotId());
        info.setTotalFiles(PropertyUtil.propertyAsInt((Map)snapshot.summary(), (String)"total-data-files", (int)0));
        info.setTotalRecords(PropertyUtil.propertyAsLong((Map)snapshot.summary(), (String)"total-records", (long)0L));
    }

    private static void fillTableSnapshotInfo(TableStatistics tableStatistics, UnkeyedTable internalTable) {
        if (internalTable.currentSnapshot() == null) {
            return;
        }
        Snapshot snapshot = internalTable.currentSnapshot();
        Map<String, String> summary = tableStatistics.getSummary();
        PropertiesUtil.putNotNullProperties(summary, "operation", snapshot.summary().getOrDefault("operation", ""));
        PropertiesUtil.putNotNullProperties(summary, "addedFiles", String.valueOf(PropertyUtil.propertyAsInt((Map)snapshot.summary(), (String)"added-data-files", (int)0)));
        PropertiesUtil.putNotNullProperties(summary, "addedFilesSize", String.valueOf(PropertyUtil.propertyAsLong((Map)snapshot.summary(), (String)"added-files-size", (long)0L)));
        PropertiesUtil.putNotNullProperties(summary, "addedRecords", String.valueOf(PropertyUtil.propertyAsLong((Map)snapshot.summary(), (String)"added-records", (long)0L)));
        PropertiesUtil.putNotNullProperties(summary, "removedFilesSize", String.valueOf(PropertyUtil.propertyAsLong((Map)snapshot.summary(), (String)"removed-files-size", (long)0L)));
        PropertiesUtil.putNotNullProperties(summary, "removedFiles", String.valueOf(PropertyUtil.propertyAsInt((Map)snapshot.summary(), (String)"deleted-data-files", (int)0)));
        PropertiesUtil.putNotNullProperties(summary, "removedRecords", String.valueOf(PropertyUtil.propertyAsLong((Map)snapshot.summary(), (String)"deleted-records", (long)0L)));
        PropertiesUtil.putNotNullProperties(summary, "totalSize", String.valueOf(PropertyUtil.propertyAsLong((Map)snapshot.summary(), (String)"total-files-size", (long)0L)));
        PropertiesUtil.putNotNullProperties(summary, "snapshotId", String.valueOf(snapshot.snapshotId()));
        PropertiesUtil.putNotNullProperties(summary, "totalFiles", String.valueOf(PropertyUtil.propertyAsInt((Map)snapshot.summary(), (String)"total-data-files", (int)0)));
        PropertiesUtil.putNotNullProperties(summary, "totalRecords", String.valueOf(PropertyUtil.propertyAsLong((Map)snapshot.summary(), (String)"total-records", (long)0L)));
    }

    public static void fillTableStatistics(TableStatistics tableStatistics, UnkeyedTable tableStore, MixedTable table) {
        if (tableStore == null) {
            TableStatCollector.initEmptyTableStatistics(tableStatistics, table.id());
            return;
        }
        tableStatistics.setTableIdentifier(table.id());
        FilesStatisticsBuilder totalFileStatBuilder = new FilesStatisticsBuilder();
        Snapshot currentSnapshot = tableStore.currentSnapshot();
        if (currentSnapshot != null) {
            long addedFilesSize = PropertyUtil.propertyAsLong((Map)currentSnapshot.summary(), (String)"total-files-size", (long)0L);
            int addedFilesCnt = PropertyUtil.propertyAsInt((Map)currentSnapshot.summary(), (String)"total-data-files", (int)0) + PropertyUtil.propertyAsInt((Map)currentSnapshot.summary(), (String)"total-delete-files", (int)0);
            totalFileStatBuilder.addFiles(addedFilesSize, addedFilesCnt);
        }
        tableStatistics.setTotalFilesStat(totalFileStatBuilder.build());
        Iterable snapshots = tableStore.snapshots();
        Snapshot firstSnapshot = null;
        Snapshot lastSnapshot = null;
        int snapshotCount = 0;
        for (Snapshot snapshot : snapshots) {
            ++snapshotCount;
            lastSnapshot = snapshot;
            if (firstSnapshot != null) continue;
            firstSnapshot = snapshot;
        }
        Map<String, String> summary = TableStatCollector.fillSummary(snapshotCount, lastSnapshot, firstSnapshot);
        tableStatistics.setSummary(summary);
        TableStatCollector.fillTableSnapshotInfo(tableStatistics, tableStore);
    }

    private static TableStatistics initEmptyTableStatistics(TableStatistics tableStatistics, TableIdentifier tableIdentifier) {
        tableStatistics.setSummary(new HashMap<String, String>());
        tableStatistics.setTableIdentifier(tableIdentifier);
        tableStatistics.setTotalFilesStat(new FilesStatistics(Integer.valueOf(0), Long.valueOf(0L)));
        return tableStatistics;
    }

    private static Map<String, String> fillSummary(int snapshotCount, Snapshot lastSnapshot, Snapshot firstSnapshot) {
        HashMap<String, String> summary = new HashMap<String, String>();
        PropertiesUtil.putNotNullProperties(summary, "snapshotCnt", String.valueOf(snapshotCount));
        PropertiesUtil.putNotNullProperties(summary, "visibleTime", lastSnapshot == null ? null : String.valueOf(lastSnapshot.timestampMillis()));
        PropertiesUtil.putNotNullProperties(summary, "firstSnapshotCommitTime", firstSnapshot == null ? null : String.valueOf(firstSnapshot.timestampMillis()));
        return summary;
    }
}

