/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized;

import java.io.Closeable;
import java.io.IOException;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.arrow.vectorized.ArrowReader;
import org.apache.iceberg.arrow.vectorized.ColumnarBatch;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;

public class VectorizedTableScanIterable
extends CloseableGroup
implements CloseableIterable<ColumnarBatch> {
    private static final int BATCH_SIZE_IN_NUM_ROWS = 65536;
    private final ArrowReader reader;
    private final CloseableIterable<CombinedScanTask> tasks;

    public VectorizedTableScanIterable(TableScan scan) {
        this(scan, 65536, false);
    }

    public VectorizedTableScanIterable(TableScan scan, int batchSize, boolean reuseContainers) {
        this.reader = new ArrowReader(scan, batchSize, reuseContainers);
        this.tasks = scan.planTasks();
    }

    public CloseableIterator<ColumnarBatch> iterator() {
        CloseableIterator<ColumnarBatch> iter = this.reader.open(this.tasks);
        this.addCloseable((Closeable)iter);
        return iter;
    }

    public void close() throws IOException {
        this.tasks.close();
        super.close();
    }
}

