/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.Node;
import net.sf.jsqlparser.parser.ParseException;
import net.sf.jsqlparser.parser.StatementListener;
import net.sf.jsqlparser.parser.StreamProvider;
import net.sf.jsqlparser.parser.StringProvider;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;

public final class CCJSqlParserUtil {
    public static final Logger LOGGER = Logger.getLogger(CCJSqlParserUtil.class.getName());
    public static final int ALLOWED_NESTING_DEPTH = 10;

    private CCJSqlParserUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Statement parse(Reader statementReader) throws JSQLParserException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Statement statement = null;
        CCJSqlParser parser = new CCJSqlParser(new StreamProvider(statementReader));
        try {
            statement = CCJSqlParserUtil.parseStatement(parser, executorService);
        }
        finally {
            executorService.shutdown();
        }
        return statement;
    }

    public static Statement parse(String sql) throws JSQLParserException {
        return CCJSqlParserUtil.parse(sql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Statement parse(String sql, Consumer<CCJSqlParser> consumer) throws JSQLParserException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Statement statement = null;
        try {
            statement = CCJSqlParserUtil.parse(sql, executorService, consumer);
        }
        finally {
            executorService.shutdown();
        }
        return statement;
    }

    public static Statement parse(String sql, ExecutorService executorService, Consumer<CCJSqlParser> consumer) throws JSQLParserException {
        Statement statement = null;
        CCJSqlParser parser = CCJSqlParserUtil.newParser(sql);
        if (consumer != null) {
            consumer.accept(parser);
        }
        boolean allowComplex = parser.getConfiguration().getAsBoolean(Feature.allowComplexParsing);
        LOGGER.info("Allowed Complex Parsing: " + allowComplex);
        try {
            LOGGER.info("Trying SIMPLE parsing " + (allowComplex ? "first" : "only"));
            statement = CCJSqlParserUtil.parseStatement((CCJSqlParser)parser.withAllowComplexParsing(false), executorService);
        }
        catch (JSQLParserException ex) {
            LOGGER.info("Nesting Depth" + CCJSqlParserUtil.getNestingDepth(sql));
            if (allowComplex && CCJSqlParserUtil.getNestingDepth(sql) <= 10) {
                LOGGER.info("Trying COMPLEX parsing when SIMPLE parsing failed");
                parser = CCJSqlParserUtil.newParser(sql);
                if (consumer != null) {
                    consumer.accept(parser);
                }
                statement = CCJSqlParserUtil.parseStatement((CCJSqlParser)parser.withAllowComplexParsing(true), executorService);
            }
            throw ex;
        }
        return statement;
    }

    public static CCJSqlParser newParser(String sql) {
        return new CCJSqlParser(new StringProvider(sql));
    }

    public static CCJSqlParser newParser(InputStream is) throws IOException {
        return new CCJSqlParser(new StreamProvider(is));
    }

    public static CCJSqlParser newParser(InputStream is, String encoding) throws IOException {
        return new CCJSqlParser(new StreamProvider(is, encoding));
    }

    public static Node parseAST(String sql) throws JSQLParserException {
        CCJSqlParser parser = CCJSqlParserUtil.newParser(sql);
        try {
            parser.Statement();
            return parser.jjtree.rootNode();
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Statement parse(InputStream is) throws JSQLParserException {
        try {
            CCJSqlParser parser = CCJSqlParserUtil.newParser(is);
            return parser.Statement();
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Statement parse(InputStream is, String encoding) throws JSQLParserException {
        try {
            CCJSqlParser parser = CCJSqlParserUtil.newParser(is, encoding);
            return parser.Statement();
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static Expression parseExpression(String expression) throws JSQLParserException {
        return CCJSqlParserUtil.parseExpression(expression, true);
    }

    public static Expression parseExpression(String expression, boolean allowPartialParse) throws JSQLParserException {
        return CCJSqlParserUtil.parseExpression(expression, allowPartialParse, p -> {});
    }

    public static Expression parseExpression(String expressionStr, boolean allowPartialParse, Consumer<CCJSqlParser> consumer) throws JSQLParserException {
        Expression expression;
        block11: {
            expression = null;
            try {
                CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser(expressionStr).withAllowComplexParsing(false);
                if (consumer != null) {
                    consumer.accept(parser);
                }
                try {
                    expression = parser.Expression();
                    if (parser.getNextToken().kind != 0) {
                        throw new JSQLParserException("could only parse partial expression " + expression.toString());
                    }
                }
                catch (ParseException ex) {
                    throw new JSQLParserException(ex);
                }
            }
            catch (JSQLParserException ex1) {
                if (CCJSqlParserUtil.getNestingDepth(expressionStr) > 10) break block11;
                CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser(expressionStr).withAllowComplexParsing(true);
                if (consumer != null) {
                    consumer.accept(parser);
                }
                try {
                    expression = parser.Expression();
                    if (!allowPartialParse && parser.getNextToken().kind != 0) {
                        throw new JSQLParserException("could only parse partial expression " + expression.toString());
                    }
                }
                catch (JSQLParserException ex) {
                    throw ex;
                }
                catch (ParseException ex) {
                    throw new JSQLParserException(ex);
                }
            }
        }
        return expression;
    }

    public static Expression parseCondExpression(String condExpr) throws JSQLParserException {
        return CCJSqlParserUtil.parseCondExpression(condExpr, true);
    }

    public static Expression parseCondExpression(String condExpr, boolean allowPartialParse) throws JSQLParserException {
        return CCJSqlParserUtil.parseCondExpression(condExpr, allowPartialParse, p -> {});
    }

    public static Expression parseCondExpression(String conditionalExpressionStr, boolean allowPartialParse, Consumer<CCJSqlParser> consumer) throws JSQLParserException {
        Expression expression;
        block11: {
            expression = null;
            try {
                CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser(conditionalExpressionStr).withAllowComplexParsing(false);
                if (consumer != null) {
                    consumer.accept(parser);
                }
                try {
                    expression = parser.Expression();
                    if (parser.getNextToken().kind != 0) {
                        throw new JSQLParserException("could only parse partial expression " + expression.toString());
                    }
                }
                catch (ParseException ex) {
                    throw new JSQLParserException(ex);
                }
            }
            catch (JSQLParserException ex1) {
                if (CCJSqlParserUtil.getNestingDepth(conditionalExpressionStr) > 10) break block11;
                CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser(conditionalExpressionStr).withAllowComplexParsing(true);
                if (consumer != null) {
                    consumer.accept(parser);
                }
                try {
                    expression = parser.Expression();
                    if (!allowPartialParse && parser.getNextToken().kind != 0) {
                        throw new JSQLParserException("could only parse partial expression " + expression.toString());
                    }
                }
                catch (JSQLParserException ex) {
                    throw ex;
                }
                catch (ParseException ex) {
                    throw new JSQLParserException(ex);
                }
            }
        }
        return expression;
    }

    public static Statement parseStatement(final CCJSqlParser parser, ExecutorService executorService) throws JSQLParserException {
        Statement statement = null;
        Future<Statement> future = executorService.submit(new Callable<Statement>(){

            @Override
            public Statement call() throws ParseException {
                return parser.Statement();
            }
        });
        try {
            statement = future.get(parser.getConfiguration().getAsLong(Feature.timeOut), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            parser.interrupted = true;
            future.cancel(true);
            throw new JSQLParserException("Time out occurred.", ex);
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
        return statement;
    }

    public static Statements parseStatements(String sqls) throws JSQLParserException {
        return CCJSqlParserUtil.parseStatements(sqls, null);
    }

    public static Statements parseStatements(String sqls, Consumer<CCJSqlParser> consumer) throws JSQLParserException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Statements statements = CCJSqlParserUtil.parseStatements(sqls, executorService, consumer);
        executorService.shutdown();
        return statements;
    }

    public static Statements parseStatements(String sqls, ExecutorService executorService, Consumer<CCJSqlParser> consumer) throws JSQLParserException {
        Statements statements;
        block4: {
            statements = null;
            CCJSqlParser parser = CCJSqlParserUtil.newParser(sqls);
            if (consumer != null) {
                consumer.accept(parser);
            }
            boolean allowComplex = parser.getConfiguration().getAsBoolean(Feature.allowComplexParsing);
            try {
                statements = CCJSqlParserUtil.parseStatements((CCJSqlParser)parser.withAllowComplexParsing(false), executorService);
            }
            catch (JSQLParserException ex) {
                if (!allowComplex || CCJSqlParserUtil.getNestingDepth(sqls) > 10) break block4;
                parser = CCJSqlParserUtil.newParser(sqls);
                if (consumer != null) {
                    consumer.accept(parser);
                }
                statements = CCJSqlParserUtil.parseStatements((CCJSqlParser)parser.withAllowComplexParsing(true), executorService);
            }
        }
        return statements;
    }

    public static Statements parseStatements(final CCJSqlParser parser, ExecutorService executorService) throws JSQLParserException {
        Statements statements = null;
        Future<Statements> future = executorService.submit(new Callable<Statements>(){

            @Override
            public Statements call() throws ParseException {
                return parser.Statements();
            }
        });
        try {
            statements = future.get(parser.getConfiguration().getAsLong(Feature.timeOut), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            parser.interrupted = true;
            future.cancel(true);
            throw new JSQLParserException("Time out occurred.", ex);
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
        return statements;
    }

    public static void streamStatements(StatementListener listener, InputStream is, String encoding) throws JSQLParserException {
        try {
            CCJSqlParser parser = CCJSqlParserUtil.newParser(is, encoding);
            do {
                Statement stmt = parser.SingleStatement();
                listener.accept(stmt);
                if (parser.getToken((int)1).kind != 344) continue;
                parser.getNextToken();
            } while (parser.getToken((int)1).kind != 0);
        }
        catch (Exception ex) {
            throw new JSQLParserException(ex);
        }
    }

    public static int getNestingDepth(String sql) {
        char[] chars;
        int maxlevel = 0;
        int level = 0;
        block4: for (char c : chars = sql.toCharArray()) {
            switch (c) {
                case '(': {
                    ++level;
                    continue block4;
                }
                case ')': {
                    if (maxlevel < level) {
                        maxlevel = level;
                    }
                    --level;
                    continue block4;
                }
            }
        }
        return maxlevel;
    }

    public static int getUnbalancedPosition(String text) {
        Stack<Character> stack = new Stack<Character>();
        boolean insideQuote = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\"' || c == '\'') {
                if (!insideQuote) {
                    stack.push(Character.valueOf(c));
                } else if (((Character)stack.peek()).charValue() == c) {
                    stack.pop();
                }
                insideQuote = !insideQuote;
                continue;
            }
            if (!(insideQuote || c != '(' && c != '[' && c != '{')) {
                stack.push(Character.valueOf(c));
                continue;
            }
            if (insideQuote || c != ')' && c != ']' && c != '}') continue;
            if (stack.isEmpty()) {
                return i;
            }
            char top = ((Character)stack.pop()).charValue();
            if (!(c == ')' && top != '(' || c == ']' && top != '[') && (c != '}' || top == '{')) continue;
            return i;
        }
        if (!stack.isEmpty()) {
            char unbalanced = ((Character)stack.peek()).charValue();
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) != unbalanced) continue;
                return i;
            }
        }
        return -1;
    }

    static {
        LOGGER.setLevel(Level.OFF);
    }
}

