/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.shuffle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.io.disk.BatchShuffleReadBufferPool;
import org.apache.flink.runtime.io.disk.FileChannelManager;
import org.apache.flink.runtime.io.network.buffer.BufferCompressor;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageConfiguration;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.TieredStorageNettyServiceImpl;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.shuffle.TieredResultPartition;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.BufferAccumulator;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.HashBufferAccumulator;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.SortBufferAccumulator;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManagerImpl;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemorySpec;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageProducerClient;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierProducerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleDescriptor;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.memory.MemoryTierFactory;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;

public class TieredResultPartitionFactory {
    private final TieredStorageConfiguration tieredStorageConfiguration;
    private final TieredStorageNettyServiceImpl tieredStorageNettyService;
    private final TieredStorageResourceRegistry tieredStorageResourceRegistry;

    public TieredResultPartitionFactory(TieredStorageConfiguration tieredStorageConfiguration, TieredStorageNettyServiceImpl tieredStorageNettyService, TieredStorageResourceRegistry tieredStorageResourceRegistry) {
        this.tieredStorageConfiguration = tieredStorageConfiguration;
        this.tieredStorageNettyService = tieredStorageNettyService;
        this.tieredStorageResourceRegistry = tieredStorageResourceRegistry;
    }

    public TieredStorageConfiguration getTieredStorageConfiguration() {
        return this.tieredStorageConfiguration;
    }

    public TieredStorageNettyServiceImpl getTieredStorageNettyService() {
        return this.tieredStorageNettyService;
    }

    public TieredStorageResourceRegistry getTieredStorageResourceRegistry() {
        return this.tieredStorageResourceRegistry;
    }

    public TieredResultPartition createTieredResultPartition(String owningTaskName, int partitionIndex, ResultPartitionID partitionId, ResultPartitionType partitionType, int numPartitions, int numSubpartitions, int maxParallelism, int bufferSizeBytes, Boolean isBroadCastOnly, ResultPartitionManager partitionManager, @Nullable BufferCompressor bufferCompressor, List<TierShuffleDescriptor> tierShuffleDescriptors, SupplierWithException<BufferPool, IOException> bufferPoolFactory, FileChannelManager fileChannelManager, BatchShuffleReadBufferPool batchShuffleReadBufferPool, ScheduledExecutorService batchShuffleReadIOExecutor, boolean isNumberOfPartitionConsumerUndefined) {
        TieredStorageMemoryManagerImpl memoryManager = new TieredStorageMemoryManagerImpl(TieredStorageUtils.getNumBuffersTriggerFlushRatio(), true);
        int numAccumulatorExclusiveBuffers = TieredStorageUtils.getAccumulatorExclusiveBuffers();
        BufferAccumulator bufferAccumulator = this.createBufferAccumulator(numSubpartitions, bufferSizeBytes, numAccumulatorExclusiveBuffers, memoryManager, isNumberOfPartitionConsumerUndefined);
        Tuple2<List<TierProducerAgent>, List<TieredStorageMemorySpec>> producerAgentsAndMemorySpecs = this.createTierProducerAgentsAndMemorySpecs(numPartitions, numSubpartitions, isBroadCastOnly, TieredStorageIdMappingUtils.convertId(partitionId), memoryManager, bufferAccumulator, partitionType == ResultPartitionType.HYBRID_SELECTIVE, tierShuffleDescriptors, fileChannelManager, batchShuffleReadBufferPool, batchShuffleReadIOExecutor);
        TieredStorageProducerClient tieredStorageProducerClient = new TieredStorageProducerClient(numSubpartitions, isBroadCastOnly, bufferAccumulator, bufferCompressor, (List)producerAgentsAndMemorySpecs.f0);
        return new TieredResultPartition(owningTaskName, partitionIndex, partitionId, partitionType, numSubpartitions, maxParallelism, partitionManager, bufferCompressor, bufferPoolFactory, tieredStorageProducerClient, this.tieredStorageResourceRegistry, this.tieredStorageNettyService, (List)producerAgentsAndMemorySpecs.f1, memoryManager);
    }

    private BufferAccumulator createBufferAccumulator(int numSubpartitions, int bufferSizeBytes, int numAccumulatorExclusiveBuffers, TieredStorageMemoryManager storageMemoryManager, boolean isNumberOfPartitionConsumerUndefined) {
        BufferAccumulator bufferAccumulator = numSubpartitions + 1 > numAccumulatorExclusiveBuffers ? new SortBufferAccumulator(numSubpartitions, numAccumulatorExclusiveBuffers, bufferSizeBytes, storageMemoryManager, !isNumberOfPartitionConsumerUndefined) : new HashBufferAccumulator(numSubpartitions, bufferSizeBytes, storageMemoryManager, !isNumberOfPartitionConsumerUndefined);
        return bufferAccumulator;
    }

    private Tuple2<List<TierProducerAgent>, List<TieredStorageMemorySpec>> createTierProducerAgentsAndMemorySpecs(int numberOfPartitions, int numberOfSubpartitions, boolean isBroadcastOnly, TieredStoragePartitionId partitionID, TieredStorageMemoryManager memoryManager, BufferAccumulator bufferAccumulator, boolean isHybridSelective, List<TierShuffleDescriptor> tierShuffleDescriptors, FileChannelManager fileChannelManager, BatchShuffleReadBufferPool batchShuffleReadBufferPool, ScheduledExecutorService batchShuffleReadIOExecutor) {
        ArrayList<TierProducerAgent> tierProducerAgents = new ArrayList<TierProducerAgent>();
        ArrayList<TieredStorageMemorySpec> tieredStorageMemorySpecs = new ArrayList<TieredStorageMemorySpec>();
        tieredStorageMemorySpecs.add(new TieredStorageMemorySpec(bufferAccumulator, 2 * Math.min(numberOfSubpartitions + 1, TieredStorageUtils.getAccumulatorExclusiveBuffers()), true));
        List<TierFactory> tierFactories = this.tieredStorageConfiguration.getTierFactories();
        Preconditions.checkState((tierFactories.size() == tierShuffleDescriptors.size() ? 1 : 0) != 0);
        for (int index = 0; index < tierFactories.size(); ++index) {
            TierFactory tierFactory = tierFactories.get(index);
            if (!isHybridSelective && tierFactory.getClass() == MemoryTierFactory.class) continue;
            TierProducerAgent producerAgent = tierFactory.createProducerAgent(numberOfPartitions, numberOfSubpartitions, partitionID, fileChannelManager.createChannel().getPath(), isBroadcastOnly, memoryManager, this.tieredStorageNettyService, this.tieredStorageResourceRegistry, batchShuffleReadBufferPool, batchShuffleReadIOExecutor, Collections.singletonList(tierShuffleDescriptors.get(index)), Math.max(2 * batchShuffleReadBufferPool.getNumBuffersPerRequest(), numberOfSubpartitions));
            tierProducerAgents.add(producerAgent);
            tieredStorageMemorySpecs.add(tierFactory.getProducerAgentMemorySpec());
        }
        return Tuple2.of(tierProducerAgents, tieredStorageMemorySpecs);
    }
}

