/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.expressions.aggregate;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;

@Evolving
public final class GeneralAggregateFunc
implements AggregateFunc {
    private final String name;
    private final boolean isDistinct;
    private final Expression[] children;

    public String name() {
        return this.name;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public GeneralAggregateFunc(String name, boolean isDistinct, Expression[] children2) {
        this.name = name;
        this.isDistinct = isDistinct;
        this.children = children2;
    }

    @Override
    public Expression[] children() {
        return this.children;
    }

    public String toString() {
        String inputsString = Arrays.stream(this.children).map(Expression::describe).collect(Collectors.joining(", "));
        if (this.isDistinct) {
            return this.name + "(DISTINCT " + inputsString + ")";
        }
        return this.name + "(" + inputsString + ")";
    }
}

