/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.procedures.BaseProcedure;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.iceberg.spark.source.HasIcebergCatalog;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureParameter;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

class RegisterTableProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.required("metadata_file", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("current_snapshot_id", DataTypes.LongType, true, Metadata.empty()), new StructField("total_records_count", DataTypes.LongType, true, Metadata.empty()), new StructField("total_data_files_count", DataTypes.LongType, true, Metadata.empty())});

    private RegisterTableProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    public static SparkProcedures.ProcedureBuilder builder() {
        return new BaseProcedure.Builder<RegisterTableProcedure>(){

            @Override
            protected RegisterTableProcedure doBuild() {
                return new RegisterTableProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        TableIdentifier tableName = Spark3Util.identifierToTableIdentifier(this.toIdentifier(args.getString(0), "table"));
        String metadataFile = args.getString(1);
        Preconditions.checkArgument((boolean)(this.tableCatalog() instanceof HasIcebergCatalog), (Object)"Cannot use Register Table in a non-Iceberg catalog");
        Preconditions.checkArgument((metadataFile != null && !metadataFile.isEmpty() ? 1 : 0) != 0, (Object)"Cannot handle an empty argument metadata_file");
        Catalog icebergCatalog = ((HasIcebergCatalog)this.tableCatalog()).icebergCatalog();
        Table table = icebergCatalog.registerTable(tableName, metadataFile);
        Long currentSnapshotId = null;
        Long totalDataFiles = null;
        Long totalRecords = null;
        Snapshot currentSnapshot = table.currentSnapshot();
        if (currentSnapshot != null) {
            currentSnapshotId = currentSnapshot.snapshotId();
            totalDataFiles = Long.parseLong((String)currentSnapshot.summary().get("total-data-files"));
            totalRecords = Long.parseLong((String)currentSnapshot.summary().get("total-records"));
        }
        return new InternalRow[]{this.newInternalRow(currentSnapshotId, totalRecords, totalDataFiles)};
    }

    @Override
    public String description() {
        return "RegisterTableProcedure";
    }
}

