/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.functions;

import org.apache.iceberg.spark.functions.UnaryUnboundFunction;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.TimestampType;

public class YearsFunction
extends UnaryUnboundFunction {
    @Override
    protected BoundFunction doBind(DataType valueType) {
        if (valueType instanceof DateType) {
            return new DateToYearsFunction();
        }
        if (valueType instanceof TimestampType) {
            return new TimestampToYearsFunction();
        }
        throw new UnsupportedOperationException("Expected value to be date or timestamp: " + valueType.catalogString());
    }

    public String description() {
        return this.name() + "(col) - Call Iceberg's year transform\n  col :: source column (must be date or timestamp)";
    }

    public String name() {
        return "years";
    }

    public static class TimestampToYearsFunction
    extends BaseToYearsFunction {
        public static int invoke(long micros) {
            return DateTimeUtil.microsToYears((long)micros);
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.TimestampType};
        }

        public String canonicalName() {
            return "iceberg.years(timestamp)";
        }

        public Integer produceResult(InternalRow input) {
            return input.isNullAt(0) ? null : Integer.valueOf(TimestampToYearsFunction.invoke(input.getLong(0)));
        }
    }

    public static class DateToYearsFunction
    extends BaseToYearsFunction {
        public static int invoke(int days) {
            return DateTimeUtil.daysToYears((int)days);
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.DateType};
        }

        public String canonicalName() {
            return "iceberg.years(date)";
        }

        public Integer produceResult(InternalRow input) {
            return input.isNullAt(0) ? null : Integer.valueOf(DateToYearsFunction.invoke(input.getInt(0)));
        }
    }

    private static abstract class BaseToYearsFunction
    implements ScalarFunction<Integer> {
        private BaseToYearsFunction() {
        }

        public String name() {
            return "years";
        }

        public DataType resultType() {
            return DataTypes.IntegerType;
        }
    }
}

