/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.process;

import java.util.Map;
import org.apache.amoro.Action;
import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.StateField;
import org.apache.amoro.process.ProcessStage;
import org.apache.amoro.process.ProcessState;
import org.apache.amoro.process.ProcessStatus;

public class TableProcessState
implements ProcessState {
    @StateField
    private volatile long id;
    private final Action action;
    private final ServerTableIdentifier tableIdentifier;
    @StateField
    private long startTime;
    @StateField
    private long endTime = -1L;
    @StateField
    private ProcessStatus status = ProcessStatus.SUBMITTED;
    @StateField
    private volatile String failedReason;
    private volatile Map<String, String> summary;

    public TableProcessState(Action action, ServerTableIdentifier tableIdentifier) {
        this.action = action;
        this.tableIdentifier = tableIdentifier;
    }

    public TableProcessState(long id, Action action, ServerTableIdentifier tableIdentifier) {
        this.id = id;
        this.action = action;
        this.tableIdentifier = tableIdentifier;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.action.getDesc();
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public ProcessStatus getStatus() {
        return this.status;
    }

    @Override
    public Map<String, String> getSummary() {
        return this.summary;
    }

    @Override
    public long getQuotaRuntime() {
        return this.getDuration();
    }

    @Override
    public double getQuotaValue() {
        return 1.0;
    }

    public long getDuration() {
        return this.endTime > 0L ? this.endTime - this.startTime : System.currentTimeMillis() - this.startTime;
    }

    public ServerTableIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    protected void setSummary(Map<String, String> summary) {
        this.summary = summary;
    }

    protected void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    protected void setStatus(ProcessStatus status) {
        if (status == ProcessStatus.SUCCESS || status == ProcessStatus.FAILED || status == ProcessStatus.CLOSED) {
            this.endTime = System.currentTimeMillis();
        } else if (this.status != ProcessStatus.SUBMITTED && status == ProcessStatus.SUBMITTED) {
            this.endTime = -1L;
            this.failedReason = null;
            this.summary = null;
        }
        this.status = status;
    }

    @Override
    public String getFailedReason() {
        return this.failedReason;
    }

    protected void setFailedReason(String failedReason) {
        this.status = ProcessStatus.FAILED;
        this.failedReason = failedReason;
        this.endTime = System.currentTimeMillis();
    }

    public ProcessStage getStage() {
        return this.status.toStage();
    }

    protected void setId(long processId) {
        this.id = processId;
    }
}

