/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListCustomEntityTypesRequest;
import software.amazon.awssdk.services.glue.model.ListCustomEntityTypesResponse;

public class ListCustomEntityTypesIterable
implements SdkIterable<ListCustomEntityTypesResponse> {
    private final GlueClient client;
    private final ListCustomEntityTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomEntityTypesIterable(GlueClient client, ListCustomEntityTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCustomEntityTypesResponseFetcher();
    }

    public Iterator<ListCustomEntityTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCustomEntityTypesResponseFetcher
    implements SyncPageFetcher<ListCustomEntityTypesResponse> {
        private ListCustomEntityTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomEntityTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomEntityTypesResponse nextPage(ListCustomEntityTypesResponse previousPage) {
            if (previousPage == null) {
                return ListCustomEntityTypesIterable.this.client.listCustomEntityTypes(ListCustomEntityTypesIterable.this.firstRequest);
            }
            return ListCustomEntityTypesIterable.this.client.listCustomEntityTypes((ListCustomEntityTypesRequest)((Object)ListCustomEntityTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

