/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.resource;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.amoro.api.resource.ResourceContainer;
import org.apache.amoro.server.resource.ContainerMetadata;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;

public class ResourceContainers {
    public static final String EXTERNAL_CONTAINER_NAME = "external";
    private static final Map<String, ContainerWrapper> globalContainers = Maps.newHashMap();
    private static volatile boolean isInitialized = false;

    public static void init(List<ContainerMetadata> containerList) {
        Preconditions.checkState((!isInitialized ? 1 : 0) != 0, (Object)"OptimizerContainers has been initialized");
        Preconditions.checkNotNull(containerList, (Object)"containerList is null");
        containerList.forEach(metadata -> globalContainers.put(metadata.getName(), new ContainerWrapper((ContainerMetadata)metadata)));
        isInitialized = true;
    }

    public static ResourceContainer get(String name) {
        ResourceContainers.checkInitialized();
        return Optional.ofNullable(globalContainers.get(name)).map(ContainerWrapper::getContainer).orElseThrow(() -> new IllegalArgumentException("ResourceContainer not found: " + name));
    }

    public static List<ContainerMetadata> getMetadataList() {
        Preconditions.checkState((boolean)isInitialized, (Object)"OptimizerContainers not been initialized");
        return globalContainers.values().stream().map(ContainerWrapper::getMetadata).collect(Collectors.toList());
    }

    private static void checkInitialized() {
        Preconditions.checkState((boolean)isInitialized, (Object)"OptimizerContainers not been initialized");
    }

    public static boolean contains(String name) {
        ResourceContainers.checkInitialized();
        return globalContainers.containsKey(name);
    }

    static {
        ContainerMetadata metadata = new ContainerMetadata(EXTERNAL_CONTAINER_NAME, "");
        ContainerWrapper externalContainer = new ContainerWrapper(metadata, null);
        globalContainers.put(EXTERNAL_CONTAINER_NAME, externalContainer);
    }

    private static class ContainerWrapper {
        private final ResourceContainer container;
        private final ContainerMetadata metadata;

        public ContainerWrapper(ContainerMetadata metadata) {
            this.metadata = metadata;
            this.container = this.loadResourceContainer(metadata.getImplClass());
        }

        ContainerWrapper(ContainerMetadata metadata, ResourceContainer container) {
            this.metadata = metadata;
            this.container = container;
        }

        public ResourceContainer getContainer() {
            return this.container;
        }

        public ContainerMetadata getMetadata() {
            return this.metadata;
        }

        private ResourceContainer loadResourceContainer(String implClass) {
            try {
                Class<?> clazz = Class.forName(implClass);
                ResourceContainer resourceContainer = (ResourceContainer)clazz.newInstance();
                resourceContainer.init(this.metadata.getName(), this.metadata.getProperties());
                return resourceContainer;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("can not init container " + implClass, e);
            }
        }
    }
}

