/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing;

import java.util.Map;
import java.util.Set;
import org.apache.amoro.api.OptimizingTask;
import org.apache.amoro.api.OptimizingTaskId;
import org.apache.amoro.api.OptimizingTaskResult;
import org.apache.amoro.api.StateField;
import org.apache.amoro.optimizing.RewriteFilesInput;
import org.apache.amoro.optimizing.RewriteFilesOutput;
import org.apache.amoro.server.dashboard.utils.OptimizingUtil;
import org.apache.amoro.server.exception.IllegalTaskStateException;
import org.apache.amoro.server.exception.OptimizingClosedException;
import org.apache.amoro.server.exception.TaskRuntimeException;
import org.apache.amoro.server.optimizing.MetricsSummary;
import org.apache.amoro.server.optimizing.plan.TaskDescriptor;
import org.apache.amoro.server.persistence.StatedPersistentBase;
import org.apache.amoro.server.persistence.TaskFilesPersistence;
import org.apache.amoro.server.persistence.mapper.OptimizingMapper;
import org.apache.amoro.server.resource.OptimizerThread;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableSet;
import org.apache.amoro.utils.SerializationUtil;

public class TaskRuntime
extends StatedPersistentBase {
    private long tableId;
    private String partition;
    private OptimizingTaskId taskId;
    @StateField
    private Status status = Status.PLANNED;
    private final TaskStatusMachine statusMachine = new TaskStatusMachine();
    @StateField
    private int runTimes = 0;
    @StateField
    private long startTime = 0L;
    @StateField
    private long endTime = 0L;
    @StateField
    private long costTime = 0L;
    @StateField
    private String token;
    @StateField
    private int threadId = -1;
    @StateField
    private String failReason;
    private TaskOwner owner;
    private RewriteFilesInput input;
    @StateField
    private RewriteFilesOutput output;
    @StateField
    private MetricsSummary summary;
    private Map<String, String> properties;
    private static final Map<Status, Set<Status>> nextStatusMap = ImmutableMap.builder().put((Object)Status.PLANNED, (Object)ImmutableSet.of((Object)((Object)Status.PLANNED), (Object)((Object)Status.SCHEDULED), (Object)((Object)Status.CANCELED))).put((Object)Status.SCHEDULED, (Object)ImmutableSet.of((Object)((Object)Status.PLANNED), (Object)((Object)Status.SCHEDULED), (Object)((Object)Status.ACKED), (Object)((Object)Status.CANCELED))).put((Object)Status.ACKED, (Object)ImmutableSet.of((Object)((Object)Status.PLANNED), (Object)((Object)Status.ACKED), (Object)((Object)Status.SUCCESS), (Object)((Object)Status.FAILED), (Object)((Object)Status.CANCELED))).put((Object)Status.FAILED, (Object)ImmutableSet.of((Object)((Object)Status.PLANNED), (Object)((Object)Status.FAILED))).put((Object)Status.SUCCESS, (Object)ImmutableSet.of((Object)((Object)Status.SUCCESS))).put((Object)Status.CANCELED, (Object)ImmutableSet.of((Object)((Object)Status.CANCELED))).build();

    private TaskRuntime() {
    }

    public TaskRuntime(OptimizingTaskId taskId, TaskDescriptor taskDescriptor, Map<String, String> properties) {
        this.taskId = taskId;
        this.partition = taskDescriptor.getPartition();
        this.input = taskDescriptor.getInput();
        this.summary = new MetricsSummary(this.input);
        this.tableId = taskDescriptor.getTableId();
        this.properties = properties;
    }

    public void complete(OptimizerThread thread, OptimizingTaskResult result) {
        this.invokeConsistency(() -> {
            this.validThread(thread);
            if (result.getErrorMessage() != null) {
                this.statusMachine.accept(Status.FAILED);
                this.failReason = result.getErrorMessage();
                this.endTime = System.currentTimeMillis();
                this.costTime += this.endTime - this.startTime;
            } else {
                this.statusMachine.accept(Status.SUCCESS);
                RewriteFilesOutput filesOutput = TaskFilesPersistence.loadTaskOutput(result.getTaskOutput());
                this.summary.setNewDataFileCnt(OptimizingUtil.getFileCount(filesOutput.getDataFiles()));
                this.summary.setNewDataSize(OptimizingUtil.getFileSize(filesOutput.getDataFiles()));
                this.summary.setNewDataRecordCnt(OptimizingUtil.getRecordCnt(filesOutput.getDataFiles()));
                this.summary.setNewDeleteFileCnt(OptimizingUtil.getFileCount(filesOutput.getDeleteFiles()));
                this.summary.setNewDeleteSize(OptimizingUtil.getFileSize(filesOutput.getDeleteFiles()));
                this.summary.setNewDeleteRecordCnt(OptimizingUtil.getRecordCnt(filesOutput.getDeleteFiles()));
                this.summary.setNewFileSize(this.summary.getNewDataSize() + this.summary.getNewDeleteSize());
                this.summary.setNewFileCnt(this.summary.getNewDataFileCnt() + this.summary.getNewDeleteFileCnt());
                this.endTime = System.currentTimeMillis();
                this.costTime += this.endTime - this.startTime;
                this.output = filesOutput;
            }
            ++this.runTimes;
            this.persistTaskRuntime(this);
            this.owner.acceptResult(this);
            this.token = null;
            this.threadId = -1;
        });
        this.owner.releaseResourcesIfNecessary();
    }

    void reset() {
        this.invokeConsistency(() -> {
            this.statusMachine.accept(Status.PLANNED);
            this.startTime = 0L;
            this.endTime = 0L;
            this.token = null;
            this.threadId = -1;
            this.failReason = null;
            this.output = null;
            this.summary = new MetricsSummary(this.input);
            this.persistTaskRuntime(this);
        });
    }

    public void schedule(OptimizerThread thread) {
        this.invokeConsistency(() -> {
            this.statusMachine.accept(Status.SCHEDULED);
            this.token = thread.getToken();
            this.threadId = thread.getThreadId();
            this.startTime = System.currentTimeMillis();
            this.persistTaskRuntime(this);
        });
    }

    public void ack(OptimizerThread thread) {
        this.invokeConsistency(() -> {
            this.validThread(thread);
            this.statusMachine.accept(Status.ACKED);
            this.persistTaskRuntime(this);
        });
    }

    void tryCanceling() {
        this.invokeConsistency(() -> {
            if (this.statusMachine.tryAccepting(Status.CANCELED)) {
                this.endTime = System.currentTimeMillis();
                if (this.startTime != 0L) {
                    this.costTime += this.endTime - this.startTime;
                }
                this.persistTaskRuntime(this);
            }
        });
    }

    public TaskRuntime claimOwnership(TaskOwner owner) {
        this.owner = owner;
        return this;
    }

    public boolean finished() {
        return this.status == Status.SUCCESS || this.status == Status.FAILED || this.status == Status.CANCELED;
    }

    protected void setInput(RewriteFilesInput input) {
        if (input == null) {
            throw new IllegalStateException("Optimizing input is null, id:" + this.taskId);
        }
        this.input = input;
    }

    public RewriteFilesInput getInput() {
        return this.input;
    }

    public RewriteFilesOutput getOutput() {
        return this.output;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public long getProcessId() {
        return this.taskId.getProcessId();
    }

    public String getResourceDesc() {
        return this.token + ":" + this.threadId;
    }

    public String getToken() {
        return this.token;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public OptimizingTask getOptimizingTask() {
        OptimizingTask optimizingTask = new OptimizingTask(this.taskId);
        optimizingTask.setTaskInput(SerializationUtil.simpleSerialize((Object)this.input));
        optimizingTask.setProperties(this.properties);
        return optimizingTask;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public OptimizingTaskId getTaskId() {
        return this.taskId;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getRunTimes() {
        return this.runTimes;
    }

    public int getRetry() {
        return this.runTimes - 1;
    }

    public MetricsSummary getMetricsSummary() {
        return this.summary;
    }

    public String getPartition() {
        return this.partition;
    }

    public String getFailReason() {
        return this.failReason;
    }

    public long getCostTime() {
        return this.costTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getQuotaTime(long calculatingStartTime, long calculatingEndTime) {
        if (this.startTime == 0L) {
            return 0L;
        }
        calculatingStartTime = Math.max(this.startTime, calculatingStartTime);
        calculatingEndTime = this.costTime == 0L ? calculatingEndTime : this.costTime + this.startTime;
        long lastingTime = calculatingEndTime - calculatingStartTime;
        return Math.max(0L, lastingTime);
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public MetricsSummary getSummary() {
        return this.summary;
    }

    public void setSummary(MetricsSummary summary) {
        this.summary = summary;
    }

    public long getTableId() {
        return this.tableId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableId", this.tableId).add("partition", (Object)this.partition).add("taskId", this.taskId.getTaskId()).add("status", (Object)this.status).add("runTimes", this.runTimes).add("startTime", this.startTime).add("endTime", this.endTime).add("costTime", this.costTime).add("resourceThread", (Object)this.getResourceDesc()).add("failReason", (Object)this.failReason).add("summary", (Object)this.summary).add("properties", this.properties).toString();
    }

    private void validThread(OptimizerThread thread) {
        if (this.token == null) {
            throw new TaskRuntimeException("Task has been reset or not yet scheduled, taskId:%s", this.taskId);
        }
        if (!thread.getToken().equals(this.getToken()) || thread.getThreadId() != this.threadId) {
            throw new TaskRuntimeException("The optimizer thread does not match, the thread in the task is OptimizerThread(token=%s, threadId=%s), and the thread in the request is OptimizerThread(token=%s, threadId=%s).", this.getToken(), this.threadId, thread.getToken(), thread.getThreadId());
        }
    }

    private void persistTaskRuntime(TaskRuntime taskRuntime) {
        this.doAs(OptimizingMapper.class, mapper -> mapper.updateTaskRuntime(taskRuntime));
    }

    public TaskQuota getCurrentQuota() {
        if (this.startTime == 0L || this.endTime == 0L) {
            throw new IllegalStateException("start time or end time is not correctly set");
        }
        return new TaskQuota(this);
    }

    public static enum Status {
        PLANNED,
        SCHEDULED,
        ACKED,
        FAILED,
        SUCCESS,
        CANCELED;

    }

    public static interface TaskOwner {
        public void acceptResult(TaskRuntime var1);

        public void releaseResourcesIfNecessary();

        public boolean isClosed();
    }

    private class TaskStatusMachine {
        private TaskStatusMachine() {
        }

        public void accept(Status targetStatus) {
            if (TaskRuntime.this.owner.isClosed()) {
                throw new OptimizingClosedException(TaskRuntime.this.taskId.getProcessId());
            }
            if (!this.getNext().contains((Object)targetStatus)) {
                throw new IllegalTaskStateException(TaskRuntime.this.taskId, TaskRuntime.this.status, targetStatus);
            }
            TaskRuntime.this.status = targetStatus;
        }

        private Set<Status> getNext() {
            return (Set)nextStatusMap.get((Object)TaskRuntime.this.status);
        }

        public synchronized boolean tryAccepting(Status targetStatus) {
            if (!this.getNext().contains((Object)targetStatus)) {
                return false;
            }
            TaskRuntime.this.status = targetStatus;
            return true;
        }
    }

    public static class TaskQuota {
        private long processId;
        private int taskId;
        private int retryNum;
        private long startTime;
        private long endTime;
        private String failReason;
        private long tableId;

        public TaskQuota() {
        }

        public TaskQuota(TaskRuntime task) {
            this.startTime = task.getStartTime();
            this.endTime = task.getEndTime();
            this.processId = task.getTaskId().getProcessId();
            this.taskId = task.getTaskId().getTaskId();
            this.tableId = task.getTableId();
            this.retryNum = task.getRetry();
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getProcessId() {
            return this.processId;
        }

        public int getTaskId() {
            return this.taskId;
        }

        public int getRetryNum() {
            return this.retryNum;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public String getFailReason() {
            return this.failReason;
        }

        public long getTableId() {
            return this.tableId;
        }

        public long getQuotaTime(long calculatingStartTime) {
            long lastingTime = this.endTime - Math.max(this.startTime, calculatingStartTime);
            return Math.max(0L, lastingTime);
        }

        public boolean checkExpired(long validTime) {
            return this.endTime <= validTime;
        }
    }
}

