/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.controller;

import io.javalin.http.Context;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import org.apache.amoro.api.ServerTableIdentifier;
import org.apache.amoro.api.resource.Resource;
import org.apache.amoro.api.resource.ResourceGroup;
import org.apache.amoro.api.resource.ResourceType;
import org.apache.amoro.server.DefaultOptimizingService;
import org.apache.amoro.server.dashboard.model.OptimizerInstanceInfo;
import org.apache.amoro.server.dashboard.model.OptimizerResourceInfo;
import org.apache.amoro.server.dashboard.model.TableOptimizingInfo;
import org.apache.amoro.server.dashboard.response.OkResponse;
import org.apache.amoro.server.dashboard.response.PageResult;
import org.apache.amoro.server.dashboard.utils.OptimizingUtil;
import org.apache.amoro.server.resource.ContainerMetadata;
import org.apache.amoro.server.resource.OptimizerInstance;
import org.apache.amoro.server.resource.ResourceContainers;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class OptimizerController {
    private static final String ALL_GROUP = "all";
    private final TableService tableService;
    private final DefaultOptimizingService optimizerManager;

    public OptimizerController(TableService tableService, DefaultOptimizingService optimizerManager) {
        this.tableService = tableService;
        this.optimizerManager = optimizerManager;
    }

    public void getOptimizerTables(Context ctx) {
        String optimizerGroup = ctx.pathParam("optimizerGroup");
        String dbFilterStr = ctx.queryParam("dbSearchInput");
        String tableFilterStr = ctx.queryParam("tableSearchInput");
        Integer page = (Integer)ctx.queryParamAsClass("page", Integer.class).getOrDefault((Object)1);
        Integer pageSize = (Integer)ctx.queryParamAsClass("pageSize", Integer.class).getOrDefault((Object)20);
        int offset = (page - 1) * pageSize;
        ArrayList<TableRuntime> tableRuntimes = new ArrayList<TableRuntime>();
        List<ServerTableIdentifier> tables = this.tableService.listManagedTables();
        for (ServerTableIdentifier identifier : tables) {
            TableRuntime tableRuntime = this.tableService.getRuntime(identifier);
            if (tableRuntime == null || !ALL_GROUP.equals(optimizerGroup) && !tableRuntime.getOptimizerGroup().equals(optimizerGroup) || !StringUtils.isEmpty((CharSequence)dbFilterStr) && !StringUtils.containsIgnoreCase((CharSequence)identifier.getDatabase(), (CharSequence)dbFilterStr) || !StringUtils.isEmpty((CharSequence)tableFilterStr) && !StringUtils.containsIgnoreCase((CharSequence)identifier.getTableName(), (CharSequence)tableFilterStr)) continue;
            tableRuntimes.add(tableRuntime);
        }
        tableRuntimes.sort((o1, o2) -> {
            int statDiff = o1.getOptimizingStatus().compareTo(o2.getOptimizingStatus());
            if (statDiff == 0) {
                long timeDiff = o1.getCurrentStatusStartTime() - o2.getCurrentStatusStartTime();
                return timeDiff >= 0L ? (timeDiff == 0L ? 0 : -1) : 1;
            }
            return statDiff;
        });
        PageResult<TableOptimizingInfo> amsPageResult = PageResult.of(tableRuntimes, offset, pageSize, OptimizingUtil::buildTableOptimizeInfo);
        ctx.json(OkResponse.of(amsPageResult));
    }

    public void getOptimizers(Context ctx) {
        String optimizerGroup = ctx.pathParam("optimizerGroup");
        Integer page = (Integer)ctx.queryParamAsClass("page", Integer.class).getOrDefault((Object)1);
        Integer pageSize = (Integer)ctx.queryParamAsClass("pageSize", Integer.class).getOrDefault((Object)20);
        int offset = (page - 1) * pageSize;
        List<OptimizerInstance> optimizers = optimizerGroup.equals(ALL_GROUP) ? this.optimizerManager.listOptimizers() : this.optimizerManager.listOptimizers(optimizerGroup);
        ArrayList<OptimizerInstance> optimizerList = new ArrayList<OptimizerInstance>(optimizers);
        optimizerList.sort(Comparator.comparingLong(OptimizerInstance::getStartTime).reversed());
        List result = optimizerList.stream().map(e -> OptimizerInstanceInfo.builder().token(e.getToken()).startTime(e.getStartTime()).touchTime(e.getTouchTime()).jobId(e.getResourceId()).groupName(e.getGroupName()).coreNumber(e.getThreadCount()).memory(e.getMemoryMb()).jobStatus("RUNNING").container(e.getContainerName()).build()).collect(Collectors.toList());
        PageResult amsPageResult = PageResult.of(result, offset, pageSize);
        ctx.json(OkResponse.of(amsPageResult));
    }

    public void getOptimizerGroups(Context ctx) {
        List result = this.optimizerManager.listResourceGroups().stream().filter(resourceGroup -> !"external".equals(resourceGroup.getContainer())).map(e -> {
            HashMap<String, String> mapObj = new HashMap<String, String>();
            mapObj.put("optimizerGroupName", e.getName());
            return mapObj;
        }).collect(Collectors.toList());
        ctx.json(OkResponse.of(result));
    }

    public void getOptimizerGroupInfo(Context ctx) {
        String optimizerGroup = ctx.pathParam("optimizerGroup");
        List<OptimizerInstance> optimizers = optimizerGroup.equals(ALL_GROUP) ? this.optimizerManager.listOptimizers() : this.optimizerManager.listOptimizers(optimizerGroup);
        OptimizerResourceInfo optimizerResourceInfo = new OptimizerResourceInfo();
        optimizers.forEach(e -> {
            optimizerResourceInfo.addOccupationCore(e.getThreadCount());
            optimizerResourceInfo.addOccupationMemory(e.getMemoryMb());
        });
        ctx.json(OkResponse.of(optimizerResourceInfo));
    }

    public void releaseOptimizer(Context ctx) {
        String resourceId = ctx.pathParam("jobId");
        Preconditions.checkArgument((!resourceId.isEmpty() ? 1 : 0) != 0, (Object)"resource id can not be empty, maybe it's a external optimizer");
        List optimizerInstances = this.optimizerManager.listOptimizers().stream().filter(e -> resourceId.equals(e.getResourceId())).collect(Collectors.toList());
        Preconditions.checkState((!optimizerInstances.isEmpty() ? 1 : 0) != 0, (Object)String.format("The resource ID %s has not been indexed to any optimizer.", resourceId));
        Resource resource = this.optimizerManager.getResource(resourceId);
        resource.getProperties().putAll(((OptimizerInstance)((Object)optimizerInstances.get(0))).getProperties());
        ResourceContainers.get(resource.getContainerName()).releaseOptimizer(resource);
        this.optimizerManager.deleteResource(resourceId);
        this.optimizerManager.deleteOptimizer(resource.getGroupName(), resourceId);
        ctx.json(OkResponse.of("Success to release optimizer"));
    }

    public void scaleOutOptimizer(Context ctx) {
        String optimizerGroup = ctx.pathParam("optimizerGroup");
        Map map = (Map)ctx.bodyAsClass(Map.class);
        int parallelism = (Integer)map.get("parallelism");
        ResourceGroup resourceGroup = this.optimizerManager.getResourceGroup(optimizerGroup);
        Resource resource = new Resource.Builder(resourceGroup.getContainer(), resourceGroup.getName(), ResourceType.OPTIMIZER).setProperties(resourceGroup.getProperties()).setThreadCount(parallelism).build();
        ResourceContainers.get(resource.getContainerName()).requestResource(resource);
        this.optimizerManager.createResource(resource);
        ctx.json(OkResponse.of("success to scaleOut optimizer"));
    }

    public void getResourceGroup(Context ctx) {
        List result = this.optimizerManager.listResourceGroups().stream().map(group -> {
            List<OptimizerInstance> optimizers = this.optimizerManager.listOptimizers(group.getName());
            OptimizerResourceInfo optimizerResourceInfo = new OptimizerResourceInfo();
            optimizerResourceInfo.setResourceGroup(this.optimizerManager.getResourceGroup(group.getName()));
            optimizers.forEach(optimizer -> {
                optimizerResourceInfo.addOccupationCore(optimizer.getThreadCount());
                optimizerResourceInfo.addOccupationMemory(optimizer.getMemoryMb());
            });
            return optimizerResourceInfo;
        }).collect(Collectors.toList());
        ctx.json(OkResponse.of(result));
    }

    public void createResourceGroup(Context ctx) {
        Map map = (Map)ctx.bodyAsClass(Map.class);
        String name = (String)map.get("name");
        String container = (String)map.get("container");
        Map properties = (Map)map.get("properties");
        if (this.optimizerManager.getResourceGroup(name) != null) {
            throw new BadRequestException(String.format("Optimizer group:%s already existed.", name));
        }
        ResourceGroup.Builder builder = new ResourceGroup.Builder(name, container);
        builder.addProperties(properties);
        this.optimizerManager.createResourceGroup(builder.build());
        ctx.json(OkResponse.of("The optimizer group has been successfully created."));
    }

    public void updateResourceGroup(Context ctx) {
        Map map = (Map)ctx.bodyAsClass(Map.class);
        String name = (String)map.get("name");
        String container = (String)map.get("container");
        Map properties = (Map)map.get("properties");
        ResourceGroup.Builder builder = new ResourceGroup.Builder(name, container);
        builder.addProperties(properties);
        this.optimizerManager.updateResourceGroup(builder.build());
        ctx.json(OkResponse.of("The optimizer group has been successfully updated."));
    }

    public void deleteResourceGroup(Context ctx) {
        String name = ctx.pathParam("resourceGroupName");
        this.optimizerManager.deleteResourceGroup(name);
        ctx.json(OkResponse.of("The optimizer group has been successfully deleted."));
    }

    public void deleteCheckResourceGroup(Context ctx) {
        String name = ctx.pathParam("resourceGroupName");
        ctx.json(OkResponse.of(this.optimizerManager.canDeleteResourceGroup(name)));
    }

    public void getContainers(Context ctx) {
        ctx.json(OkResponse.of(ResourceContainers.getMetadataList().stream().map(ContainerMetadata::getName).collect(Collectors.toList())));
    }
}

