/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.iceberg.spark.actions.SparkShufflingDataRewriter;
import org.apache.iceberg.spark.actions.SparkZOrderUDF;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SparkZOrderDataRewriter
extends SparkShufflingDataRewriter {
    private static final Logger LOG = LoggerFactory.getLogger(SparkZOrderDataRewriter.class);
    private static final String Z_COLUMN = "ICEZVALUE";
    private static final Schema Z_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"ICEZVALUE", (Type)Types.BinaryType.get())});
    private static final SortOrder Z_SORT_ORDER = SortOrder.builderFor((Schema)Z_SCHEMA).sortBy("ICEZVALUE", SortDirection.ASC, NullOrder.NULLS_LAST).build();
    public static final String MAX_OUTPUT_SIZE = "max-output-size";
    public static final int MAX_OUTPUT_SIZE_DEFAULT = Integer.MAX_VALUE;
    public static final String VAR_LENGTH_CONTRIBUTION = "var-length-contribution";
    public static final int VAR_LENGTH_CONTRIBUTION_DEFAULT = 8;
    private final List<String> zOrderColNames;
    private int maxOutputSize;
    private int varLengthContribution;

    SparkZOrderDataRewriter(SparkSession spark, Table table, List<String> zOrderColNames) {
        super(spark, table);
        this.zOrderColNames = this.validZOrderColNames(spark, table, zOrderColNames);
    }

    public String description() {
        return "Z-ORDER";
    }

    @Override
    public Set<String> validOptions() {
        return ImmutableSet.builder().addAll(super.validOptions()).add((Object)MAX_OUTPUT_SIZE).add((Object)VAR_LENGTH_CONTRIBUTION).build();
    }

    @Override
    public void init(Map<String, String> options) {
        super.init(options);
        this.maxOutputSize = this.maxOutputSize(options);
        this.varLengthContribution = this.varLengthContribution(options);
    }

    @Override
    protected Dataset<Row> sortedDF(Dataset<Row> df, List<FileScanTask> group) {
        Dataset zValueDF = df.withColumn(Z_COLUMN, this.zValue(df));
        Dataset<Row> sortedDF = this.sort((Dataset<Row>)zValueDF, this.outputSortOrder(group, Z_SORT_ORDER));
        return sortedDF.drop(Z_COLUMN);
    }

    private Column zValue(Dataset<Row> df) {
        SparkZOrderUDF zOrderUDF = new SparkZOrderUDF(this.zOrderColNames.size(), this.varLengthContribution, this.maxOutputSize);
        Column[] zOrderCols = (Column[])this.zOrderColNames.stream().map(arg_0 -> ((StructType)df.schema()).apply(arg_0)).map(col -> zOrderUDF.sortedLexicographically(df.col(col.name()), col.dataType())).toArray(Column[]::new);
        return zOrderUDF.interleaveBytes(functions.array((Column[])zOrderCols));
    }

    private int varLengthContribution(Map<String, String> options) {
        int value = PropertyUtil.propertyAsInt(options, (String)VAR_LENGTH_CONTRIBUTION, (int)8);
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"Cannot use less than 1 byte for variable length types with ZOrder, '%s' was set to %s", (Object)VAR_LENGTH_CONTRIBUTION, (int)value);
        return value;
    }

    private int maxOutputSize(Map<String, String> options) {
        int value = PropertyUtil.propertyAsInt(options, (String)MAX_OUTPUT_SIZE, (int)Integer.MAX_VALUE);
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"Cannot have the interleaved ZOrder value use less than 1 byte, '%s' was set to %s", (Object)MAX_OUTPUT_SIZE, (int)value);
        return value;
    }

    private List<String> validZOrderColNames(SparkSession spark, Table table, List<String> inputZOrderColNames) {
        Preconditions.checkArgument((inputZOrderColNames != null && !inputZOrderColNames.isEmpty() ? 1 : 0) != 0, (Object)"Cannot ZOrder when no columns are specified");
        Schema schema = table.schema();
        Set identityPartitionFieldIds = table.spec().identitySourceIds();
        boolean caseSensitive = SparkUtil.caseSensitive(spark);
        ArrayList validZOrderColNames = Lists.newArrayList();
        for (String colName : inputZOrderColNames) {
            Types.NestedField field = caseSensitive ? schema.findField(colName) : schema.caseInsensitiveFindField(colName);
            Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot find column '%s' in table schema (case sensitive = %s): %s", (Object)colName, (Object)caseSensitive, (Object)schema.asStruct());
            if (identityPartitionFieldIds.contains(field.fieldId())) {
                LOG.warn("Ignoring '{}' as such values are constant within a partition", (Object)colName);
                continue;
            }
            validZOrderColNames.add(colName);
        }
        Preconditions.checkArgument((validZOrderColNames.size() > 0 ? 1 : 0) != 0, (Object)"Cannot ZOrder, all columns provided were identity partition columns and cannot be used");
        return validZOrderColNames;
    }
}

