/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.writer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.api.BlockableOperation;
import org.apache.amoro.api.OperationConflictException;
import org.apache.amoro.hive.utils.HiveTableUtil;
import org.apache.amoro.mixed.MixedFormatCatalog;
import org.apache.amoro.op.OverwriteBaseFiles;
import org.apache.amoro.op.RewritePartitions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.spark.io.TaskWriters;
import org.apache.amoro.spark.sql.utils.RowDeltaUtils;
import org.apache.amoro.spark.writer.MixedFormatSparkWriteBuilder;
import org.apache.amoro.spark.writer.SimpleInternalRowDataWriter;
import org.apache.amoro.spark.writer.SimpleRowLevelDataWriter;
import org.apache.amoro.spark.writer.WriteTaskCommit;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.blocker.Blocker;
import org.apache.amoro.table.blocker.TableBlockerManager;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.Write;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class KeyedSparkBatchWrite
implements MixedFormatSparkWriteBuilder.MixedFormatWrite,
Write {
    private final KeyedTable table;
    private final StructType dsSchema;
    private final long txId;
    private final String hiveSubdirectory;
    private final boolean orderedWriter;
    private final MixedFormatCatalog catalog;

    KeyedSparkBatchWrite(KeyedTable table, LogicalWriteInfo info, MixedFormatCatalog catalog) {
        this.table = table;
        this.dsSchema = info.schema();
        this.txId = table.beginTransaction(null);
        this.hiveSubdirectory = HiveTableUtil.newHiveSubdirectory((long)this.txId);
        this.orderedWriter = Boolean.parseBoolean((String)info.options().getOrDefault((Object)"writer.distributed-and-ordered", (Object)"false"));
        this.catalog = catalog;
    }

    @Override
    public BatchWrite asBatchAppend() {
        return new AppendWrite();
    }

    @Override
    public BatchWrite asDynamicOverwrite() {
        return new DynamicOverwrite();
    }

    @Override
    public BatchWrite asOverwriteByFilter(Expression overwriteExpr) {
        return new OverwriteByFilter(overwriteExpr);
    }

    @Override
    public BatchWrite asUpsertWrite() {
        return new UpsertWrite();
    }

    private class AppendWrite
    extends BaseBatchWrite {
        private AppendWrite() {
        }

        public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
            this.getBlocker();
            return new ChangeWriteFactory(KeyedSparkBatchWrite.this.table, KeyedSparkBatchWrite.this.dsSchema, KeyedSparkBatchWrite.this.txId, KeyedSparkBatchWrite.this.orderedWriter);
        }

        public void commit(WriterCommitMessage[] messages) {
            this.checkBlocker(this.tableBlockerManager);
            AppendFiles append = KeyedSparkBatchWrite.this.table.changeTable().newAppend();
            for (DataFile file : WriteTaskCommit.files(messages)) {
                append.appendFile(file);
            }
            append.commit();
            this.tableBlockerManager.release(this.block);
        }
    }

    private class DynamicOverwrite
    extends BaseBatchWrite {
        private DynamicOverwrite() {
        }

        public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
            this.getBlocker();
            return new BaseWriterFactory(KeyedSparkBatchWrite.this.table, KeyedSparkBatchWrite.this.dsSchema, KeyedSparkBatchWrite.this.txId, KeyedSparkBatchWrite.this.hiveSubdirectory, KeyedSparkBatchWrite.this.orderedWriter);
        }

        public void commit(WriterCommitMessage[] messages) {
            this.checkBlocker(this.tableBlockerManager);
            RewritePartitions rewritePartitions = KeyedSparkBatchWrite.this.table.newRewritePartitions();
            rewritePartitions.updateOptimizedSequenceDynamically(KeyedSparkBatchWrite.this.txId);
            for (DataFile file : WriteTaskCommit.files(messages)) {
                rewritePartitions.addDataFile(file);
            }
            rewritePartitions.commit();
            this.tableBlockerManager.release(this.block);
        }
    }

    private class OverwriteByFilter
    extends BaseBatchWrite {
        private final Expression overwriteExpr;

        private OverwriteByFilter(Expression overwriteExpr) {
            this.overwriteExpr = overwriteExpr;
        }

        public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
            this.getBlocker();
            return new BaseWriterFactory(KeyedSparkBatchWrite.this.table, KeyedSparkBatchWrite.this.dsSchema, KeyedSparkBatchWrite.this.txId, KeyedSparkBatchWrite.this.hiveSubdirectory, KeyedSparkBatchWrite.this.orderedWriter);
        }

        public void commit(WriterCommitMessage[] messages) {
            this.checkBlocker(this.tableBlockerManager);
            OverwriteBaseFiles overwriteBaseFiles = KeyedSparkBatchWrite.this.table.newOverwriteBaseFiles();
            overwriteBaseFiles.overwriteByRowFilter(this.overwriteExpr);
            overwriteBaseFiles.updateOptimizedSequenceDynamically(KeyedSparkBatchWrite.this.txId);
            overwriteBaseFiles.set("delete-untracked-hive-file", "true");
            for (DataFile file : WriteTaskCommit.files(messages)) {
                overwriteBaseFiles.addFile(file);
            }
            overwriteBaseFiles.commit();
            this.tableBlockerManager.release(this.block);
        }
    }

    private class UpsertWrite
    extends BaseBatchWrite {
        private UpsertWrite() {
        }

        public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
            this.getBlocker();
            return new UpsertChangeFactory(KeyedSparkBatchWrite.this.table, KeyedSparkBatchWrite.this.dsSchema, KeyedSparkBatchWrite.this.txId, KeyedSparkBatchWrite.this.orderedWriter);
        }

        public void commit(WriterCommitMessage[] messages) {
            this.checkBlocker(this.tableBlockerManager);
            AppendFiles append = KeyedSparkBatchWrite.this.table.changeTable().newAppend();
            for (DataFile file : WriteTaskCommit.files(messages)) {
                append.appendFile(file);
            }
            append.commit();
            this.tableBlockerManager.release(this.block);
        }
    }

    private static class UpsertChangeFactory
    extends AbstractWriterFactory {
        UpsertChangeFactory(KeyedTable table, StructType dsSchema, long transactionId, boolean orderedWrite) {
            super(table, dsSchema, transactionId, orderedWrite);
        }

        public DataWriter<InternalRow> createWriter(int partitionId, long taskId) {
            StructType schema = new StructType((StructField[])Arrays.stream(this.dsSchema.fields()).filter(field -> !field.name().equals(RowDeltaUtils.OPERATION_COLUMN())).toArray(StructField[]::new));
            return new SimpleRowLevelDataWriter(this.newWriter(partitionId, taskId, schema), this.newWriter(partitionId, taskId, schema), this.dsSchema, true);
        }
    }

    private static class ChangeWriteFactory
    extends AbstractWriterFactory {
        ChangeWriteFactory(KeyedTable table, StructType dsSchema, long transactionId, boolean orderedWrite) {
            super(table, dsSchema, transactionId, orderedWrite);
        }

        public DataWriter<InternalRow> createWriter(int partitionId, long taskId) {
            return new SimpleRowLevelDataWriter(this.newWriter(partitionId, taskId, this.dsSchema), this.newWriter(partitionId, taskId, this.dsSchema), this.dsSchema, true);
        }
    }

    private static class BaseWriterFactory
    extends AbstractWriterFactory {
        protected final String hiveSubdirectory;

        BaseWriterFactory(KeyedTable table, StructType dsSchema, Long transactionId, String hiveSubdirectory, boolean orderedWrite) {
            super(table, dsSchema, transactionId, orderedWrite);
            this.hiveSubdirectory = hiveSubdirectory;
        }

        public DataWriter<InternalRow> createWriter(int partitionId, long taskId) {
            TaskWriters writerBuilder = TaskWriters.of((MixedTable)this.table).withTransactionId(this.transactionId).withPartitionId(partitionId).withTaskId(taskId).withDataSourceSchema(this.dsSchema).withOrderedWriter(this.orderedWrite).withHiveSubdirectory(this.hiveSubdirectory);
            TaskWriter<InternalRow> writer = writerBuilder.newBaseWriter(true);
            return new SimpleInternalRowDataWriter(writer);
        }
    }

    private static abstract class AbstractWriterFactory
    implements DataWriterFactory,
    Serializable {
        protected final KeyedTable table;
        protected final StructType dsSchema;
        protected final Long transactionId;
        protected final boolean orderedWrite;

        AbstractWriterFactory(KeyedTable table, StructType dsSchema, Long transactionId, boolean orderedWrite) {
            this.table = table;
            this.dsSchema = dsSchema;
            this.transactionId = transactionId;
            this.orderedWrite = orderedWrite;
        }

        public TaskWriter<InternalRow> newWriter(int partitionId, long taskId, StructType schema) {
            return TaskWriters.of((MixedTable)this.table).withTransactionId(this.transactionId).withPartitionId(partitionId).withTaskId(taskId).withDataSourceSchema(schema).withOrderedWriter(this.orderedWrite).newChangeWriter();
        }
    }

    private abstract class BaseBatchWrite
    implements BatchWrite {
        protected TableBlockerManager tableBlockerManager;
        protected Blocker block;

        private BaseBatchWrite() {
        }

        public void abort(WriterCommitMessage[] messages) {
            try {
                Map props = KeyedSparkBatchWrite.this.table.properties();
                Tasks.foreach(WriteTaskCommit.files(messages)).retry(PropertyUtil.propertyAsInt((Map)props, (String)"commit.retry.num-retries", (int)4)).exponentialBackoff((long)PropertyUtil.propertyAsInt((Map)props, (String)"commit.retry.min-wait-ms", (int)100), (long)PropertyUtil.propertyAsInt((Map)props, (String)"commit.retry.max-wait-ms", (int)60000), (long)PropertyUtil.propertyAsInt((Map)props, (String)"commit.retry.total-timeout-ms", (int)1800000), 2.0).throwFailureWhenFinished().run(file -> KeyedSparkBatchWrite.this.table.io().deleteFile(file.path().toString()));
            }
            finally {
                this.tableBlockerManager.release(this.block);
            }
        }

        public void checkBlocker(TableBlockerManager tableBlockerManager) {
            List blockerIds = tableBlockerManager.getBlockers().stream().map(Blocker::blockerId).collect(Collectors.toList());
            if (!blockerIds.contains(this.block.blockerId())) {
                throw new IllegalStateException("block is not in blockerManager");
            }
        }

        public void getBlocker() {
            this.tableBlockerManager = KeyedSparkBatchWrite.this.catalog.getTableBlockerManager(KeyedSparkBatchWrite.this.table.id());
            ArrayList operations = Lists.newArrayList();
            operations.add(BlockableOperation.BATCH_WRITE);
            operations.add(BlockableOperation.OPTIMIZE);
            try {
                this.block = this.tableBlockerManager.block((List)operations);
            }
            catch (OperationConflictException e) {
                throw new IllegalStateException("failed to block table " + KeyedSparkBatchWrite.this.table.id() + " with " + operations, e);
            }
        }
    }
}

