/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.marshaller.MarshallerException;
import org.apache.ignite.internal.schema.marshaller.RecordMarshaller;
import org.apache.ignite.internal.schema.marshaller.reflection.RecordMarshallerImpl;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.table.AbstractTableView;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.table.InvokeProcessor;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecordViewImpl<R>
extends AbstractTableView
implements RecordView<R> {
    private final Function<SchemaDescriptor, RecordMarshaller<R>> marshallerFactory = schema -> new RecordMarshallerImpl(schema, mapper);
    private volatile RecordMarshaller<R> marsh;

    public RecordViewImpl(InternalTable tbl, SchemaRegistry schemaReg, Mapper<R> mapper) {
        super(tbl, schemaReg);
    }

    public R get(@Nullable Transaction tx, @NotNull R keyRec) {
        return this.sync(this.getAsync(tx, keyRec));
    }

    @NotNull
    public CompletableFuture<R> getAsync(@Nullable Transaction tx, @NotNull R keyRec) {
        BinaryRowEx keyRow = this.marshalKey(Objects.requireNonNull(keyRec));
        return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(this::unmarshal);
    }

    public Collection<R> getAll(@Nullable Transaction tx, @NotNull Collection<R> keyRecs) {
        return this.sync(this.getAllAsync(tx, keyRecs));
    }

    @NotNull
    public CompletableFuture<Collection<R>> getAllAsync(@Nullable Transaction tx, @NotNull Collection<R> keyRecs) {
        Objects.requireNonNull(keyRecs);
        return this.tbl.getAll(this.marshalKeys(keyRecs), (InternalTransaction)tx).thenApply(this::unmarshal);
    }

    public void upsert(@Nullable Transaction tx, @NotNull R rec) {
        this.sync(this.upsertAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, @NotNull R rec) {
        BinaryRowEx keyRow = this.marshal(Objects.requireNonNull(rec));
        return this.tbl.upsert(keyRow, (InternalTransaction)tx);
    }

    public void upsertAll(@Nullable Transaction tx, @NotNull Collection<R> recs) {
        this.sync(this.upsertAllAsync(tx, recs));
    }

    @NotNull
    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, @NotNull Collection<R> recs) {
        Objects.requireNonNull(recs);
        return this.tbl.upsertAll(this.marshal(recs), (InternalTransaction)tx);
    }

    public R getAndUpsert(@Nullable Transaction tx, @NotNull R rec) {
        return this.sync(this.getAndUpsertAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<R> getAndUpsertAsync(@Nullable Transaction tx, @NotNull R rec) {
        BinaryRowEx keyRow = this.marshal(Objects.requireNonNull(rec));
        return this.tbl.getAndUpsert(keyRow, (InternalTransaction)tx).thenApply(this::unmarshal);
    }

    public boolean insert(@Nullable Transaction tx, @NotNull R rec) {
        return this.sync(this.insertAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, @NotNull R rec) {
        BinaryRowEx keyRow = this.marshal(Objects.requireNonNull(rec));
        return this.tbl.insert(keyRow, (InternalTransaction)tx);
    }

    public Collection<R> insertAll(@Nullable Transaction tx, @NotNull Collection<R> recs) {
        return this.sync(this.insertAllAsync(tx, recs));
    }

    @NotNull
    public CompletableFuture<Collection<R>> insertAllAsync(@Nullable Transaction tx, @NotNull Collection<R> recs) {
        Collection<BinaryRowEx> rows = this.marshal(Objects.requireNonNull(recs));
        return this.tbl.insertAll(rows, (InternalTransaction)tx).thenApply(this::unmarshal);
    }

    public boolean replace(@Nullable Transaction tx, @NotNull R rec) {
        return this.sync(this.replaceAsync(tx, rec));
    }

    public boolean replace(@Nullable Transaction tx, @NotNull R oldRec, @NotNull R newRec) {
        return this.sync(this.replaceAsync(tx, oldRec, newRec));
    }

    @NotNull
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, @NotNull R rec) {
        BinaryRowEx newRow = this.marshal(Objects.requireNonNull(rec));
        return this.tbl.replace(newRow, (InternalTransaction)tx);
    }

    @NotNull
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, @NotNull R oldRec, @NotNull R newRec) {
        BinaryRowEx oldRow = this.marshal(Objects.requireNonNull(oldRec));
        BinaryRowEx newRow = this.marshal(Objects.requireNonNull(newRec));
        return this.tbl.replace(oldRow, newRow, (InternalTransaction)tx);
    }

    public R getAndReplace(@Nullable Transaction tx, @NotNull R rec) {
        return this.sync(this.getAndReplaceAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<R> getAndReplaceAsync(@Nullable Transaction tx, @NotNull R rec) {
        BinaryRowEx row = this.marshal(Objects.requireNonNull(rec));
        return this.tbl.getAndReplace(row, (InternalTransaction)tx).thenApply(this::unmarshal);
    }

    public boolean delete(@Nullable Transaction tx, @NotNull R keyRec) {
        return this.sync(this.deleteAsync(tx, keyRec));
    }

    @NotNull
    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, @NotNull R keyRec) {
        BinaryRowEx row = this.marshalKey(Objects.requireNonNull(keyRec));
        return this.tbl.delete(row, (InternalTransaction)tx);
    }

    public boolean deleteExact(@Nullable Transaction tx, @NotNull R rec) {
        return this.sync(this.deleteExactAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, @NotNull R keyRec) {
        BinaryRowEx row = this.marshal(Objects.requireNonNull(keyRec));
        return this.tbl.deleteExact(row, (InternalTransaction)tx);
    }

    public R getAndDelete(@Nullable Transaction tx, @NotNull R keyRec) {
        return this.sync(this.getAndDeleteAsync(tx, keyRec));
    }

    @NotNull
    public CompletableFuture<R> getAndDeleteAsync(@Nullable Transaction tx, @NotNull R keyRec) {
        BinaryRowEx row = this.marshalKey(keyRec);
        return this.tbl.getAndDelete(row, (InternalTransaction)tx).thenApply(this::unmarshal);
    }

    public Collection<R> deleteAll(@Nullable Transaction tx, @NotNull Collection<R> keyRecs) {
        return this.sync(this.deleteAllAsync(tx, keyRecs));
    }

    @NotNull
    public CompletableFuture<Collection<R>> deleteAllAsync(@Nullable Transaction tx, @NotNull Collection<R> keyRecs) {
        Collection<BinaryRowEx> rows = this.marshal(Objects.requireNonNull(keyRecs));
        return this.tbl.deleteAll(rows, (InternalTransaction)tx).thenApply(this::unmarshal);
    }

    public Collection<R> deleteAllExact(@Nullable Transaction tx, @NotNull Collection<R> recs) {
        return this.sync(this.deleteAllExactAsync(tx, recs));
    }

    @NotNull
    public CompletableFuture<Collection<R>> deleteAllExactAsync(@Nullable Transaction tx, @NotNull Collection<R> keyRecs) {
        Collection<BinaryRowEx> rows = this.marshal(Objects.requireNonNull(keyRecs));
        return this.tbl.deleteAllExact(rows, (InternalTransaction)tx).thenApply(this::unmarshal);
    }

    public <T extends Serializable> T invoke(@Nullable Transaction tx, @NotNull R keyRec, InvokeProcessor<R, R, T> proc) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @NotNull
    public <T extends Serializable> CompletableFuture<T> invokeAsync(@Nullable Transaction tx, @NotNull R keyRec, InvokeProcessor<R, R, T> proc) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public <T extends Serializable> Map<R, T> invokeAll(@Nullable Transaction tx, @NotNull Collection<R> keyRecs, InvokeProcessor<R, R, T> proc) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @NotNull
    public <T extends Serializable> CompletableFuture<Map<R, T>> invokeAllAsync(@Nullable Transaction tx, @NotNull Collection<R> keyRecs, InvokeProcessor<R, R, T> proc) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private RecordMarshaller<R> marshaller(int schemaVersion) {
        RecordMarshaller<R> marsh = this.marsh;
        if (marsh != null && marsh.schemaVersion() == schemaVersion) {
            return marsh;
        }
        this.marsh = this.marshallerFactory.apply(this.schemaReg.schema(schemaVersion));
        return this.marsh;
    }

    private BinaryRowEx marshal(R rec) {
        RecordMarshaller<R> marsh = this.marshaller(this.schemaReg.lastSchemaVersion());
        try {
            return marsh.marshal(rec);
        }
        catch (MarshallerException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private Collection<BinaryRowEx> marshal(Collection<R> recs) {
        RecordMarshaller<R> marsh = this.marshaller(this.schemaReg.lastSchemaVersion());
        ArrayList<BinaryRowEx> rows = new ArrayList<BinaryRowEx>(recs.size());
        try {
            for (R rec : recs) {
                Row row = marsh.marshal(Objects.requireNonNull(rec));
                rows.add((BinaryRowEx)row);
            }
            return rows;
        }
        catch (MarshallerException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private BinaryRowEx marshalKey(@NotNull R rec) {
        RecordMarshaller<R> marsh = this.marshaller(this.schemaReg.lastSchemaVersion());
        try {
            return marsh.marshalKey(rec);
        }
        catch (MarshallerException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private Collection<BinaryRowEx> marshalKeys(Collection<R> recs) {
        RecordMarshaller<R> marsh = this.marshaller(this.schemaReg.lastSchemaVersion());
        ArrayList<BinaryRowEx> rows = new ArrayList<BinaryRowEx>(recs.size());
        try {
            for (R rec : recs) {
                Row row = marsh.marshalKey(Objects.requireNonNull(rec));
                rows.add((BinaryRowEx)row);
            }
            return rows;
        }
        catch (MarshallerException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private R unmarshal(BinaryRow binaryRow) {
        if (binaryRow == null || !binaryRow.hasValue()) {
            return null;
        }
        Row row = this.schemaReg.resolve(binaryRow);
        RecordMarshaller<R> marshaller = this.marshaller(row.schemaVersion());
        try {
            return (R)marshaller.unmarshal(row);
        }
        catch (MarshallerException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    private Collection<R> unmarshal(Collection<BinaryRow> rows) {
        if (rows.isEmpty()) {
            return Collections.emptyList();
        }
        RecordMarshaller<R> marsh = this.marshaller(this.schemaReg.lastSchemaVersion());
        ArrayList<Object> recs = new ArrayList<Object>(rows.size());
        try {
            for (Row row : this.schemaReg.resolve(rows)) {
                recs.add(marsh.unmarshal(row));
            }
            return recs;
        }
        catch (MarshallerException e) {
            throw new IgniteException((Throwable)e);
        }
    }
}

