/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheGroupIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionFullMap;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDhtAffinityAssignmentResponse
extends GridCacheGroupIdMessage {
    private static final long serialVersionUID = 0L;
    private long futId;
    private AffinityTopologyVersion topVer;
    @GridDirectTransient
    private List<List<UUID>> affAssignmentIds;
    private byte[] affAssignmentIdsBytes;
    @GridDirectTransient
    private List<List<UUID>> idealAffAssignment;
    private byte[] idealAffAssignmentBytes;
    @GridDirectTransient
    private GridDhtPartitionFullMap partMap;
    private byte[] partBytes;
    @GridDirectTransient
    private IgniteCheckedException affAssignmentErr;
    private byte[] affAssignmentErrBytes;

    public GridDhtAffinityAssignmentResponse() {
    }

    public GridDhtAffinityAssignmentResponse(long futId, int grpId, @NotNull AffinityTopologyVersion topVer, List<List<ClusterNode>> affAssignment) {
        this.futId = futId;
        this.grpId = grpId;
        this.topVer = topVer;
        this.affAssignmentIds = this.ids(affAssignment);
    }

    public long futureId() {
        return this.futId;
    }

    @Override
    public boolean partitionExchangeMessage() {
        return true;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public List<List<ClusterNode>> affinityAssignment(DiscoCache discoCache) {
        if (this.affAssignmentIds != null) {
            return this.nodes(discoCache, this.affAssignmentIds);
        }
        return null;
    }

    public List<List<ClusterNode>> idealAffinityAssignment(DiscoCache discoCache) {
        return this.nodes(discoCache, this.idealAffAssignment);
    }

    private List<List<ClusterNode>> nodes(DiscoCache discoCache, List<List<UUID>> assignmentIds) {
        if (assignmentIds != null) {
            ArrayList<List<ClusterNode>> assignment = new ArrayList<List<ClusterNode>>(assignmentIds.size());
            for (int i = 0; i < assignmentIds.size(); ++i) {
                List<UUID> ids = assignmentIds.get(i);
                ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(ids.size());
                for (int j = 0; j < ids.size(); ++j) {
                    ClusterNode node = discoCache.node(ids.get(j));
                    assert (node != null);
                    nodes.add(node);
                }
                assignment.add(nodes);
            }
            return assignment;
        }
        return null;
    }

    public void idealAffinityAssignment(List<List<ClusterNode>> idealAffAssignment) {
        this.idealAffAssignment = this.ids(idealAffAssignment);
    }

    public void partitionMap(GridDhtPartitionFullMap partMap) {
        this.partMap = partMap;
    }

    @Nullable
    public GridDhtPartitionFullMap partitionMap() {
        return this.partMap;
    }

    private List<List<UUID>> ids(List<List<ClusterNode>> assignments) {
        if (assignments != null) {
            ArrayList<List<UUID>> assignment = new ArrayList<List<UUID>>(assignments.size());
            for (int i = 0; i < assignments.size(); ++i) {
                List<ClusterNode> nodes = assignments.get(i);
                ArrayList<UUID> ids = new ArrayList<UUID>(nodes.size());
                for (int j = 0; j < nodes.size(); ++j) {
                    ids.add(nodes.get(j).id());
                }
                assignment.add(ids);
            }
            return assignment;
        }
        return null;
    }

    @Override
    public short directType() {
        return 29;
    }

    @Override
    public byte fieldsCount() {
        return 10;
    }

    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        assert (this.affAssignmentIds != null);
        this.affAssignmentIdsBytes = U.marshal(ctx, this.affAssignmentIds);
        if (this.idealAffAssignment != null && this.idealAffAssignmentBytes == null) {
            this.idealAffAssignmentBytes = U.marshal(ctx, this.idealAffAssignment);
        }
        if (this.partMap != null && this.partBytes == null) {
            this.partBytes = U.zip(U.marshal(ctx.marshaller(), (Object)this.partMap));
        }
        if (this.affAssignmentErr != null && this.affAssignmentErrBytes == null) {
            this.affAssignmentErrBytes = U.marshal(ctx, (Object)this.affAssignmentErr);
        }
    }

    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        assert (this.affAssignmentIdsBytes != null);
        ldr = U.resolveClassLoader(ldr, ctx.gridConfig());
        this.affAssignmentIds = (List)U.unmarshal(ctx, this.affAssignmentIdsBytes, ldr);
        if (this.idealAffAssignmentBytes != null && this.idealAffAssignment == null) {
            this.idealAffAssignment = (List)U.unmarshal(ctx, this.idealAffAssignmentBytes, ldr);
        }
        if (this.partBytes != null && this.partMap == null) {
            this.partMap = (GridDhtPartitionFullMap)U.unmarshalZip(ctx.marshaller(), this.partBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.affAssignmentErrBytes != null && this.affAssignmentErr == null) {
            this.affAssignmentErr = (IgniteCheckedException)U.unmarshal(ctx, this.affAssignmentErrBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
    }

    public void affinityAssignmentsError(IgniteCheckedException err) {
        this.affAssignmentErr = err;
    }

    public IgniteCheckedException affinityAssignmentsError() {
        return this.affAssignmentErr;
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 4: {
                if (!writer.writeByteArray("affAssignmentErrBytes", this.affAssignmentErrBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeByteArray("affAssignmentIdsBytes", this.affAssignmentIdsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeLong("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeByteArray("idealAffAssignmentBytes", this.idealAffAssignmentBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeByteArray("partBytes", this.partBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 4: {
                this.affAssignmentErrBytes = reader.readByteArray("affAssignmentErrBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.affAssignmentIdsBytes = reader.readByteArray("affAssignmentIdsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.futId = reader.readLong("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.idealAffAssignmentBytes = reader.readByteArray("idealAffAssignmentBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.partBytes = reader.readByteArray("partBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtAffinityAssignmentResponse.class);
    }

    @Override
    public String toString() {
        return S.toString(GridDhtAffinityAssignmentResponse.class, this);
    }
}

