/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework.impl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.yardstickframework.impl.util.BenchmarkClosure;

public class BenchmarkProcessLauncher {
    private Process proc;
    private StreamGrabber inGrabber;
    private StreamGrabber errGrabber;

    public void exec(Collection<String> cmdParams, Map<String, String> envVars, @Nullable BenchmarkClosure<String> printC) throws Exception {
        ArrayList<String> procCommands = new ArrayList<String>();
        procCommands.addAll(cmdParams);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        for (Map.Entry<String, String> entry : envVars.entrySet()) {
            builder.environment().put(entry.getKey(), entry.getValue());
        }
        builder.command(procCommands);
        this.proc = builder.start();
        this.inGrabber = new StreamGrabber(this.proc.getInputStream(), printC);
        this.errGrabber = new StreamGrabber(this.proc.getErrorStream(), printC);
        this.inGrabber.start();
        this.errGrabber.start();
    }

    public Process process() {
        return this.proc;
    }

    public void shutdown(boolean wait) throws Exception {
        if (this.proc != null) {
            if (wait) {
                this.proc.waitFor();
            } else {
                this.proc.destroy();
            }
            this.inGrabber.stop();
            this.errGrabber.stop();
        }
    }

    private static class StreamGrabber {
        private static final BenchmarkClosure<String> LOG_CLOSURE = new BenchmarkClosure<String>(){

            @Override
            public void apply(String s) {
                System.out.println(s);
            }
        };
        private final Thread thread;
        private final InputStream is;

        StreamGrabber(final InputStream is, final @Nullable BenchmarkClosure<String> printC) {
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String line;
                        BufferedReader br = new BufferedReader(new InputStreamReader(is));
                        while ((line = br.readLine()) != null && !StreamGrabber.this.thread.isInterrupted()) {
                            (printC == null ? LOG_CLOSURE : printC).apply(line);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            this.is = is;
        }

        public void start() {
            this.thread.start();
        }

        public void stop() throws Exception {
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.thread.interrupt();
            this.thread.join();
        }
    }
}

