/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.keys;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.DateValueUtils;
import org.apache.ignite.internal.cache.query.index.sorted.keys.DateTimeIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;

public class TimestampIndexKey
extends DateTimeIndexKey {
    private final long dateVal;
    private final long nanos;

    public TimestampIndexKey(Object obj) {
        if (obj instanceof Date) {
            long millis = DateValueUtils.utcMillisFromDefaultTz(((Date)obj).getTime());
            this.dateVal = DateValueUtils.dateValueFromMillis(millis);
            if ((millis %= 86400000L) < 0L) {
                millis += 86400000L;
            }
            this.nanos = obj instanceof Timestamp ? TimeUnit.MILLISECONDS.toNanos(millis) + (long)((Timestamp)obj).getNanos() % 1000000L : TimeUnit.MILLISECONDS.toNanos(millis);
        } else if (obj instanceof LocalDateTime) {
            LocalDateTime locDateTime = (LocalDateTime)obj;
            LocalDate locDate = locDateTime.toLocalDate();
            LocalTime locTime = locDateTime.toLocalTime();
            this.dateVal = DateValueUtils.dateValue(locDate.getYear(), locDate.getMonthValue(), locDate.getDayOfMonth());
            this.nanos = locTime.toNanoOfDay();
        } else {
            throw new IgniteException("Failed to convert object to timestamp value, unexpected class " + obj.getClass().getName());
        }
    }

    public TimestampIndexKey(long dateVal, long nanos) {
        this.dateVal = dateVal;
        this.nanos = nanos;
    }

    @Override
    public Object key() {
        long millis = DateValueUtils.millisFromDateValue(this.dateVal) + TimeUnit.NANOSECONDS.toMillis(this.nanos);
        millis = DateValueUtils.defaultTzMillisFromUtc(millis);
        return new Timestamp(millis);
    }

    public long dateValue() {
        return this.dateVal;
    }

    public long nanos() {
        return this.nanos;
    }

    @Override
    public IndexKeyType type() {
        return IndexKeyType.TIMESTAMP;
    }

    @Override
    public int compareTo(long dateVal, long nanos) {
        return this.dateVal != dateVal ? Long.compare(this.dateVal, dateVal) : Long.compare(this.nanos, nanos);
    }

    @Override
    public int compare(IndexKey o) {
        return -((DateTimeIndexKey)o).compareTo(this.dateVal, this.nanos);
    }

    public String toString() {
        return this.dateVal + " " + this.nanos;
    }
}

