/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fieldsplitter;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.fieldsplitter.FieldSplitterMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FieldSplitterDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = FieldSplitterMeta.class;
    private CCombo wSplitField;
    private TextVar wDelimiter;
    private TextVar wEnclosure;
    private TextVar wEscapeString;
    private TableView wFields;
    private final FieldSplitterMeta input;
    private boolean gotPreviousFields = false;

    public FieldSplitterDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (FieldSplitterMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlSplitfield = new Label((Composite)this.shell, 131072);
        wlSplitfield.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.SplitField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSplitfield);
        FormData fdlSplitfield = new FormData();
        fdlSplitfield.left = new FormAttachment(0, 0);
        fdlSplitfield.right = new FormAttachment(middle, -margin);
        fdlSplitfield.top = new FormAttachment((Control)this.wTransformName, margin);
        wlSplitfield.setLayoutData((Object)fdlSplitfield);
        this.wSplitField = new CCombo((Composite)this.shell, 2056);
        this.wSplitField.setText("");
        this.props.setLook((Control)this.wSplitField);
        this.wSplitField.addModifyListener(lsMod);
        FormData fdSplitfield = new FormData();
        fdSplitfield.left = new FormAttachment(middle, 0);
        fdSplitfield.top = new FormAttachment((Control)this.wTransformName, margin);
        fdSplitfield.right = new FormAttachment(100, 0);
        this.wSplitField.setLayoutData((Object)fdSplitfield);
        this.wSplitField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)FieldSplitterDialog.this.shell.getDisplay(), 1);
                FieldSplitterDialog.this.shell.setCursor(busy);
                FieldSplitterDialog.this.getFields();
                FieldSplitterDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlDelimiter = new Label((Composite)this.shell, 131072);
        wlDelimiter.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Delimiter.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDelimiter);
        FormData fdlDelimiter = new FormData();
        fdlDelimiter.left = new FormAttachment(0, 0);
        fdlDelimiter.right = new FormAttachment(middle, -margin);
        fdlDelimiter.top = new FormAttachment((Control)this.wSplitField, margin);
        wlDelimiter.setLayoutData((Object)fdlDelimiter);
        this.wDelimiter = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wDelimiter.setToolTipText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Delimiter.Tooltip", (String[])new String[0]));
        this.wDelimiter.setText("");
        this.props.setLook((Control)this.wDelimiter);
        this.wDelimiter.addModifyListener(lsMod);
        FormData fdDelimiter = new FormData();
        fdDelimiter.left = new FormAttachment(middle, 0);
        fdDelimiter.top = new FormAttachment((Control)this.wSplitField, margin);
        fdDelimiter.right = new FormAttachment(100, 0);
        this.wDelimiter.setLayoutData((Object)fdDelimiter);
        Label wlEnclosure = new Label((Composite)this.shell, 131072);
        wlEnclosure.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Enclosure.Label", (String[])new String[0]));
        this.props.setLook((Control)wlEnclosure);
        FormData fdlEnclosure = new FormData();
        fdlEnclosure.top = new FormAttachment((Control)this.wDelimiter, margin);
        fdlEnclosure.left = new FormAttachment(0, 0);
        fdlEnclosure.right = new FormAttachment(middle, -margin);
        wlEnclosure.setLayoutData((Object)fdlEnclosure);
        this.wEnclosure = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wEnclosure.setToolTipText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Enclosure.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wEnclosure);
        this.wEnclosure.addModifyListener(lsMod);
        FormData fdEnclosure = new FormData();
        fdEnclosure.top = new FormAttachment((Control)this.wDelimiter, margin);
        fdEnclosure.left = new FormAttachment(middle, 0);
        fdEnclosure.right = new FormAttachment(100, 0);
        this.wEnclosure.setLayoutData((Object)fdEnclosure);
        Label wlEscapeString = new Label((Composite)this.shell, 131072);
        wlEscapeString.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.EscapeString.Label", (String[])new String[0]));
        this.props.setLook((Control)wlEscapeString);
        FormData fdlEscapeString = new FormData();
        fdlEscapeString.top = new FormAttachment((Control)this.wEnclosure, margin);
        fdlEscapeString.left = new FormAttachment(0, 0);
        fdlEscapeString.right = new FormAttachment(middle, -margin);
        wlEscapeString.setLayoutData((Object)fdlEscapeString);
        this.wEscapeString = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wEscapeString.setToolTipText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.EscapeString.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wEscapeString);
        this.wEscapeString.addModifyListener(lsMod);
        FormData fdEscapeString = new FormData();
        fdEscapeString.top = new FormAttachment((Control)this.wEnclosure, margin);
        fdEscapeString.left = new FormAttachment(middle, 0);
        fdEscapeString.right = new FormAttachment(100, 0);
        this.wEscapeString.setLayoutData((Object)fdEscapeString);
        Label wlFields = new Label((Composite)this.shell, 131072);
        wlFields.setText(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wEscapeString, margin);
        wlFields.setLayoutData((Object)fdlFields);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        int fieldsRows = this.input.getFieldName().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.NewField", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.ID", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.RemoveID", (String[])new String[0]), 2, new String[]{"Y", "N"}), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Format", (String[])new String[0]), 5, 4), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Group", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Decimal", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Currency", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.Nullif", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.IfNull", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldSplitterDialog.ColumnInfo.TrimType", (String[])new String[0]), 2, ValueMetaString.trimTypeDesc, true)};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, fieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void getFields() {
        if (!this.gotPreviousFields) {
            try {
                String field = this.wSplitField.getText();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wSplitField.setItems(r.getFieldNames());
                }
                if (field != null) {
                    this.wSplitField.setText(field);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FieldSplitterDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FieldSplitterDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPreviousFields = true;
        }
    }

    public void getData() {
        this.wSplitField.setText(Const.NVL((String)this.input.getSplitField(), (String)""));
        this.wDelimiter.setText(Const.NVL((String)this.input.getDelimiter(), (String)""));
        this.wEnclosure.setText(Const.NVL((String)this.input.getEnclosure(), (String)""));
        this.wEscapeString.setText(Const.NVL((String)this.input.getEscapeString(), (String)""));
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            TableItem ti = this.wFields.table.getItem(i);
            if (this.input.getFieldName()[i] != null) {
                ti.setText(1, this.input.getFieldName()[i]);
            }
            if (this.input.getFieldID()[i] != null) {
                ti.setText(2, this.input.getFieldID()[i]);
            }
            ti.setText(3, this.input.getFieldRemoveID()[i] ? "Y" : "N");
            ti.setText(4, ValueMetaFactory.getValueMetaName((int)this.input.getFieldType()[i]));
            if (this.input.getFieldLength()[i] >= 0) {
                ti.setText(5, "" + this.input.getFieldLength()[i]);
            }
            if (this.input.getFieldPrecision()[i] >= 0) {
                ti.setText(6, "" + this.input.getFieldPrecision()[i]);
            }
            if (this.input.getFieldFormat()[i] != null) {
                ti.setText(7, this.input.getFieldFormat()[i]);
            }
            if (this.input.getFieldGroup()[i] != null) {
                ti.setText(8, this.input.getFieldGroup()[i]);
            }
            if (this.input.getFieldDecimal()[i] != null) {
                ti.setText(9, this.input.getFieldDecimal()[i]);
            }
            if (this.input.getFieldCurrency()[i] != null) {
                ti.setText(10, this.input.getFieldCurrency()[i]);
            }
            if (this.input.getFieldNullIf()[i] != null) {
                ti.setText(11, this.input.getFieldNullIf()[i]);
            }
            if (this.input.getFieldIfNull()[i] != null) {
                ti.setText(12, this.input.getFieldIfNull()[i]);
            }
            ti.setText(13, ValueMetaString.getTrimTypeDesc((int)this.input.getFieldTrimType()[i]));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setSplitField(this.wSplitField.getText());
        this.input.setDelimiter(this.wDelimiter.getText());
        this.input.setEnclosure(this.wEnclosure.getText());
        this.input.setEscapeString(this.wEscapeString.getText());
        int nrFields = this.wFields.nrNonEmpty();
        this.input.allocate(nrFields);
        if (this.input.getFieldName().length <= 0) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FieldSplitterDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FieldSplitter.Log.SplitMetaNameNotValid", (String[])new String[0]), null);
            return;
        }
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            TableItem ti = this.wFields.getNonEmpty(i);
            this.input.getFieldName()[i] = ti.getText(1);
            this.input.getFieldID()[i] = ti.getText(2);
            this.input.getFieldRemoveID()[i] = "Y".equalsIgnoreCase(ti.getText(3));
            this.input.getFieldType()[i] = ValueMetaFactory.getIdForValueMeta((String)ti.getText(4));
            this.input.getFieldLength()[i] = Const.toInt((String)ti.getText(5), (int)-1);
            this.input.getFieldPrecision()[i] = Const.toInt((String)ti.getText(6), (int)-1);
            this.input.getFieldFormat()[i] = ti.getText(7);
            this.input.getFieldGroup()[i] = ti.getText(8);
            this.input.getFieldDecimal()[i] = ti.getText(9);
            this.input.getFieldCurrency()[i] = ti.getText(10);
            this.input.getFieldNullIf()[i] = ti.getText(11);
            this.input.getFieldIfNull()[i] = ti.getText(12);
            this.input.getFieldTrimType()[i] = ValueMetaString.getTrimTypeByDesc((String)ti.getText(13));
        }
        this.dispose();
    }
}

