/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.jdbc.SqlExceptionUtils;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public final class FakeTransaction {
    static final String ACTION_COMMITTED = "committed";
    static final String ACTION_ROLLBACK = "rolled back";
    static final String ERROR_TX_NOT_STARTED = "Transaction not started";
    static final int DEFAULT_TX_ISOLATION_LEVEL = 1;
    final String id = UUID.randomUUID().toString();
    private final List<String> queries = new LinkedList<String>();
    private final List<FakeSavepoint> savepoints = new ArrayList<FakeSavepoint>();

    FakeTransaction() {
    }

    synchronized List<String> getQueries() {
        return new ArrayList<String>(this.queries);
    }

    synchronized List<FakeSavepoint> getSavepoints() {
        return new ArrayList<FakeSavepoint>(this.savepoints);
    }

    synchronized void logSavepointDetails(Logger log, FakeSavepoint s, String action) {
        log.warn((Object)"[JDBC Compliant Mode] Savepoint(id=%d, name=%s) of transaction [%s](%d queries & %d savepoints) is %s.", s.id, s.name, this.id, this.queries.size(), this.savepoints.size(), action);
    }

    synchronized void logTransactionDetails(Logger log, String action) {
        log.warn((Object)"[JDBC Compliant Mode] Transaction [%s](%d queries & %d savepoints) is %s.", this.id, this.queries.size(), this.savepoints.size(), action);
        log.debug(() -> {
            log.debug((Object)"[JDBC Compliant Mode] Transaction [%s] is %s - begin", this.id, action);
            int total = this.queries.size();
            int counter = 1;
            for (String queryId : this.queries) {
                log.debug((Object)"    '%s', -- query (%d of %d) in transaction [%s]", queryId, counter++, total, this.id);
            }
            total = this.savepoints.size();
            counter = 1;
            for (FakeSavepoint savepoint : this.savepoints) {
                log.debug((Object)"    %s (%d of %d) in transaction [%s]", savepoint, counter++, total, this.id);
            }
            return ClickHouseUtils.format("[JDBC Compliant Mode] Transaction [%s] is %s - end", this.id, action);
        });
    }

    synchronized String newQuery(String queryId) {
        if (queryId == null || this.queries.contains(queryId)) {
            queryId = UUID.randomUUID().toString();
        }
        this.queries.add(queryId);
        return queryId;
    }

    synchronized FakeSavepoint newSavepoint(String name) {
        FakeSavepoint savepoint = new FakeSavepoint(this.queries.size(), name);
        this.savepoints.add(savepoint);
        return savepoint;
    }

    synchronized void toSavepoint(FakeSavepoint savepoint) throws SQLException {
        boolean found = false;
        Iterator<FakeSavepoint> it = this.savepoints.iterator();
        while (it.hasNext()) {
            FakeSavepoint s = it.next();
            if (found) {
                it.remove();
                continue;
            }
            if (s != savepoint) continue;
            found = true;
            it.remove();
        }
        if (!found) {
            throw SqlExceptionUtils.clientError("Invalid savepoint: " + savepoint);
        }
        this.queries.subList(savepoint.id, this.queries.size()).clear();
    }

    synchronized void clear() {
        this.queries.clear();
        this.savepoints.clear();
    }

    static final class FakeSavepoint
    implements Savepoint {
        final int id;
        final String name;

        FakeSavepoint(int id, String name) {
            this.id = id;
            this.name = name;
        }

        @Override
        public int getSavepointId() throws SQLException {
            if (this.name != null) {
                throw SqlExceptionUtils.clientError("Cannot get ID from a named savepoint, please use getSavepointName() instead");
            }
            return this.id;
        }

        @Override
        public String getSavepointName() throws SQLException {
            if (this.name == null) {
                throw SqlExceptionUtils.clientError("Cannot get name from an un-named savepoint, please use getSavepointId() instead");
            }
            return this.name;
        }

        public String toString() {
            return "FakeSavepoint [id=" + this.id + ", name=" + this.name + ']';
        }
    }
}

