/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.config;

import com.google.api.client.util.SecurityUtils;
import com.google.api.core.InternalApi;
import com.google.auth.Credentials;
import com.google.auth.RequestMetadataCallback;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auth.oauth2.ServiceAccountJwtAccessCredentials;
import com.google.cloud.bigtable.config.CredentialOptions;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.http.HttpTransportOptions;
import com.google.common.collect.ImmutableList;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

@InternalApi(value="For internal usage only")
public class CredentialFactory {
    public static final String CLOUD_BIGTABLE_ADMIN_SCOPE = "https://www.googleapis.com/auth/cloud-bigtable.admin";
    public static final String CLOUD_BIGTABLE_READER_SCOPE = "https://www.googleapis.com/auth/cloud-bigtable.data.readonly";
    public static final String CLOUD_BIGTABLE_WRITER_SCOPE = "https://www.googleapis.com/auth/cloud-bigtable.data";
    public static final List<String> CLOUD_BIGTABLE_READ_WRITE_SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/cloud-bigtable.data.readonly", (Object)"https://www.googleapis.com/auth/cloud-bigtable.data");
    public static final List<String> CLOUD_BIGTABLE_ALL_SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/cloud-bigtable.data.readonly", (Object)"https://www.googleapis.com/auth/cloud-bigtable.data", (Object)"https://www.googleapis.com/auth/cloud-bigtable.admin");
    private static HttpTransportFactory httpTransportFactory;
    private static final Logger LOG;

    public static void setHttpTransportFactory(HttpTransportFactory httpTransportFactory) {
        CredentialFactory.httpTransportFactory = httpTransportFactory;
    }

    public static HttpTransportFactory getHttpTransportFactory() {
        if (httpTransportFactory == null) {
            httpTransportFactory = new HttpTransportOptions.DefaultHttpTransportFactory();
        }
        return httpTransportFactory;
    }

    public static Credentials getCredentials(CredentialOptions options) throws IOException, GeneralSecurityException {
        return CredentialFactory.patchCredentials(CredentialFactory.getCredentialsInner(options));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Credentials getCredentialsInner(CredentialOptions options) throws IOException, GeneralSecurityException {
        switch (options.getCredentialType()) {
            case DefaultCredentials: {
                return CredentialFactory.getApplicationDefaultCredential();
            }
            case P12: {
                CredentialOptions.P12CredentialOptions p12Options = (CredentialOptions.P12CredentialOptions)options;
                return CredentialFactory.getCredentialFromPrivateKeyServiceAccount(p12Options.getServiceAccount(), p12Options.getKeyFile());
            }
            case SuppliedCredentials: {
                return ((CredentialOptions.UserSuppliedCredentialOptions)options).getCredential();
            }
            case SuppliedJson: {
                CredentialOptions.JsonCredentialsOptions jsonCredentialsOptions;
                CredentialOptions.JsonCredentialsOptions jsonCredentialsOptions2 = jsonCredentialsOptions = (CredentialOptions.JsonCredentialsOptions)options;
                synchronized (jsonCredentialsOptions2) {
                    if (jsonCredentialsOptions.getCachedCredentials() == null) {
                        jsonCredentialsOptions.setCachedCredentails(CredentialFactory.getInputStreamCredential(jsonCredentialsOptions.getInputStream()));
                    }
                    return jsonCredentialsOptions.getCachedCredentials();
                }
            }
            case None: {
                return null;
            }
        }
        throw new IllegalStateException("Cannot process Credential type: " + (Object)((Object)options.getCredentialType()));
    }

    public static Credentials getCredentialFromPrivateKeyServiceAccount(String serviceAccountEmail, String privateKeyFile) throws IOException, GeneralSecurityException {
        PrivateKey privateKey = SecurityUtils.loadPrivateKeyFromKeyStore((KeyStore)SecurityUtils.getPkcs12KeyStore(), (InputStream)new FileInputStream(privateKeyFile), (String)"notasecret", (String)"privatekey", (String)"notasecret");
        return CredentialFactory.patchCredentials((Credentials)ServiceAccountJwtAccessCredentials.newBuilder().setClientEmail(serviceAccountEmail).setPrivateKey(privateKey).build());
    }

    public static Credentials getCredentialFromPrivateKeyServiceAccount(String serviceAccountEmail, String privateKeyFile, List<String> scopes) throws IOException, GeneralSecurityException {
        PrivateKey privateKey = SecurityUtils.loadPrivateKeyFromKeyStore((KeyStore)SecurityUtils.getPkcs12KeyStore(), (InputStream)new FileInputStream(privateKeyFile), (String)"notasecret", (String)"privatekey", (String)"notasecret");
        return CredentialFactory.patchCredentials((Credentials)ServiceAccountCredentials.newBuilder().setClientEmail(serviceAccountEmail).setPrivateKey(privateKey).setScopes(scopes).setHttpTransportFactory(CredentialFactory.getHttpTransportFactory()).build());
    }

    public static Credentials getApplicationDefaultCredential() throws IOException {
        GoogleCredentials credentials = GoogleCredentials.getApplicationDefault((HttpTransportFactory)CredentialFactory.getHttpTransportFactory());
        if (credentials instanceof ServiceAccountCredentials) {
            return CredentialFactory.getJwtToken((ServiceAccountCredentials)credentials);
        }
        return credentials.createScoped(CLOUD_BIGTABLE_ALL_SCOPES);
    }

    public static Credentials getInputStreamCredential(InputStream inputStream) throws IOException {
        GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)inputStream, (HttpTransportFactory)CredentialFactory.getHttpTransportFactory());
        if (credentials instanceof ServiceAccountCredentials) {
            return CredentialFactory.getJwtToken((ServiceAccountCredentials)credentials);
        }
        return credentials.createScoped(CLOUD_BIGTABLE_ALL_SCOPES);
    }

    private static Credentials getJwtToken(ServiceAccountCredentials serviceAccount) {
        return CredentialFactory.patchCredentials((Credentials)ServiceAccountJwtAccessCredentials.newBuilder().setClientEmail(serviceAccount.getClientEmail()).setClientId(serviceAccount.getClientId()).setPrivateKey(serviceAccount.getPrivateKey()).setPrivateKeyId(serviceAccount.getPrivateKeyId()).build());
    }

    private static Credentials patchCredentials(Credentials credentials) {
        ServiceAccountCredentials svcCreds;
        if (credentials instanceof ServiceAccountJwtAccessCredentials) {
            credentials = new JwtAudienceWorkaroundCredentials((ServiceAccountJwtAccessCredentials)credentials);
        }
        if (credentials instanceof ServiceAccountCredentials && (svcCreds = (ServiceAccountCredentials)credentials).getScopes().isEmpty()) {
            credentials = svcCreds.createScoped(CLOUD_BIGTABLE_ALL_SCOPES);
        }
        return credentials;
    }

    static {
        LOG = new Logger(CredentialFactory.class);
    }

    private static class JwtAudienceWorkaroundCredentials
    extends Credentials {
        private final ServiceAccountJwtAccessCredentials inner;

        public JwtAudienceWorkaroundCredentials(ServiceAccountJwtAccessCredentials inner) {
            this.inner = inner;
        }

        public String getAuthenticationType() {
            return this.inner.getAuthenticationType();
        }

        public void getRequestMetadata(URI uri, Executor executor, RequestMetadataCallback callback) {
            this.blockingGetToCallback(uri, callback);
        }

        public Map<String, List<String>> getRequestMetadata(URI uri) throws IOException {
            if ("batch-bigtable.googleapis.com".equals(uri.getHost())) {
                try {
                    uri = new URI(uri.getScheme(), "bigtable.googleapis.com", uri.getPath(), uri.getFragment());
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException("Failed to adapt batch endpoint creds uri");
                }
            }
            return this.inner.getRequestMetadata(uri);
        }

        public boolean hasRequestMetadata() {
            return this.inner.hasRequestMetadata();
        }

        public boolean hasRequestMetadataOnly() {
            return this.inner.hasRequestMetadataOnly();
        }

        public void refresh() {
            this.inner.refresh();
        }
    }
}

