/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.messaging.Message;

public class RouteMessage
implements Message {
    public static final byte SIGNATURE = 102;
    private final Map<String, Value> routingContext;
    private final Bookmark bookmark;
    private final String databaseName;

    public RouteMessage(Map<String, Value> routingContext, Bookmark bookmark, String databaseName) {
        this.routingContext = Collections.unmodifiableMap(routingContext);
        this.bookmark = bookmark;
        this.databaseName = databaseName;
    }

    public Map<String, Value> getRoutingContext() {
        return this.routingContext;
    }

    public Optional<Bookmark> getBookmark() {
        return Optional.ofNullable(this.bookmark);
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public byte signature() {
        return 102;
    }

    public String toString() {
        return String.format("ROUTE %s %s %s", this.routingContext, this.bookmark, this.databaseName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteMessage that = (RouteMessage)o;
        return this.routingContext.equals(that.routingContext) && Objects.equals(this.databaseName, that.databaseName);
    }

    public int hashCode() {
        return Objects.hash(this.routingContext, this.databaseName);
    }
}

