/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import com.google.common.util.concurrent.RateLimiter;
import java.io.File;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.hints.EncodedHintMessage;
import org.apache.cassandra.hints.Hint;
import org.apache.cassandra.hints.HintMessage;
import org.apache.cassandra.hints.HintsReader;
import org.apache.cassandra.hints.InputPosition;
import org.apache.cassandra.metrics.HintsServiceMetrics;
import org.apache.cassandra.net.IAsyncCallbackWithFailure;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.concurrent.SimpleCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HintsDispatcher
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(HintsDispatcher.class);
    private final HintsReader reader;
    private final UUID hostId;
    private final InetAddress address;
    private final int messagingVersion;
    private final BooleanSupplier abortRequested;
    private InputPosition currentPagePosition = null;

    private HintsDispatcher(HintsReader reader, UUID hostId, InetAddress address, int messagingVersion, BooleanSupplier abortRequested) {
        this.reader = reader;
        this.hostId = hostId;
        this.address = address;
        this.messagingVersion = messagingVersion;
        this.abortRequested = abortRequested;
    }

    static HintsDispatcher create(File file, RateLimiter rateLimiter, InetAddress address, UUID hostId, BooleanSupplier abortRequested) {
        int messagingVersion = MessagingService.instance().getVersion(address);
        return new HintsDispatcher(HintsReader.open(file, rateLimiter), hostId, address, messagingVersion, abortRequested);
    }

    @Override
    public void close() {
        this.reader.close();
    }

    void seek(InputPosition position) {
        this.reader.seek(position);
    }

    boolean dispatch() {
        for (HintsReader.Page page : this.reader) {
            this.currentPagePosition = page.position;
            if (this.dispatch(page) == Action.CONTINUE) continue;
            return false;
        }
        return true;
    }

    InputPosition dispatchPosition() {
        return this.currentPagePosition;
    }

    private Action dispatch(HintsReader.Page page) {
        return this.sendHintsAndAwait(page);
    }

    private Action sendHintsAndAwait(HintsReader.Page page) {
        Action action;
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        Action action2 = action = this.reader.descriptor().messagingVersion() == this.messagingVersion ? this.sendHints(page.buffersIterator(), callbacks, this::sendEncodedHint) : this.sendHints(page.hintsIterator(), callbacks, this::sendHint);
        if (action == Action.ABORT) {
            return action;
        }
        boolean hadFailures = false;
        for (Callback cb : callbacks) {
            Callback.Outcome outcome = cb.await();
            this.updateMetrics(outcome);
            if (outcome == Callback.Outcome.SUCCESS) continue;
            hadFailures = true;
        }
        return hadFailures ? Action.ABORT : Action.CONTINUE;
    }

    private void updateMetrics(Callback.Outcome outcome) {
        switch (outcome) {
            case SUCCESS: {
                HintsServiceMetrics.hintsSucceeded.mark();
                break;
            }
            case FAILURE: {
                HintsServiceMetrics.hintsFailed.mark();
                break;
            }
            case TIMEOUT: {
                HintsServiceMetrics.hintsTimedOut.mark();
            }
        }
    }

    private <T> Action sendHints(Iterator<T> hints, Collection<Callback> callbacks, Function<T, Callback> sendFunction) {
        while (hints.hasNext()) {
            if (this.abortRequested.getAsBoolean()) {
                return Action.ABORT;
            }
            callbacks.add(sendFunction.apply(hints.next()));
        }
        return Action.CONTINUE;
    }

    private Callback sendHint(Hint hint) {
        Callback callback = new Callback();
        HintMessage message = new HintMessage(this.hostId, hint);
        MessagingService.instance().sendRRWithFailure(message.createMessageOut(), this.address, callback);
        return callback;
    }

    private Callback sendEncodedHint(ByteBuffer hint) {
        Callback callback = new Callback();
        EncodedHintMessage message = new EncodedHintMessage(this.hostId, hint, this.messagingVersion);
        MessagingService.instance().sendRRWithFailure(message.createMessageOut(), this.address, callback);
        return callback;
    }

    private static final class Callback
    implements IAsyncCallbackWithFailure {
        private final long start = System.nanoTime();
        private final SimpleCondition condition = new SimpleCondition();
        private volatile Outcome outcome;

        private Callback() {
        }

        Outcome await() {
            boolean timedOut;
            long timeout = TimeUnit.MILLISECONDS.toNanos(MessagingService.Verb.HINT.getTimeout()) - (System.nanoTime() - this.start);
            try {
                timedOut = !this.condition.await(timeout, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("Hint dispatch was interrupted", (Throwable)e);
                return Outcome.INTERRUPTED;
            }
            return timedOut ? Outcome.TIMEOUT : this.outcome;
        }

        @Override
        public void onFailure(InetAddress from, RequestFailureReason failureReason) {
            this.outcome = Outcome.FAILURE;
            this.condition.signalAll();
        }

        @Override
        public void response(MessageIn msg) {
            this.outcome = Outcome.SUCCESS;
            this.condition.signalAll();
        }

        @Override
        public boolean isLatencyForSnitch() {
            return false;
        }

        @Override
        public boolean supportsBackPressure() {
            return true;
        }

        static enum Outcome {
            SUCCESS,
            TIMEOUT,
            FAILURE,
            INTERRUPTED;

        }
    }

    private static enum Action {
        CONTINUE,
        ABORT;

    }
}

