/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.cassandra.datastax;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.databases.cassandra.datastax.DriverConnection;
import org.apache.hop.databases.cassandra.datastax.DriverCqlRowHandler;
import org.apache.hop.databases.cassandra.datastax.TableMetaData;
import org.apache.hop.databases.cassandra.spi.Connection;
import org.apache.hop.databases.cassandra.spi.CqlRowHandler;
import org.apache.hop.databases.cassandra.spi.ITableMetaData;
import org.apache.hop.databases.cassandra.spi.Keyspace;
import org.apache.hop.databases.cassandra.util.CassandraUtils;

public class DriverKeyspace
implements Keyspace {
    protected DriverConnection conn;
    private KeyspaceMetadata meta;
    private String name;

    public DriverKeyspace(DriverConnection conn, KeyspaceMetadata keyspace) {
        this.meta = keyspace;
        this.conn = conn;
        this.name = keyspace.getName();
    }

    @Override
    public void setConnection(Connection conn) throws Exception {
        this.conn = (DriverConnection)conn;
    }

    @Override
    public DriverConnection getConnection() {
        return this.conn;
    }

    @Override
    public void setKeyspace(String keyspaceName) throws Exception {
        this.name = keyspaceName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setOptions(Map<String, String> options) {
        this.conn.setAdditionalOptions(options);
    }

    @Override
    public void executeCQL(String cql, String compresson, String consistencyLevel, ILogChannel log) throws Exception {
        this.conn.getSession(this.name).execute(cql);
    }

    @Override
    public void createKeyspace(String keyspaceName, Map<String, Object> options, ILogChannel log) throws Exception {
        SchemaBuilder.createKeyspace((String)keyspaceName);
    }

    @Override
    public List<String> getTableNamesCQL3() throws Exception {
        return this.meta.getTables().stream().map(tab -> tab.getName()).collect(Collectors.toList());
    }

    @Override
    public boolean tableExists(String tableName) throws Exception {
        return this.meta.getTable(tableName) != null;
    }

    @Override
    public ITableMetaData getTableMetaData(String familyName) throws Exception {
        TableMetadata tableMeta = this.meta.getTable(familyName);
        return new TableMetaData(this, tableMeta);
    }

    @Override
    public boolean createTable(String tableName, IRowMeta rowMeta, List<Integer> keyIndexes, String createTableWithClause, ILogChannel log) throws Exception {
        Create createTable = SchemaBuilder.createTable((String)tableName);
        for (int i = 0; i < rowMeta.size(); ++i) {
            if (!keyIndexes.contains(i)) {
                IValueMeta valueMeta = rowMeta.getValueMeta(i);
                createTable.addColumn(valueMeta.getName(), CassandraUtils.getCassandraDataTypeFromValueMeta(valueMeta));
                continue;
            }
            IValueMeta key = rowMeta.getValueMeta(i);
            createTable.addPartitionKey(key.getName(), CassandraUtils.getCassandraDataTypeFromValueMeta(key));
        }
        if (!Utils.isEmpty((CharSequence)createTableWithClause)) {
            StringBuilder cql = new StringBuilder(createTable.toString());
            if (!createTableWithClause.toLowerCase().trim().startsWith("with")) {
                cql.append(" WITH ");
            }
            cql.append(createTableWithClause);
            this.getSession().execute(cql.toString());
        } else {
            this.getSession().execute((Statement)createTable);
        }
        return true;
    }

    @Override
    public void updateTableCQL3(String tableName, IRowMeta rowMeta, List<Integer> keyIndexes, ILogChannel log) throws Exception {
        Session session = this.getSession();
        ITableMetaData table = this.getTableMetaData(tableName);
        for (IValueMeta valueMeta : rowMeta.getValueMetaList()) {
            if (table.columnExistsInSchema(valueMeta.getName())) continue;
            session.execute((Statement)SchemaBuilder.alterTable((String)tableName).alterColumn(valueMeta.getName()).type(CassandraUtils.getCassandraDataTypeFromValueMeta(valueMeta)));
        }
    }

    @Override
    public void truncateTable(String tableName, ILogChannel log) throws Exception {
        this.getSession().execute((Statement)QueryBuilder.truncate((String)tableName));
    }

    protected Session getSession() {
        return this.conn.getSession(this.name);
    }

    @Override
    public CqlRowHandler getCQLRowHandler() {
        return new DriverCqlRowHandler(this, this.getSession(), this.getConnection().isExpandCollection());
    }
}

