/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.data;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.ByteStringOutputStream;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class BeamFnDataOutboundAggregator {
    public static final String DATA_BUFFER_SIZE_LIMIT = "data_buffer_size_limit=";
    public static final int DEFAULT_BUFFER_LIMIT_BYTES = 1000000;
    public static final String DATA_BUFFER_TIME_LIMIT_MS = "data_buffer_time_limit_ms=";
    public static final long DEFAULT_BUFFER_LIMIT_TIME_MS = -1L;
    private static final Logger LOG = LoggerFactory.getLogger(BeamFnDataOutboundAggregator.class);
    private final int sizeLimit;
    private final long timeLimit;
    private final Supplier<String> processBundleRequestIdSupplier;
    @VisibleForTesting
    final Map<String, Receiver<?>> outputDataReceivers;
    @VisibleForTesting
    final Map<TimerEndpoint, Receiver<?>> outputTimersReceivers;
    private final StreamObserver<BeamFnApi.Elements> outboundObserver;
    @Nullable
    @VisibleForTesting
    ScheduledFuture<?> flushFuture;
    private long bytesWrittenSinceFlush;
    private final Object flushLock;
    private final boolean collectElementsIfNoFlushes;
    private boolean hasFlushedForBundle;

    public BeamFnDataOutboundAggregator(PipelineOptions options, Supplier<String> processBundleRequestIdSupplier, StreamObserver<BeamFnApi.Elements> outboundObserver, boolean collectElementsIfNoFlushes) {
        this.sizeLimit = BeamFnDataOutboundAggregator.getSizeLimit(options);
        this.timeLimit = BeamFnDataOutboundAggregator.getTimeLimit(options);
        this.collectElementsIfNoFlushes = collectElementsIfNoFlushes;
        this.outputDataReceivers = new HashMap();
        this.outputTimersReceivers = new HashMap();
        this.outboundObserver = outboundObserver;
        this.processBundleRequestIdSupplier = processBundleRequestIdSupplier;
        this.bytesWrittenSinceFlush = 0L;
        this.flushLock = new Object();
        this.hasFlushedForBundle = false;
    }

    public void start() {
        if (this.timeLimit > 0L && this.flushFuture == null) {
            this.flushFuture = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DataBufferOutboundFlusher-thread").build()).scheduleAtFixedRate(this::flush, this.timeLimit, this.timeLimit, TimeUnit.MILLISECONDS);
        }
    }

    public <T> FnDataReceiver<T> registerOutputDataLocation(String pTransformId, Coder<T> coder) {
        if (this.outputDataReceivers.containsKey(pTransformId)) {
            throw new IllegalStateException("Outbound data endpoint already registered for " + pTransformId);
        }
        Receiver receiver = new Receiver(coder);
        if (this.timeLimit > 0L) {
            this.outputDataReceivers.put(pTransformId, receiver);
            return data -> {
                this.checkFlushThreadException();
                Object object = this.flushLock;
                synchronized (object) {
                    receiver.accept(data);
                }
            };
        }
        this.outputDataReceivers.put(pTransformId, receiver);
        return receiver;
    }

    public <T> FnDataReceiver<T> registerOutputTimersLocation(String pTransformId, String timerFamilyId, Coder<T> coder) {
        TimerEndpoint timerKey = new TimerEndpoint(pTransformId, timerFamilyId);
        if (this.outputTimersReceivers.containsKey(timerKey)) {
            throw new IllegalStateException("Outbound timers endpoint already registered for " + timerKey);
        }
        Receiver receiver = new Receiver(coder);
        if (this.timeLimit > 0L) {
            this.outputTimersReceivers.put(timerKey, receiver);
            return timers -> {
                this.checkFlushThreadException();
                Object object = this.flushLock;
                synchronized (object) {
                    receiver.accept(timers);
                }
            };
        }
        this.outputTimersReceivers.put(timerKey, receiver);
        return receiver;
    }

    private void flushInternal() {
        if (this.bytesWrittenSinceFlush == 0L) {
            return;
        }
        BeamFnApi.Elements.Builder elements = this.convertBufferForTransmission();
        if (elements.getDataCount() > 0 || elements.getTimersCount() > 0) {
            this.outboundObserver.onNext((Object)elements.build());
        }
        this.hasFlushedForBundle = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeamFnApi.Elements sendOrCollectBufferedDataAndFinishOutboundStreams() {
        BeamFnApi.Elements.Builder bufferedElements;
        if (this.outputTimersReceivers.isEmpty() && this.outputDataReceivers.isEmpty()) {
            return null;
        }
        if (this.timeLimit > 0L) {
            Iterator<Map.Entry<Object, Receiver<?>>> iterator = this.flushLock;
            synchronized (iterator) {
                bufferedElements = this.convertBufferForTransmission();
            }
        } else {
            bufferedElements = this.convertBufferForTransmission();
        }
        LOG.debug("Closing streams for instruction {} and outbound data {} and timers {}.", new Object[]{this.processBundleRequestIdSupplier.get(), this.outputDataReceivers, this.outputTimersReceivers});
        for (Map.Entry<String, Receiver<?>> entry : this.outputDataReceivers.entrySet()) {
            String pTransformId = entry.getKey();
            bufferedElements.addDataBuilder().setInstructionId(this.processBundleRequestIdSupplier.get()).setTransformId(pTransformId).setIsLast(true);
            entry.getValue().resetStats();
        }
        for (Map.Entry<Object, Receiver<?>> entry : this.outputTimersReceivers.entrySet()) {
            TimerEndpoint timerKey = (TimerEndpoint)entry.getKey();
            bufferedElements.addTimersBuilder().setInstructionId(this.processBundleRequestIdSupplier.get()).setTransformId(timerKey.pTransformId).setTimerFamilyId(timerKey.timerFamilyId).setIsLast(true);
            entry.getValue().resetStats();
        }
        if (this.collectElementsIfNoFlushes && !this.hasFlushedForBundle) {
            return bufferedElements.build();
        }
        this.outboundObserver.onNext((Object)bufferedElements.build());
        this.hasFlushedForBundle = false;
        return null;
    }

    public void sendElements(BeamFnApi.Elements elements) {
        this.outboundObserver.onNext((Object)elements);
    }

    public void discard() {
        if (this.flushFuture != null) {
            this.flushFuture.cancel(true);
        }
    }

    private BeamFnApi.Elements.Builder convertBufferForTransmission() {
        ByteString bytes;
        BeamFnApi.Elements.Builder bufferedElements = BeamFnApi.Elements.newBuilder();
        for (Map.Entry<String, Receiver<?>> entry : this.outputDataReceivers.entrySet()) {
            if (entry.getValue().bufferedSize() == 0) continue;
            bytes = entry.getValue().toByteStringAndResetBuffer();
            bufferedElements.addDataBuilder().setInstructionId(this.processBundleRequestIdSupplier.get()).setTransformId(entry.getKey()).setData(bytes);
        }
        for (Map.Entry<Object, Receiver<?>> entry : this.outputTimersReceivers.entrySet()) {
            if (entry.getValue().bufferedSize() == 0) continue;
            bytes = entry.getValue().toByteStringAndResetBuffer();
            bufferedElements.addTimersBuilder().setInstructionId(this.processBundleRequestIdSupplier.get()).setTransformId(((TimerEndpoint)entry.getKey()).pTransformId).setTimerFamilyId(((TimerEndpoint)entry.getKey()).timerFamilyId).setTimers(bytes);
        }
        this.bytesWrittenSinceFlush = 0L;
        return bufferedElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        try {
            Object object = this.flushLock;
            synchronized (object) {
                this.flushInternal();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void checkFlushThreadException() throws IOException {
        if (this.timeLimit > 0L && this.flushFuture.isDone()) {
            try {
                this.flushFuture.get();
                throw new IOException("Periodic flushing thread finished unexpectedly.");
            }
            catch (ExecutionException ee) {
                this.unwrapExecutionException(ee);
            }
            catch (CancellationException ce) {
                throw new IOException(ce);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new IOException(ie);
            }
        }
    }

    private void unwrapExecutionException(ExecutionException ee) throws IOException {
        RuntimeException re = (RuntimeException)ee.getCause();
        if (re.getCause() instanceof IOException) {
            throw (IOException)re.getCause();
        }
        throw new IOException(re.getCause());
    }

    private static int getSizeLimit(PipelineOptions options) {
        List experiments = ((ExperimentalOptions)options.as(ExperimentalOptions.class)).getExperiments();
        for (String experiment : experiments == null ? Collections.emptyList() : experiments) {
            if (!experiment.startsWith(DATA_BUFFER_SIZE_LIMIT)) continue;
            return Integer.parseInt(experiment.substring(DATA_BUFFER_SIZE_LIMIT.length()));
        }
        return 1000000;
    }

    private static long getTimeLimit(PipelineOptions options) {
        List experiments = ((ExperimentalOptions)options.as(ExperimentalOptions.class)).getExperiments();
        for (String experiment : experiments == null ? Collections.emptyList() : experiments) {
            if (!experiment.startsWith(DATA_BUFFER_TIME_LIMIT_MS)) continue;
            return Long.parseLong(experiment.substring(DATA_BUFFER_TIME_LIMIT_MS.length()));
        }
        return -1L;
    }

    private static class TimerEndpoint {
        private final String pTransformId;
        private final String timerFamilyId;

        public TimerEndpoint(String pTransformId, String timerFamilyId) {
            this.pTransformId = pTransformId;
            this.timerFamilyId = timerFamilyId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TimerEndpoint)) {
                return false;
            }
            TimerEndpoint that = (TimerEndpoint)o;
            return this.pTransformId.equals(that.pTransformId) && this.timerFamilyId.equals(that.timerFamilyId);
        }

        public int hashCode() {
            return Objects.hash(this.pTransformId, this.timerFamilyId);
        }

        public String toString() {
            return "pTransformId: " + this.pTransformId + " timerFamilyId: " + this.timerFamilyId;
        }
    }

    @VisibleForTesting
    class Receiver<T>
    implements FnDataReceiver<T> {
        private final ByteStringOutputStream output = new ByteStringOutputStream();
        private final Coder<T> coder;
        private long perBundleByteCount;
        private long perBundleElementCount;

        public Receiver(Coder<T> coder) {
            this.coder = coder;
            this.perBundleByteCount = 0L;
            this.perBundleElementCount = 0L;
        }

        @Override
        public void accept(T input) throws Exception {
            int size = this.output.size();
            this.coder.encode(input, (OutputStream)this.output);
            if (this.output.size() - size == 0) {
                this.output.write(0);
            }
            long delta = (long)this.output.size() - (long)size;
            BeamFnDataOutboundAggregator.this.bytesWrittenSinceFlush += delta;
            this.perBundleByteCount += delta;
            ++this.perBundleElementCount;
            if (BeamFnDataOutboundAggregator.this.bytesWrittenSinceFlush > (long)BeamFnDataOutboundAggregator.this.sizeLimit) {
                BeamFnDataOutboundAggregator.this.flushInternal();
            }
        }

        public long getByteCount() {
            return this.perBundleByteCount;
        }

        public long getElementCount() {
            return this.perBundleElementCount;
        }

        public int bufferedSize() {
            return this.output.size();
        }

        public ByteString toByteStringAndResetBuffer() {
            return this.output.toByteStringAndReset();
        }

        public void resetStats() {
            this.perBundleElementCount = 0L;
            this.perBundleByteCount = 0L;
        }

        public String toString() {
            return String.format("Byte size: %s, Element count: %s", this.perBundleByteCount, this.perBundleElementCount);
        }
    }
}

