/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.ValueMetaAndData;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EnterValueDialog
extends Dialog {
    private static final Class<?> PKG = EnterValueDialog.class;
    private CCombo wValueType;
    private Text wInputString;
    private CCombo wFormat;
    private Text wLength;
    private Text wPrecision;
    private Shell shell;
    private PropsUi props = PropsUi.getInstance();
    private ValueMetaAndData valueMetaAndData;
    private IValueMeta valueMeta;
    private Object valueData;
    private boolean modalDialog;

    public EnterValueDialog(Shell parent, int style, IValueMeta value, Object data) {
        super(parent, style);
        this.valueMeta = value;
        this.valueData = data;
    }

    public ValueMetaAndData open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 0x870 | (this.modalDialog ? 0x10010000 : 0));
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"EnterValueDialog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        Label wlValueType = new Label((Composite)this.shell, 131072);
        wlValueType.setText(BaseMessages.getString(PKG, (String)"EnterValueDialog.Type.Label", (String[])new String[0]));
        this.props.setLook((Control)wlValueType);
        FormData fdlValueType = new FormData();
        fdlValueType.left = new FormAttachment(0, 0);
        fdlValueType.right = new FormAttachment(middle, -margin);
        fdlValueType.top = new FormAttachment(0, margin);
        wlValueType.setLayoutData((Object)fdlValueType);
        this.wValueType = new CCombo((Composite)this.shell, 18444);
        this.wValueType.setItems(ValueMetaFactory.getValueMetaNames());
        this.props.setLook((Control)this.wValueType);
        FormData fdValueType = new FormData();
        fdValueType.left = new FormAttachment(middle, 0);
        fdValueType.top = new FormAttachment(0, margin);
        fdValueType.right = new FormAttachment(100, -margin);
        this.wValueType.setLayoutData((Object)fdValueType);
        this.wValueType.addModifyListener(arg0 -> this.setFormats());
        Label wlInputString = new Label((Composite)this.shell, 131072);
        wlInputString.setText(BaseMessages.getString(PKG, (String)"EnterValueDialog.Value.Label", (String[])new String[0]));
        this.props.setLook((Control)wlInputString);
        FormData fdlInputString = new FormData();
        fdlInputString.left = new FormAttachment(0, 0);
        fdlInputString.right = new FormAttachment(middle, -margin);
        fdlInputString.top = new FormAttachment((Control)this.wValueType, margin);
        wlInputString.setLayoutData((Object)fdlInputString);
        this.wInputString = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wInputString);
        FormData fdInputString = new FormData();
        fdInputString.left = new FormAttachment(middle, 0);
        fdInputString.top = new FormAttachment((Control)this.wValueType, margin);
        fdInputString.right = new FormAttachment(100, -margin);
        this.wInputString.setLayoutData((Object)fdInputString);
        Label wlFormat = new Label((Composite)this.shell, 131072);
        wlFormat.setText(BaseMessages.getString(PKG, (String)"EnterValueDialog.ConversionFormat.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFormat);
        FormData fdlFormat = new FormData();
        fdlFormat.left = new FormAttachment(0, 0);
        fdlFormat.right = new FormAttachment(middle, -margin);
        fdlFormat.top = new FormAttachment((Control)this.wInputString, margin);
        wlFormat.setLayoutData((Object)fdlFormat);
        this.wFormat = new CCombo((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFormat);
        FormData fdFormat = new FormData();
        fdFormat.left = new FormAttachment(middle, 0);
        fdFormat.right = new FormAttachment(100, -margin);
        fdFormat.top = new FormAttachment((Control)this.wInputString, margin);
        this.wFormat.setLayoutData((Object)fdFormat);
        Label wlLength = new Label((Composite)this.shell, 131072);
        wlLength.setText(BaseMessages.getString(PKG, (String)"EnterValueDialog.Length.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLength);
        FormData fdlLength = new FormData();
        fdlLength.left = new FormAttachment(0, 0);
        fdlLength.right = new FormAttachment(middle, -margin);
        fdlLength.top = new FormAttachment((Control)this.wFormat, margin);
        wlLength.setLayoutData((Object)fdlLength);
        this.wLength = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wLength);
        FormData fdLength = new FormData();
        fdLength.left = new FormAttachment(middle, 0);
        fdLength.right = new FormAttachment(100, -margin);
        fdLength.top = new FormAttachment((Control)this.wFormat, margin);
        this.wLength.setLayoutData((Object)fdLength);
        Label wlPrecision = new Label((Composite)this.shell, 131072);
        wlPrecision.setText(BaseMessages.getString(PKG, (String)"EnterValueDialog.Precision.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPrecision);
        FormData fdlPrecision = new FormData();
        fdlPrecision.left = new FormAttachment(0, 0);
        fdlPrecision.right = new FormAttachment(middle, -margin);
        fdlPrecision.top = new FormAttachment((Control)this.wLength, margin);
        wlPrecision.setLayoutData((Object)fdlPrecision);
        this.wPrecision = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPrecision);
        FormData fdPrecision = new FormData();
        fdPrecision.left = new FormAttachment(middle, 0);
        fdPrecision.right = new FormAttachment(100, -margin);
        fdPrecision.top = new FormAttachment((Control)this.wLength, margin);
        this.wPrecision.setLayoutData((Object)fdPrecision);
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        Button wTest = new Button((Composite)this.shell, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"System.Button.Test", (String[])new String[0]));
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wOk, wTest, wCancel}, margin, (Control)this.wPrecision);
        wCancel.addListener(13, e -> this.cancel());
        wOk.addListener(13, e -> this.ok());
        wTest.addListener(13, e -> this.test());
        this.wInputString.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                EnterValueDialog.this.setFormats();
            }
        });
        this.wValueType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnterValueDialog.this.setFormats();
            }
        });
        this.getData();
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.valueMetaAndData;
    }

    protected void setFormats() {
        int formatIndex = this.wFormat.getSelectionIndex();
        String formatString = formatIndex >= 0 ? this.wFormat.getItem(formatIndex) : "";
        int type = ValueMetaFactory.getIdForValueMeta((String)this.wValueType.getText());
        String string = this.wInputString.getText();
        if (type != 2 && (string.startsWith(" ") || string.endsWith(" "))) {
            string = Const.trim((String)string);
            this.wInputString.setText(string);
        }
        switch (type) {
            case 5: {
                int index;
                this.wFormat.setItems(Const.getNumberFormats());
                int n = index = !Utils.isEmpty((CharSequence)formatString) ? this.wFormat.indexOf(formatString) : this.wFormat.indexOf("#");
                if (!Utils.isEmpty((CharSequence)formatString) && index < 0) {
                    this.wFormat.add(formatString);
                    index = this.wFormat.indexOf(formatString);
                }
                this.wFormat.select(index);
                break;
            }
            case 1: {
                int index;
                this.wFormat.setItems(Const.getNumberFormats());
                int n = index = !Utils.isEmpty((CharSequence)formatString) ? this.wFormat.indexOf(formatString) : this.wFormat.indexOf("#.#");
                if (!Utils.isEmpty((CharSequence)formatString) && index < 0) {
                    this.wFormat.add(formatString);
                    index = this.wFormat.indexOf(formatString);
                }
                this.wFormat.select(index);
                break;
            }
            case 3: {
                int index;
                this.wFormat.setItems(Const.getDateFormats());
                int n = index = !Utils.isEmpty((CharSequence)formatString) ? this.wFormat.indexOf(formatString) : this.wFormat.indexOf("yyyy/MM/dd HH:mm:ss");
                if (!Utils.isEmpty((CharSequence)formatString) && index < 0) {
                    this.wFormat.add(formatString);
                    index = this.wFormat.indexOf(formatString);
                }
                this.wFormat.select(index);
                break;
            }
            case 6: {
                this.wFormat.setItems(new String[0]);
                break;
            }
            default: {
                this.wFormat.setItems(new String[0]);
            }
        }
    }

    public void dispose() {
        this.shell.dispose();
    }

    public void getData() {
        this.wValueType.setText(this.valueMeta.getTypeDesc());
        try {
            String value;
            if (this.valueData != null && (value = this.valueMeta.getString(this.valueData)) != null) {
                this.wInputString.setText(value);
            }
        }
        catch (HopValueException e) {
            this.wInputString.setText(this.valueMeta.toString());
        }
        this.setFormats();
        int index = -1;
        if (!Utils.isEmpty((CharSequence)this.valueMeta.getConversionMask()) && (index = this.wFormat.indexOf(this.valueMeta.getConversionMask())) < 0) {
            this.wFormat.add(this.valueMeta.getConversionMask());
            index = this.wFormat.indexOf(this.valueMeta.getConversionMask());
        }
        if (index >= 0) {
            this.wFormat.select(index);
        }
        this.wLength.setText(Integer.toString(this.valueMeta.getLength()));
        this.wPrecision.setText(Integer.toString(this.valueMeta.getPrecision()));
        this.setFormats();
        this.wInputString.setFocus();
        this.wInputString.selectAll();
    }

    private void cancel() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.valueMeta = null;
        this.dispose();
    }

    private ValueMetaAndData getValue(String valuename) throws HopValueException {
        try {
            int valtype = ValueMetaFactory.getIdForValueMeta((String)this.wValueType.getText());
            ValueMetaAndData val = new ValueMetaAndData(valuename, (Object)this.wInputString.getText());
            IValueMeta valueMeta = ValueMetaFactory.cloneValueMeta((IValueMeta)val.getValueMeta(), (int)valtype);
            Object valueData = val.getValueData();
            int formatIndex = this.wFormat.getSelectionIndex();
            valueMeta.setConversionMask(formatIndex >= 0 ? this.wFormat.getItem(formatIndex) : this.wFormat.getText());
            valueMeta.setLength(Const.toInt((String)this.wLength.getText(), (int)-1));
            valueMeta.setPrecision(Const.toInt((String)this.wPrecision.getText(), (int)-1));
            val.setValueMeta(valueMeta);
            ValueMetaString stringValueMeta = new ValueMetaString(valuename);
            stringValueMeta.setConversionMetadata(valueMeta);
            Object targetData = stringValueMeta.convertDataUsingConversionMetaData(valueData);
            val.setValueData(targetData);
            return val;
        }
        catch (Exception e) {
            throw new HopValueException((Throwable)e);
        }
    }

    private void ok() {
        try {
            this.valueMetaAndData = this.getValue(this.valueMeta.getName());
            this.dispose();
        }
        catch (HopValueException e) {
            new ErrorDialog(this.shell, "Error", "There was a conversion error: ", (Exception)((Object)e));
        }
    }

    public void test() {
        try {
            ValueMetaAndData v = this.getValue(this.valueMeta.getName());
            MessageBox mb = new MessageBox(this.shell, 34);
            StringBuilder result = new StringBuilder();
            result.append(Const.CR).append(Const.CR).append("    ").append(v.toString());
            result.append(Const.CR).append("    ").append(v.toStringMeta());
            mb.setMessage(BaseMessages.getString(PKG, (String)"EnterValueDialog.TestResult.Message", (String[])new String[]{result.toString()}));
            mb.setText(BaseMessages.getString(PKG, (String)"EnterValueDialog.TestResult.Title", (String[])new String[0]));
            mb.open();
        }
        catch (HopValueException e) {
            new ErrorDialog(this.shell, "Error", "There was an error during data type conversion: ", (Exception)((Object)e));
        }
    }

    public boolean isModalDialog() {
        return this.modalDialog;
    }

    public void setModalDialog(boolean modalDialog) {
        this.modalDialog = modalDialog;
    }
}

