/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.InitialPartition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRangeTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ReadChangeStreamPartitionRangeTracker
extends TimestampRangeTracker {
    private final PartitionMetadata partition;

    public ReadChangeStreamPartitionRangeTracker(PartitionMetadata partition, TimestampRange range) {
        super(range);
        this.partition = partition;
    }

    @Override
    public boolean tryClaim(Timestamp position) {
        if (position.equals((Object)this.lastAttemptedPosition)) {
            return true;
        }
        return super.tryClaim(position);
    }

    @Override
    public @Nullable SplitResult<TimestampRange> trySplit(double fractionOfRemainder) {
        if (InitialPartition.isInitialPartition(this.partition.getPartitionToken())) {
            return null;
        }
        return super.trySplit(fractionOfRemainder);
    }
}

