/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.AbstractBaseUnitOfWork;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.DirectExecuteResultSet;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.base.Preconditions;
import com.google.spanner.v1.SpannerGrpc;

abstract class AbstractMultiUseTransaction
extends AbstractBaseUnitOfWork {
    AbstractMultiUseTransaction(AbstractBaseUnitOfWork.Builder<?, ? extends AbstractMultiUseTransaction> builder) {
        super(builder);
    }

    @Override
    public UnitOfWork.Type getType() {
        return UnitOfWork.Type.TRANSACTION;
    }

    @Override
    public boolean isActive() {
        return this.getState().isActive();
    }

    abstract void checkAborted();

    abstract void checkValidTransaction();

    abstract ReadContext getReadContext();

    @Override
    public ApiFuture<ResultSet> executeQueryAsync(AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        Preconditions.checkArgument((boolean)statement.isQuery(), (Object)"Statement is not a query");
        this.checkValidTransaction();
        return this.executeStatementAsync(statement, () -> {
            this.checkAborted();
            return DirectExecuteResultSet.ofResultSet(this.internalExecuteQuery(statement, analyzeMode, options));
        }, SpannerGrpc.getExecuteStreamingSqlMethod());
    }

    ResultSet internalExecuteQuery(AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        if (analyzeMode == AnalyzeMode.NONE) {
            return this.getReadContext().executeQuery(statement.getStatement(), options);
        }
        return this.getReadContext().analyzeQuery(statement.getStatement(), analyzeMode.getQueryAnalyzeMode());
    }

    @Override
    public ApiFuture<long[]> runBatchAsync() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Run batch is not supported for transactions");
    }

    @Override
    public void abortBatch() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Run batch is not supported for transactions");
    }
}

