/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.ArrayList;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ColumnPrefixFilter
extends FilterBase {
    protected byte[] prefix = null;

    public ColumnPrefixFilter(byte[] prefix) {
        this.prefix = prefix;
    }

    public byte[] getPrefix() {
        return this.prefix;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell kv) {
        if (this.prefix == null || kv.getQualifierArray() == null) {
            return Filter.ReturnCode.INCLUDE;
        }
        return this.filterColumn(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength());
    }

    @Override
    public Cell transformCell(Cell v) {
        return v;
    }

    public Filter.ReturnCode filterColumn(byte[] buffer, int qualifierOffset, int qualifierLength) {
        if (qualifierLength < this.prefix.length) {
            int cmp = Bytes.compareTo(buffer, qualifierOffset, qualifierLength, this.prefix, 0, qualifierLength);
            if (cmp <= 0) {
                return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
            }
            return Filter.ReturnCode.NEXT_ROW;
        }
        int cmp = Bytes.compareTo(buffer, qualifierOffset, this.prefix.length, this.prefix, 0, this.prefix.length);
        if (cmp < 0) {
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        if (cmp > 0) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.size() == 1, "Expected 1 but got: %s", filterArguments.size());
        byte[] columnPrefix = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        return new ColumnPrefixFilter(columnPrefix);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.ColumnPrefixFilter.Builder builder = FilterProtos.ColumnPrefixFilter.newBuilder();
        if (this.prefix != null) {
            builder.setPrefix(ByteStringer.wrap(this.prefix));
        }
        return builder.build().toByteArray();
    }

    public static ColumnPrefixFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.ColumnPrefixFilter proto;
        try {
            proto = FilterProtos.ColumnPrefixFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new ColumnPrefixFilter(proto.getPrefix().toByteArray());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnPrefixFilter)) {
            return false;
        }
        ColumnPrefixFilter other = (ColumnPrefixFilter)o;
        return Bytes.equals(this.getPrefix(), other.getPrefix());
    }

    @Override
    public Cell getNextCellHint(Cell kv) {
        return KeyValueUtil.createFirstOnRow(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), this.prefix, 0, this.prefix.length);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + Bytes.toStringBinary(this.prefix);
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return Bytes.hashCode(this.getPrefix());
    }
}

