/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.backoff;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import org.apache.hadoop.hbase.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class ClientBackoffPolicyFactory {
    private static final Log LOG = LogFactory.getLog(ClientBackoffPolicyFactory.class);

    private ClientBackoffPolicyFactory() {
    }

    public static ClientBackoffPolicy create(Configuration conf) {
        String className = conf.get("hbase.client.statistics.backoff-policy", NoBackoffPolicy.class.getName());
        return (ClientBackoffPolicy)ReflectionUtils.instantiateWithCustomCtor(className, new Class[]{Configuration.class}, new Object[]{conf});
    }

    public static class NoBackoffPolicy
    implements ClientBackoffPolicy {
        public NoBackoffPolicy(Configuration conf) {
        }

        @Override
        public long getBackoffTime(ServerName serverName, byte[] region, ServerStatistics stats) {
            return 0L;
        }
    }
}

