/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.zipfile;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.zipfile.ActionZipFile;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ActionZipFileDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionZipFile.class;
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"ActionZipFile.Filetype.Zip", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionZipFile.Filetype.All", (String[])new String[0])};
    private Text wName;
    private Button wCreateParentFolder;
    private Label wlZipFilename;
    private Button wbZipFilename;
    private TextVar wZipFilename;
    private ActionZipFile action;
    private Label wlSourceDirectory;
    private TextVar wSourceDirectory;
    private Label wlMovetoDirectory;
    private TextVar wMovetoDirectory;
    private Label wlWildcard;
    private TextVar wWildcard;
    private Label wlWildcardExclude;
    private TextVar wWildcardExclude;
    private Button wIncludeSubfolders;
    private CCombo wCompressionRate;
    private CCombo wIfFileExists;
    private CCombo wAfterZip;
    private Button wAddFileToResult;
    private Button wbSourceDirectory;
    private Button wbSourceFile;
    private Button wbMovetoDirectory;
    private Button wGetFromPrevious;
    private Label wlAddDate;
    private Button wAddDate;
    private Label wlAddTime;
    private Button wAddTime;
    private Button wbShowFiles;
    private Button wSpecifyFormat;
    private Label wlDateTimeFormat;
    private CCombo wDateTimeFormat;
    private Label wlCreateMoveToDirectory;
    private Button wCreateMoveToDirectory;
    private ComboVar wStoredSourcePathDepth;
    private boolean changed;

    public ActionZipFileDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (ActionZipFile)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionZipFile.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.Tab.General.Label", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wSourceFiles = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wSourceFiles);
        wSourceFiles.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.SourceFiles.Group.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        wSourceFiles.setLayout((Layout)groupLayout);
        Label wlGetFromPrevious = new Label((Composite)wSourceFiles, 131072);
        wlGetFromPrevious.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.getFromPrevious.Label", (String[])new String[0]));
        this.props.setLook((Control)wlGetFromPrevious);
        FormData fdlGetFromPrevious = new FormData();
        fdlGetFromPrevious.left = new FormAttachment(0, 0);
        fdlGetFromPrevious.top = new FormAttachment((Control)this.wName, margin);
        fdlGetFromPrevious.right = new FormAttachment(middle, -margin);
        wlGetFromPrevious.setLayoutData((Object)fdlGetFromPrevious);
        this.wGetFromPrevious = new Button((Composite)wSourceFiles, 32);
        this.props.setLook((Control)this.wGetFromPrevious);
        this.wGetFromPrevious.setToolTipText(BaseMessages.getString(PKG, (String)"ActionZipFile.getFromPrevious.Tooltip", (String[])new String[0]));
        FormData fdGetFromPrevious = new FormData();
        fdGetFromPrevious.left = new FormAttachment(middle, 0);
        fdGetFromPrevious.top = new FormAttachment((Control)wlGetFromPrevious, 0, 0x1000000);
        fdGetFromPrevious.right = new FormAttachment(100, 0);
        this.wGetFromPrevious.setLayoutData((Object)fdGetFromPrevious);
        this.wGetFromPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionZipFileDialog.this.action.setChanged();
                ActionZipFileDialog.this.setGetFromPrevious();
            }
        });
        this.wlSourceDirectory = new Label((Composite)wSourceFiles, 131072);
        this.wlSourceDirectory.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.SourceDir.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSourceDirectory);
        FormData fdlSourceDirectory = new FormData();
        fdlSourceDirectory.left = new FormAttachment(0, 0);
        fdlSourceDirectory.top = new FormAttachment((Control)wlGetFromPrevious, 2 * margin);
        fdlSourceDirectory.right = new FormAttachment(middle, -margin);
        this.wlSourceDirectory.setLayoutData((Object)fdlSourceDirectory);
        this.wbSourceDirectory = new Button((Composite)wSourceFiles, 0x1000008);
        this.props.setLook((Control)this.wbSourceDirectory);
        this.wbSourceDirectory.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.BrowseFolders.Label", (String[])new String[0]));
        FormData fdbSourceDirectory = new FormData();
        fdbSourceDirectory.right = new FormAttachment(100, 0);
        fdbSourceDirectory.top = new FormAttachment((Control)wlGetFromPrevious, 2 * margin);
        this.wbSourceDirectory.setLayoutData((Object)fdbSourceDirectory);
        this.wbSourceDirectory.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wSourceDirectory, (IVariables)this.variables));
        this.wbSourceFile = new Button((Composite)wSourceFiles, 0x1000008);
        this.props.setLook((Control)this.wbSourceFile);
        this.wbSourceFile.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.BrowseFiles.Label", (String[])new String[0]));
        FormData fdbSourceFile = new FormData();
        fdbSourceFile.right = new FormAttachment((Control)this.wbSourceDirectory, -margin);
        fdbSourceFile.top = new FormAttachment((Control)wlGetFromPrevious, 2 * margin);
        this.wbSourceFile.setLayoutData((Object)fdbSourceFile);
        this.wbSourceFile.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wSourceDirectory, (IVariables)this.variables, (String[])new String[]{"*"}, (String[])FILETYPES, (boolean)true));
        this.wSourceDirectory = new TextVar(this.variables, (Composite)wSourceFiles, 18436, BaseMessages.getString(PKG, (String)"ActionZipFile.SourceDir.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wSourceDirectory);
        this.wSourceDirectory.addModifyListener(lsMod);
        FormData fdSourceDirectory = new FormData();
        fdSourceDirectory.left = new FormAttachment(middle, 0);
        fdSourceDirectory.top = new FormAttachment((Control)wlGetFromPrevious, 2 * margin);
        fdSourceDirectory.right = new FormAttachment((Control)this.wbSourceFile, -margin);
        this.wSourceDirectory.setLayoutData((Object)fdSourceDirectory);
        this.wlWildcard = new Label((Composite)wSourceFiles, 131072);
        this.wlWildcard.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.Wildcard.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlWildcard);
        FormData fdlWildcard = new FormData();
        fdlWildcard.left = new FormAttachment(0, 0);
        fdlWildcard.top = new FormAttachment((Control)this.wSourceDirectory, margin);
        fdlWildcard.right = new FormAttachment(middle, -margin);
        this.wlWildcard.setLayoutData((Object)fdlWildcard);
        this.wWildcard = new TextVar(this.variables, (Composite)wSourceFiles, 18436, BaseMessages.getString(PKG, (String)"ActionZipFile.Wildcard.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wWildcard);
        this.wWildcard.addModifyListener(lsMod);
        FormData fdWildcard = new FormData();
        fdWildcard.left = new FormAttachment(middle, 0);
        fdWildcard.top = new FormAttachment((Control)this.wSourceDirectory, margin);
        fdWildcard.right = new FormAttachment(100, 0);
        this.wWildcard.setLayoutData((Object)fdWildcard);
        this.wlWildcardExclude = new Label((Composite)wSourceFiles, 131072);
        this.wlWildcardExclude.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.WildcardExclude.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlWildcardExclude);
        FormData fdlWildcardExclude = new FormData();
        fdlWildcardExclude.left = new FormAttachment(0, 0);
        fdlWildcardExclude.top = new FormAttachment((Control)this.wWildcard, margin);
        fdlWildcardExclude.right = new FormAttachment(middle, -margin);
        this.wlWildcardExclude.setLayoutData((Object)fdlWildcardExclude);
        this.wWildcardExclude = new TextVar(this.variables, (Composite)wSourceFiles, 18436, BaseMessages.getString(PKG, (String)"ActionZipFile.WildcardExclude.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wWildcardExclude);
        this.wWildcardExclude.addModifyListener(lsMod);
        FormData fdWildcardExclude = new FormData();
        fdWildcardExclude.left = new FormAttachment(middle, 0);
        fdWildcardExclude.top = new FormAttachment((Control)this.wWildcard, margin);
        fdWildcardExclude.right = new FormAttachment(100, 0);
        this.wWildcardExclude.setLayoutData((Object)fdWildcardExclude);
        Label wlIncludeSubfolders = new Label((Composite)wSourceFiles, 131072);
        wlIncludeSubfolders.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.IncludeSubfolders.Label", (String[])new String[0]));
        this.props.setLook((Control)wlIncludeSubfolders);
        FormData fdlIncludeSubfolders = new FormData();
        fdlIncludeSubfolders.left = new FormAttachment(0, 0);
        fdlIncludeSubfolders.top = new FormAttachment((Control)this.wWildcardExclude, margin);
        fdlIncludeSubfolders.right = new FormAttachment(middle, -margin);
        wlIncludeSubfolders.setLayoutData((Object)fdlIncludeSubfolders);
        this.wIncludeSubfolders = new Button((Composite)wSourceFiles, 32);
        this.props.setLook((Control)this.wIncludeSubfolders);
        this.wIncludeSubfolders.setToolTipText(BaseMessages.getString(PKG, (String)"ActionZipFile.IncludeSubfolders.Tooltip", (String[])new String[0]));
        FormData fdIncludeSubfolders = new FormData();
        fdIncludeSubfolders.left = new FormAttachment(middle, 0);
        fdIncludeSubfolders.top = new FormAttachment((Control)wlIncludeSubfolders, 0, 0x1000000);
        fdIncludeSubfolders.right = new FormAttachment(100, 0);
        this.wIncludeSubfolders.setLayoutData((Object)fdIncludeSubfolders);
        this.wIncludeSubfolders.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionZipFileDialog.this.action.setChanged();
            }
        });
        FormData fdSourceFiles = new FormData();
        fdSourceFiles.left = new FormAttachment(0, margin);
        fdSourceFiles.top = new FormAttachment((Control)this.wName, margin);
        fdSourceFiles.right = new FormAttachment(100, -margin);
        wSourceFiles.setLayoutData((Object)fdSourceFiles);
        Group wZipFile = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wZipFile);
        wZipFile.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.ZipFile.Group.Label", (String[])new String[0]));
        FormLayout groupLayoutzipfile = new FormLayout();
        groupLayoutzipfile.marginWidth = 10;
        groupLayoutzipfile.marginHeight = 10;
        wZipFile.setLayout((Layout)groupLayoutzipfile);
        this.wlZipFilename = new Label((Composite)wZipFile, 131072);
        this.wlZipFilename.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.ZipFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlZipFilename);
        FormData fdlZipFilename = new FormData();
        fdlZipFilename.left = new FormAttachment(0, 0);
        fdlZipFilename.top = new FormAttachment((Control)wSourceFiles, margin);
        fdlZipFilename.right = new FormAttachment(middle, -margin);
        this.wlZipFilename.setLayoutData((Object)fdlZipFilename);
        this.wbZipFilename = new Button((Composite)wZipFile, 0x1000008);
        this.props.setLook((Control)this.wbZipFilename);
        this.wbZipFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbZipFilename = new FormData();
        fdbZipFilename.right = new FormAttachment(100, 0);
        fdbZipFilename.top = new FormAttachment((Control)wSourceFiles, 0);
        this.wbZipFilename.setLayoutData((Object)fdbZipFilename);
        this.wZipFilename = new TextVar(this.variables, (Composite)wZipFile, 18436);
        this.props.setLook((Control)this.wZipFilename);
        this.wZipFilename.addModifyListener(lsMod);
        FormData fdZipFilename = new FormData();
        fdZipFilename.left = new FormAttachment(middle, 0);
        fdZipFilename.top = new FormAttachment((Control)wSourceFiles, margin);
        fdZipFilename.right = new FormAttachment((Control)this.wbZipFilename, -margin);
        this.wZipFilename.setLayoutData((Object)fdZipFilename);
        this.wZipFilename.addModifyListener(e -> this.wZipFilename.setToolTipText(this.variables.resolve(this.wZipFilename.getText())));
        this.wbZipFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wZipFilename, (IVariables)this.variables, (String[])new String[]{"*.zip;*.ZIP", "*"}, (String[])FILETYPES, (boolean)true));
        Label wlCreateParentFolder = new Label((Composite)wZipFile, 131072);
        wlCreateParentFolder.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.CreateParentFolder.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCreateParentFolder);
        FormData fdlCreateParentFolder = new FormData();
        fdlCreateParentFolder.left = new FormAttachment(0, 0);
        fdlCreateParentFolder.top = new FormAttachment((Control)this.wZipFilename, margin);
        fdlCreateParentFolder.right = new FormAttachment(middle, -margin);
        wlCreateParentFolder.setLayoutData((Object)fdlCreateParentFolder);
        this.wCreateParentFolder = new Button((Composite)wZipFile, 32);
        this.wCreateParentFolder.setToolTipText(BaseMessages.getString(PKG, (String)"ActionZipFile.CreateParentFolder.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCreateParentFolder);
        FormData fdCreateParentFolder = new FormData();
        fdCreateParentFolder.left = new FormAttachment(middle, 0);
        fdCreateParentFolder.top = new FormAttachment((Control)wlCreateParentFolder, 0, 0x1000000);
        fdCreateParentFolder.right = new FormAttachment(100, 0);
        this.wCreateParentFolder.setLayoutData((Object)fdCreateParentFolder);
        this.wCreateParentFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionZipFileDialog.this.action.setChanged();
            }
        });
        this.wlAddDate = new Label((Composite)wZipFile, 131072);
        this.wlAddDate.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.AddDate.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddDate);
        FormData fdlAddDate = new FormData();
        fdlAddDate.left = new FormAttachment(0, 0);
        fdlAddDate.top = new FormAttachment((Control)wlCreateParentFolder, 2 * margin);
        fdlAddDate.right = new FormAttachment(middle, -margin);
        this.wlAddDate.setLayoutData((Object)fdlAddDate);
        this.wAddDate = new Button((Composite)wZipFile, 32);
        this.props.setLook((Control)this.wAddDate);
        this.wAddDate.setToolTipText(BaseMessages.getString(PKG, (String)"ActionZipFile.AddDate.Tooltip", (String[])new String[0]));
        FormData fdAddDate = new FormData();
        fdAddDate.left = new FormAttachment(middle, 0);
        fdAddDate.top = new FormAttachment((Control)this.wlAddDate, 0, 0x1000000);
        fdAddDate.right = new FormAttachment(100, 0);
        this.wAddDate.setLayoutData((Object)fdAddDate);
        this.wAddDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionZipFileDialog.this.action.setChanged();
            }
        });
        this.wlAddTime = new Label((Composite)wZipFile, 131072);
        this.wlAddTime.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.AddTime.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddTime);
        FormData fdlAddTime = new FormData();
        fdlAddTime.left = new FormAttachment(0, 0);
        fdlAddTime.top = new FormAttachment((Control)this.wlAddDate, 2 * margin);
        fdlAddTime.right = new FormAttachment(middle, -margin);
        this.wlAddTime.setLayoutData((Object)fdlAddTime);
        this.wAddTime = new Button((Composite)wZipFile, 32);
        this.props.setLook((Control)this.wAddTime);
        this.wAddTime.setToolTipText(BaseMessages.getString(PKG, (String)"ActionZipFile.AddTime.Tooltip", (String[])new String[0]));
        FormData fdAddTime = new FormData();
        fdAddTime.left = new FormAttachment(middle, 0);
        fdAddTime.top = new FormAttachment((Control)this.wlAddTime, 0, 0x1000000);
        fdAddTime.right = new FormAttachment(100, 0);
        this.wAddTime.setLayoutData((Object)fdAddTime);
        this.wAddTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionZipFileDialog.this.action.setChanged();
            }
        });
        Label wlSpecifyFormat = new Label((Composite)wZipFile, 131072);
        wlSpecifyFormat.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.SpecifyFormat.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSpecifyFormat);
        FormData fdlSpecifyFormat = new FormData();
        fdlSpecifyFormat.left = new FormAttachment(0, 0);
        fdlSpecifyFormat.top = new FormAttachment((Control)this.wlAddTime, 2 * margin);
        fdlSpecifyFormat.right = new FormAttachment(middle, -margin);
        wlSpecifyFormat.setLayoutData((Object)fdlSpecifyFormat);
        this.wSpecifyFormat = new Button((Composite)wZipFile, 32);
        this.props.setLook((Control)this.wSpecifyFormat);
        this.wSpecifyFormat.setToolTipText(BaseMessages.getString(PKG, (String)"ActionZipFile.SpecifyFormat.Tooltip", (String[])new String[0]));
        FormData fdSpecifyFormat = new FormData();
        fdSpecifyFormat.left = new FormAttachment(middle, 0);
        fdSpecifyFormat.top = new FormAttachment((Control)wlSpecifyFormat, 0, 0x1000000);
        fdSpecifyFormat.right = new FormAttachment(100, 0);
        this.wSpecifyFormat.setLayoutData((Object)fdSpecifyFormat);
        this.wSpecifyFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionZipFileDialog.this.action.setChanged();
                ActionZipFileDialog.this.setDateTimeFormat();
            }
        });
        String[] dats = Const.getDateFormats();
        this.wlDateTimeFormat = new Label((Composite)wZipFile, 131072);
        this.wlDateTimeFormat.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.DateTimeFormat.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDateTimeFormat);
        FormData fdlDateTimeFormat = new FormData();
        fdlDateTimeFormat.left = new FormAttachment(0, 0);
        fdlDateTimeFormat.top = new FormAttachment((Control)wlSpecifyFormat, 2 * margin);
        fdlDateTimeFormat.right = new FormAttachment(middle, -margin);
        this.wlDateTimeFormat.setLayoutData((Object)fdlDateTimeFormat);
        this.wDateTimeFormat = new CCombo((Composite)wZipFile, 2056);
        this.wDateTimeFormat.setEditable(true);
        this.props.setLook((Control)this.wDateTimeFormat);
        this.wDateTimeFormat.addModifyListener(lsMod);
        FormData fdDateTimeFormat = new FormData();
        fdDateTimeFormat.left = new FormAttachment(middle, 0);
        fdDateTimeFormat.top = new FormAttachment((Control)wlSpecifyFormat, 2 * margin);
        fdDateTimeFormat.right = new FormAttachment(100, 0);
        this.wDateTimeFormat.setLayoutData((Object)fdDateTimeFormat);
        for (String dat : dats) {
            this.wDateTimeFormat.add(dat);
        }
        this.wbShowFiles = new Button((Composite)wZipFile, 0x1000008);
        this.props.setLook((Control)this.wbShowFiles);
        this.wbShowFiles.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.ShowFile.Button", (String[])new String[0]));
        FormData fdbShowFiles = new FormData();
        fdbShowFiles.left = new FormAttachment(middle, 0);
        fdbShowFiles.top = new FormAttachment((Control)this.wDateTimeFormat, margin * 2);
        this.wbShowFiles.setLayoutData((Object)fdbShowFiles);
        this.wbShowFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!Utils.isEmpty((CharSequence)ActionZipFileDialog.this.wZipFilename.getText())) {
                    ActionZipFile actionZipFile = new ActionZipFile();
                    String[] filename = new String[]{ActionZipFileDialog.this.action.getFullFilename(ActionZipFileDialog.this.wZipFilename.getText(), ActionZipFileDialog.this.wAddDate.getSelection(), ActionZipFileDialog.this.wAddTime.getSelection(), ActionZipFileDialog.this.wSpecifyFormat.getSelection(), ActionZipFileDialog.this.wDateTimeFormat.getText())};
                    if (filename != null && filename.length > 0) {
                        EnterSelectionDialog esd = new EnterSelectionDialog(ActionZipFileDialog.this.shell, filename, BaseMessages.getString(PKG, (String)"ActionZipFile.SelectOutputFiles.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionZipFile.SelectOutputFiles.DialogMessage", (String[])new String[0]));
                        esd.setViewOnly();
                        esd.open();
                    } else {
                        MessageBox mb = new MessageBox(ActionZipFileDialog.this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"ActionZipFile.NoFilesFound.DialogMessage", (String[])new String[0]));
                        mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                        mb.open();
                    }
                }
            }
        });
        FormData fdZipFile = new FormData();
        fdZipFile.left = new FormAttachment(0, margin);
        fdZipFile.top = new FormAttachment((Control)wSourceFiles, margin);
        fdZipFile.right = new FormAttachment(100, -margin);
        wZipFile.setLayoutData((Object)fdZipFile);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(500, -margin);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        this.props.setLook((Control)wGeneralComp);
        CTabItem wAdvancedTab = new CTabItem(wTabFolder, 0);
        wAdvancedTab.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.Tab.Advanced.Label", (String[])new String[0]));
        Composite wAdvancedComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wAdvancedComp);
        FormLayout advancedLayout = new FormLayout();
        advancedLayout.marginWidth = 3;
        advancedLayout.marginHeight = 3;
        wAdvancedComp.setLayout((Layout)advancedLayout);
        Group wSettings = new Group(wAdvancedComp, 32);
        this.props.setLook((Control)wSettings);
        wSettings.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.Advanced.Group.Label", (String[])new String[0]));
        FormLayout groupLayoutSettings = new FormLayout();
        groupLayoutSettings.marginWidth = 10;
        groupLayoutSettings.marginHeight = 10;
        wSettings.setLayout((Layout)groupLayoutSettings);
        Label wlCompressionRate = new Label((Composite)wSettings, 131072);
        wlCompressionRate.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.CompressionRate.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCompressionRate);
        FormData fdlCompressionRate = new FormData();
        fdlCompressionRate.left = new FormAttachment(0, -margin);
        fdlCompressionRate.right = new FormAttachment(middle, -margin);
        fdlCompressionRate.top = new FormAttachment((Control)wZipFile, margin);
        wlCompressionRate.setLayoutData((Object)fdlCompressionRate);
        this.wCompressionRate = new CCombo((Composite)wSettings, 2060);
        this.wCompressionRate.add(BaseMessages.getString(PKG, (String)"ActionZipFile.NO_COMP_CompressionRate.Label", (String[])new String[0]));
        this.wCompressionRate.add(BaseMessages.getString(PKG, (String)"ActionZipFile.DEF_COMP_CompressionRate.Label", (String[])new String[0]));
        this.wCompressionRate.add(BaseMessages.getString(PKG, (String)"ActionZipFile.BEST_COMP_CompressionRate.Label", (String[])new String[0]));
        this.wCompressionRate.add(BaseMessages.getString(PKG, (String)"ActionZipFile.BEST_SPEED_CompressionRate.Label", (String[])new String[0]));
        this.wCompressionRate.select(1);
        this.props.setLook((Control)this.wCompressionRate);
        FormData fdCompressionRate = new FormData();
        fdCompressionRate.left = new FormAttachment(middle, 0);
        fdCompressionRate.top = new FormAttachment((Control)wZipFile, margin);
        fdCompressionRate.right = new FormAttachment(100, 0);
        this.wCompressionRate.setLayoutData((Object)fdCompressionRate);
        Label wlIfFileExists = new Label((Composite)wSettings, 131072);
        wlIfFileExists.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.IfZipFileExists.Label", (String[])new String[0]));
        this.props.setLook((Control)wlIfFileExists);
        FormData fdlIfFileExists = new FormData();
        fdlIfFileExists.left = new FormAttachment(0, -margin);
        fdlIfFileExists.right = new FormAttachment(middle, -margin);
        fdlIfFileExists.top = new FormAttachment((Control)this.wCompressionRate, margin);
        wlIfFileExists.setLayoutData((Object)fdlIfFileExists);
        this.wIfFileExists = new CCombo((Composite)wSettings, 2060);
        this.wIfFileExists.add(BaseMessages.getString(PKG, (String)"ActionZipFile.Create_NewFile_IfFileExists.Label", (String[])new String[0]));
        this.wIfFileExists.add(BaseMessages.getString(PKG, (String)"ActionZipFile.Append_File_IfFileExists.Label", (String[])new String[0]));
        this.wIfFileExists.add(BaseMessages.getString(PKG, (String)"ActionZipFile.Do_Nothing_IfFileExists.Label", (String[])new String[0]));
        this.wIfFileExists.add(BaseMessages.getString(PKG, (String)"ActionZipFile.Fail_IfFileExists.Label", (String[])new String[0]));
        this.wIfFileExists.select(3);
        this.props.setLook((Control)this.wIfFileExists);
        FormData fdIfFileExists = new FormData();
        fdIfFileExists.left = new FormAttachment(middle, 0);
        fdIfFileExists.top = new FormAttachment((Control)this.wCompressionRate, margin);
        fdIfFileExists.right = new FormAttachment(100, 0);
        this.wIfFileExists.setLayoutData((Object)fdIfFileExists);
        Label wlAfterZip = new Label((Composite)wSettings, 131072);
        wlAfterZip.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.AfterZip.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAfterZip);
        FormData fdlAfterZip = new FormData();
        fdlAfterZip.left = new FormAttachment(0, -margin);
        fdlAfterZip.right = new FormAttachment(middle, -margin);
        fdlAfterZip.top = new FormAttachment((Control)this.wIfFileExists, margin);
        wlAfterZip.setLayoutData((Object)fdlAfterZip);
        this.wAfterZip = new CCombo((Composite)wSettings, 2060);
        this.wAfterZip.add(BaseMessages.getString(PKG, (String)"ActionZipFile.Do_Nothing_AfterZip.Label", (String[])new String[0]));
        this.wAfterZip.add(BaseMessages.getString(PKG, (String)"ActionZipFile.Delete_Files_AfterZip.Label", (String[])new String[0]));
        this.wAfterZip.add(BaseMessages.getString(PKG, (String)"ActionZipFile.Move_Files_AfterZip.Label", (String[])new String[0]));
        this.wAfterZip.select(0);
        this.props.setLook((Control)this.wAfterZip);
        FormData fdAfterZip = new FormData();
        fdAfterZip.left = new FormAttachment(middle, 0);
        fdAfterZip.top = new FormAttachment((Control)this.wIfFileExists, margin);
        fdAfterZip.right = new FormAttachment(100, 0);
        this.wAfterZip.setLayoutData((Object)fdAfterZip);
        this.wAfterZip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionZipFileDialog.this.afterZipActivate();
            }
        });
        this.wlMovetoDirectory = new Label((Composite)wSettings, 131072);
        this.wlMovetoDirectory.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.MovetoDirectory.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMovetoDirectory);
        FormData fdlMovetoDirectory = new FormData();
        fdlMovetoDirectory.left = new FormAttachment(0, 0);
        fdlMovetoDirectory.top = new FormAttachment((Control)this.wAfterZip, margin);
        fdlMovetoDirectory.right = new FormAttachment(middle, -margin);
        this.wlMovetoDirectory.setLayoutData((Object)fdlMovetoDirectory);
        this.wbMovetoDirectory = new Button((Composite)wSettings, 0x1000008);
        this.props.setLook((Control)this.wbMovetoDirectory);
        this.wbMovetoDirectory.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.BrowseFolders.Label", (String[])new String[0]));
        FormData fdbMovetoDirectory = new FormData();
        fdbMovetoDirectory.right = new FormAttachment(100, 0);
        fdbMovetoDirectory.top = new FormAttachment((Control)this.wAfterZip, margin);
        this.wbMovetoDirectory.setLayoutData((Object)fdbMovetoDirectory);
        this.wbMovetoDirectory.addListener(13, e -> BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wMovetoDirectory, (IVariables)this.variables));
        this.wMovetoDirectory = new TextVar(this.variables, (Composite)wSettings, 18436, BaseMessages.getString(PKG, (String)"ActionZipFile.MovetoDirectory.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wMovetoDirectory);
        this.wMovetoDirectory.addModifyListener(lsMod);
        FormData fdMovetoDirectory = new FormData();
        fdMovetoDirectory.left = new FormAttachment(middle, 0);
        fdMovetoDirectory.top = new FormAttachment((Control)this.wAfterZip, margin);
        fdMovetoDirectory.right = new FormAttachment((Control)this.wbMovetoDirectory, -margin);
        this.wMovetoDirectory.setLayoutData((Object)fdMovetoDirectory);
        this.wlCreateMoveToDirectory = new Label((Composite)wSettings, 131072);
        this.wlCreateMoveToDirectory.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.createMoveToDirectory.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCreateMoveToDirectory);
        FormData fdlCreateMoveToDirectory = new FormData();
        fdlCreateMoveToDirectory.left = new FormAttachment(0, 0);
        fdlCreateMoveToDirectory.top = new FormAttachment((Control)this.wMovetoDirectory, margin);
        fdlCreateMoveToDirectory.right = new FormAttachment(middle, -margin);
        this.wlCreateMoveToDirectory.setLayoutData((Object)fdlCreateMoveToDirectory);
        this.wCreateMoveToDirectory = new Button((Composite)wSettings, 32);
        this.props.setLook((Control)this.wCreateMoveToDirectory);
        this.wCreateMoveToDirectory.setToolTipText(BaseMessages.getString(PKG, (String)"ActionZipFile.createMoveToDirectory.Tooltip", (String[])new String[0]));
        FormData fdCreateMoveToDirectory = new FormData();
        fdCreateMoveToDirectory.left = new FormAttachment(middle, 0);
        fdCreateMoveToDirectory.top = new FormAttachment((Control)this.wlCreateMoveToDirectory, 0, 0x1000000);
        fdCreateMoveToDirectory.right = new FormAttachment(100, 0);
        this.wCreateMoveToDirectory.setLayoutData((Object)fdCreateMoveToDirectory);
        this.wCreateMoveToDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionZipFileDialog.this.action.setChanged();
            }
        });
        Label wlStoredSourcePathDepth = new Label((Composite)wSettings, 131072);
        wlStoredSourcePathDepth.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.StoredSourcePathDepth.Label", (String[])new String[0]));
        this.props.setLook((Control)wlStoredSourcePathDepth);
        FormData fdlStoredSourcePathDepth = new FormData();
        fdlStoredSourcePathDepth.left = new FormAttachment(0, 0);
        fdlStoredSourcePathDepth.top = new FormAttachment((Control)this.wlCreateMoveToDirectory, 2 * margin);
        fdlStoredSourcePathDepth.right = new FormAttachment(middle, -margin);
        wlStoredSourcePathDepth.setLayoutData((Object)fdlStoredSourcePathDepth);
        this.wStoredSourcePathDepth = new ComboVar(this.variables, (Composite)wSettings, 2052);
        this.props.setLook((Control)this.wStoredSourcePathDepth);
        this.wStoredSourcePathDepth.setToolTipText(BaseMessages.getString(PKG, (String)"ActionZipFile.StoredSourcePathDepth.Tooltip", (String[])new String[0]));
        FormData fdStoredSourcePathDepth = new FormData();
        fdStoredSourcePathDepth.left = new FormAttachment(middle, 0);
        fdStoredSourcePathDepth.top = new FormAttachment((Control)this.wlCreateMoveToDirectory, 2 * margin);
        fdStoredSourcePathDepth.right = new FormAttachment(100, 0);
        this.wStoredSourcePathDepth.setLayoutData((Object)fdStoredSourcePathDepth);
        this.wStoredSourcePathDepth.setItems(new String[]{"0 : /project-hop/work/transfer/input/project/file.txt", "1 : file.txt", "2 : project/file.txt", "3 : input/project/file.txt", "4 : transfer/input/project/file.txt", "5 : work/transfer/input/project/file.txt", "6 : project-hop/work/transfer/input/project/file.txt", "7 : project-hop/work/transfer/input/project/file.txt", "8 : project-hop/work/transfer/input/project/file.txt"});
        FormData fdSettings = new FormData();
        fdSettings.left = new FormAttachment(0, margin);
        fdSettings.top = new FormAttachment((Control)wZipFile, margin);
        fdSettings.right = new FormAttachment(100, -margin);
        wSettings.setLayoutData((Object)fdSettings);
        Group wFileResult = new Group(wAdvancedComp, 32);
        this.props.setLook((Control)wFileResult);
        wFileResult.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.FileResult.Group.Label", (String[])new String[0]));
        FormLayout groupLayoutresult = new FormLayout();
        groupLayoutresult.marginWidth = 10;
        groupLayoutresult.marginHeight = 10;
        wFileResult.setLayout((Layout)groupLayoutresult);
        Label wlAddFileToResult = new Label((Composite)wFileResult, 131072);
        wlAddFileToResult.setText(BaseMessages.getString(PKG, (String)"ActionZipFile.AddFileToResult.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAddFileToResult);
        FormData fdlAddFileToResult = new FormData();
        fdlAddFileToResult.left = new FormAttachment(0, 0);
        fdlAddFileToResult.top = new FormAttachment((Control)wSettings, margin);
        fdlAddFileToResult.right = new FormAttachment(middle, -margin);
        wlAddFileToResult.setLayoutData((Object)fdlAddFileToResult);
        this.wAddFileToResult = new Button((Composite)wFileResult, 32);
        this.props.setLook((Control)this.wAddFileToResult);
        this.wAddFileToResult.setToolTipText(BaseMessages.getString(PKG, (String)"ActionZipFile.AddFileToResult.Tooltip", (String[])new String[0]));
        FormData fdAddFileToResult = new FormData();
        fdAddFileToResult.left = new FormAttachment(middle, 0);
        fdAddFileToResult.top = new FormAttachment((Control)wlAddFileToResult, 0, 0x1000000);
        fdAddFileToResult.right = new FormAttachment(100, 0);
        this.wAddFileToResult.setLayoutData((Object)fdAddFileToResult);
        this.wAddFileToResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionZipFileDialog.this.action.setChanged();
            }
        });
        FormData fdFileResult = new FormData();
        fdFileResult.left = new FormAttachment(0, margin);
        fdFileResult.top = new FormAttachment((Control)wSettings, margin);
        fdFileResult.right = new FormAttachment(100, -margin);
        wFileResult.setLayoutData((Object)fdFileResult);
        FormData fdAdvancedComp = new FormData();
        fdAdvancedComp.left = new FormAttachment(0, 0);
        fdAdvancedComp.top = new FormAttachment(0, 0);
        fdAdvancedComp.right = new FormAttachment(100, 0);
        fdAdvancedComp.bottom = new FormAttachment(500, -margin);
        wAdvancedComp.setLayoutData((Object)fdAdvancedComp);
        wAdvancedComp.layout();
        wAdvancedTab.setControl((Control)wAdvancedComp);
        this.props.setLook((Control)wAdvancedComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.getData();
        this.setGetFromPrevious();
        this.afterZipActivate();
        this.setDateTimeFormat();
        wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void setGetFromPrevious() {
        this.wlSourceDirectory.setEnabled(!this.wGetFromPrevious.getSelection());
        this.wSourceDirectory.setEnabled(!this.wGetFromPrevious.getSelection());
        this.wWildcard.setEnabled(!this.wGetFromPrevious.getSelection());
        this.wlWildcard.setEnabled(!this.wGetFromPrevious.getSelection());
        this.wWildcardExclude.setEnabled(!this.wGetFromPrevious.getSelection());
        this.wlWildcardExclude.setEnabled(!this.wGetFromPrevious.getSelection());
        this.wbSourceDirectory.setEnabled(!this.wGetFromPrevious.getSelection());
        this.wlZipFilename.setEnabled(!this.wGetFromPrevious.getSelection());
        this.wZipFilename.setEnabled(!this.wGetFromPrevious.getSelection());
        this.wbZipFilename.setEnabled(!this.wGetFromPrevious.getSelection());
        this.wbSourceFile.setEnabled(!this.wGetFromPrevious.getSelection());
        this.wlAddDate.setEnabled(!this.wGetFromPrevious.getSelection());
        this.wAddDate.setEnabled(!this.wGetFromPrevious.getSelection());
        this.wlAddTime.setEnabled(!this.wGetFromPrevious.getSelection());
        this.wAddTime.setEnabled(!this.wGetFromPrevious.getSelection());
        this.wbShowFiles.setEnabled(!this.wGetFromPrevious.getSelection());
    }

    private void setDateTimeFormat() {
        if (this.wSpecifyFormat.getSelection()) {
            this.wAddDate.setSelection(false);
            this.wAddTime.setSelection(false);
        }
        this.wDateTimeFormat.setEnabled(this.wSpecifyFormat.getSelection());
        this.wlDateTimeFormat.setEnabled(this.wSpecifyFormat.getSelection());
        this.wAddDate.setEnabled(!this.wSpecifyFormat.getSelection());
        this.wlAddDate.setEnabled(!this.wSpecifyFormat.getSelection());
        this.wAddTime.setEnabled(!this.wSpecifyFormat.getSelection());
        this.wlAddTime.setEnabled(!this.wSpecifyFormat.getSelection());
    }

    public void afterZipActivate() {
        this.action.setChanged();
        if (this.wAfterZip.getSelectionIndex() == 2) {
            this.wMovetoDirectory.setEnabled(true);
            this.wlMovetoDirectory.setEnabled(true);
            this.wbMovetoDirectory.setEnabled(true);
            this.wlCreateMoveToDirectory.setEnabled(true);
            this.wCreateMoveToDirectory.setEnabled(true);
        } else {
            this.wMovetoDirectory.setEnabled(false);
            this.wlMovetoDirectory.setEnabled(false);
            this.wbMovetoDirectory.setEnabled(false);
            this.wlCreateMoveToDirectory.setEnabled(false);
            this.wCreateMoveToDirectory.setEnabled(true);
        }
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wZipFilename.setText(Const.nullToEmpty((String)this.action.getZipFilename()));
        if (this.action.compressionRate >= 0) {
            this.wCompressionRate.select(this.action.compressionRate);
        } else {
            this.wCompressionRate.select(1);
        }
        if (this.action.ifZipFileExists >= 0) {
            this.wIfFileExists.select(this.action.ifZipFileExists);
        } else {
            this.wIfFileExists.select(2);
        }
        this.wWildcard.setText(Const.NVL((String)this.action.getWildcard(), (String)""));
        this.wWildcardExclude.setText(Const.NVL((String)this.action.getWildcardExclude(), (String)""));
        this.wSourceDirectory.setText(Const.NVL((String)this.action.getSourceDirectory(), (String)""));
        this.wMovetoDirectory.setText(Const.NVL((String)this.action.getMoveToDirectory(), (String)""));
        if (this.action.afterZip >= 0) {
            this.wAfterZip.select(this.action.afterZip);
        } else {
            this.wAfterZip.select(0);
        }
        this.wAddFileToResult.setSelection(this.action.isAddFileToResult());
        this.wGetFromPrevious.setSelection(this.action.getDatafromprevious());
        this.wCreateParentFolder.setSelection(this.action.getcreateparentfolder());
        this.wAddDate.setSelection(this.action.isDateInFilename());
        this.wAddTime.setSelection(this.action.isTimeInFilename());
        this.wDateTimeFormat.setText(Const.NVL((String)this.action.getDateTimeFormat(), (String)""));
        this.wSpecifyFormat.setSelection(this.action.isSpecifyFormat());
        this.wCreateMoveToDirectory.setSelection(this.action.isCreateMoveToDirectory());
        this.wIncludeSubfolders.setSelection(this.action.isIncludingSubFolders());
        this.wStoredSourcePathDepth.setText(Const.NVL((String)this.action.getStoredSourcePathDepth(), (String)""));
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setZipFilename(this.wZipFilename.getText());
        this.action.compressionRate = this.wCompressionRate.getSelectionIndex();
        this.action.ifZipFileExists = this.wIfFileExists.getSelectionIndex();
        this.action.setWildcard(this.wWildcard.getText());
        this.action.setWildcardExclude(this.wWildcardExclude.getText());
        this.action.setSourceDirectory(this.wSourceDirectory.getText());
        this.action.setMoveToDirectory(this.wMovetoDirectory.getText());
        this.action.afterZip = this.wAfterZip.getSelectionIndex();
        this.action.setAddFileToResult(this.wAddFileToResult.getSelection());
        this.action.setDatafromprevious(this.wGetFromPrevious.getSelection());
        this.action.setcreateparentfolder(this.wCreateParentFolder.getSelection());
        this.action.setDateInFilename(this.wAddDate.getSelection());
        this.action.setTimeInFilename(this.wAddTime.getSelection());
        this.action.setSpecifyFormat(this.wSpecifyFormat.getSelection());
        this.action.setDateTimeFormat(this.wDateTimeFormat.getText());
        this.action.setCreateMoveToDirectory(this.wCreateMoveToDirectory.getSelection());
        this.action.setIncludingSubFolders(this.wIncludeSubfolders.getSelection());
        this.action.setStoredSourcePathDepth(this.wStoredSourcePathDepth.getText());
        this.dispose();
    }
}

