/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.ParameterizedType;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.ExposedByteArrayInputStream;
import org.apache.beam.sdk.util.ExposedByteArrayOutputStream;
import org.apache.beam.sdk.util.UnownedInputStream;
import org.apache.beam.sdk.util.UnownedOutputStream;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Throwables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.BaseEncoding;

public final class CoderUtils {
    private static ThreadLocal<SoftReference<ExposedByteArrayOutputStream>> threadLocalOutputStream = new ThreadLocal();
    private static ThreadLocal<Boolean> threadLocalOutputStreamInUse = ThreadLocal.withInitial(() -> false);

    private CoderUtils() {
    }

    public static <T> byte[] encodeToByteArray(Coder<T> coder, T value) throws CoderException {
        return CoderUtils.encodeToByteArray(coder, value, Coder.Context.OUTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> byte[] encodeToByteArray(Coder<T> coder, T value, Coder.Context context) throws CoderException {
        if (threadLocalOutputStreamInUse.get().booleanValue()) {
            ExposedByteArrayOutputStream stream = new ExposedByteArrayOutputStream();
            CoderUtils.encodeToSafeStream(coder, value, stream, context);
            return ((ByteArrayOutputStream)stream).toByteArray();
        }
        threadLocalOutputStreamInUse.set(true);
        try {
            ByteArrayOutputStream stream = CoderUtils.getThreadLocalOutputStream();
            CoderUtils.encodeToSafeStream(coder, value, stream, context);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        finally {
            threadLocalOutputStreamInUse.set(false);
        }
    }

    private static <T> void encodeToSafeStream(Coder<T> coder, T value, OutputStream stream, Coder.Context context) throws CoderException {
        try {
            coder.encode(value, new UnownedOutputStream(stream), context);
        }
        catch (IOException exn) {
            Throwables.propagateIfPossible((Throwable)exn, CoderException.class);
            throw new IllegalArgumentException("Forbidden IOException when writing to OutputStream", exn);
        }
    }

    public static <T> T decodeFromByteArray(Coder<T> coder, byte[] encodedValue) throws CoderException {
        return CoderUtils.decodeFromByteArray(coder, encodedValue, Coder.Context.OUTER);
    }

    public static <T> T decodeFromByteArray(Coder<T> coder, byte[] encodedValue, Coder.Context context) throws CoderException {
        try (ExposedByteArrayInputStream stream = new ExposedByteArrayInputStream(encodedValue);){
            T result = CoderUtils.decodeFromSafeStream(coder, stream, context);
            if (stream.available() != 0) {
                throw new CoderException(stream.available() + " unexpected extra bytes after decoding " + result);
            }
            T t = result;
            return t;
        }
    }

    public static <T> T decodeFromByteString(Coder<T> coder, ByteString encodedValue) throws IOException {
        return CoderUtils.decodeFromByteString(coder, encodedValue, Coder.Context.OUTER);
    }

    public static <T> T decodeFromByteString(Coder<T> coder, ByteString encodedValue, Coder.Context context) throws IOException {
        InputStream stream = encodedValue.newInput();
        T result = coder.decode(stream, context);
        if (stream.available() != 0) {
            throw new CoderException(stream.available() + " unexpected extra bytes after decoding " + result);
        }
        return result;
    }

    private static <T> T decodeFromSafeStream(Coder<T> coder, InputStream stream, Coder.Context context) throws CoderException {
        try {
            return coder.decode(new UnownedInputStream(stream), context);
        }
        catch (IOException exn) {
            Throwables.propagateIfPossible((Throwable)exn, CoderException.class);
            throw new IllegalArgumentException("Forbidden IOException when reading from InputStream", exn);
        }
    }

    private static ByteArrayOutputStream getThreadLocalOutputStream() {
        ExposedByteArrayOutputStream stream;
        SoftReference<ExposedByteArrayOutputStream> refStream = threadLocalOutputStream.get();
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = stream = refStream == null ? null : refStream.get();
        if (stream == null) {
            stream = new ExposedByteArrayOutputStream();
            threadLocalOutputStream.set(new SoftReference<ExposedByteArrayOutputStream>(stream));
        }
        stream.reset();
        return stream;
    }

    public static <T> T clone(Coder<T> coder, T value) throws CoderException {
        return CoderUtils.decodeFromByteArray(coder, CoderUtils.encodeToByteArray(coder, value));
    }

    public static <T> String encodeToBase64(Coder<T> coder, T value) throws CoderException {
        byte[] rawValue = CoderUtils.encodeToByteArray(coder, value);
        return BaseEncoding.base64Url().omitPadding().encode(rawValue);
    }

    public static <T> T decodeFromBase64(Coder<T> coder, String encodedValue) throws CoderException {
        return CoderUtils.decodeFromSafeStream(coder, new ByteArrayInputStream(BaseEncoding.base64Url().omitPadding().decode((CharSequence)encodedValue)), Coder.Context.OUTER);
    }

    public static TypeDescriptor getCodedType(TypeDescriptor coderDescriptor) {
        ParameterizedType coderType = (ParameterizedType)coderDescriptor.getSupertype(Coder.class).getType();
        return TypeDescriptor.of(coderType.getActualTypeArguments()[0]);
    }
}

